/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.providers.RootTypeBookmarkProvider;
import com.intellij.ide.bookmark.providers.RootTypeNode;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/ide/bookmark/providers/RootTypeBookmark;", "Lcom/intellij/ide/bookmark/Bookmark;", "provider", "Lcom/intellij/ide/bookmark/providers/RootTypeBookmarkProvider;", "type", "Lcom/intellij/ide/scratch/RootType;", "<init>", "(Lcom/intellij/ide/bookmark/providers/RootTypeBookmarkProvider;Lcom/intellij/ide/scratch/RootType;)V", "getProvider", "()Lcom/intellij/ide/bookmark/providers/RootTypeBookmarkProvider;", "getType", "()Lcom/intellij/ide/scratch/RootType;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "attributes", "", "", "getAttributes", "()Ljava/util/Map;", "createNode", "Lcom/intellij/ide/bookmark/providers/RootTypeNode;", "canNavigate", "", "canNavigateToSource", "navigate", "", "requestFocus", "hashCode", "", "equals", "other", "", "toString", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nRootTypeBookmark.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RootTypeBookmark.kt\ncom/intellij/ide/bookmark/providers/RootTypeBookmark\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class RootTypeBookmark
implements Bookmark {
    @NotNull
    private final RootTypeBookmarkProvider provider;
    @NotNull
    private final RootType type;

    public RootTypeBookmark(@NotNull RootTypeBookmarkProvider provider, @NotNull RootType type) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.provider = provider;
        this.type = type;
    }

    @NotNull
    public RootTypeBookmarkProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final RootType getType() {
        return this.type;
    }

    @Nullable
    public final VirtualFile getFile() {
        return ScratchFileService.getInstance().getVirtualFile(this.type);
    }

    @NotNull
    public Map<String, String> getAttributes() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"root.type.id", (Object)this.type.getId()));
    }

    @NotNull
    public RootTypeNode createNode() {
        return new RootTypeNode(this.getProvider().getProject(), this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canNavigate() {
        if (this.getProvider().getProject().isDisposed()) return false;
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) return false;
        if (!virtualFile.isValid()) return false;
        return true;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public void navigate(boolean requestFocus) {
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile it = virtualFile;
        boolean bl = false;
        FileSelectInContext context = new FileSelectInContext(this.getProvider().getProject(), it, null);
        List list2 = SelectInManager.getInstance((Project)this.getProvider().getProject()).getTargetList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTargetList(...)");
        Iterable iterable = list2;
        for (Object t : iterable) {
            SelectInTarget it2 = (SelectInTarget)t;
            boolean bl2 = false;
            if (!context.selectIn(it2, requestFocus)) continue;
        }
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getProvider(), this.type};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof RootTypeBookmark && Intrinsics.areEqual((Object)((RootTypeBookmark)other).getProvider(), (Object)this.getProvider()) && Intrinsics.areEqual((Object)((RootTypeBookmark)other).type, (Object)this.type);
    }

    @NotNull
    public String toString() {
        return "ScratchBookmark(module=" + this.type.getId() + ",provider=" + this.getProvider() + ")";
    }
}

