/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.tree.VirtualFileVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tree.TreeCollector;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.project.ProjectFileNodeUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000bJ$\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\t0\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/FolderNodeUpdater;", "Lcom/intellij/ui/tree/project/ProjectFileNodeUpdater;", "view", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "<init>", "(Lcom/intellij/ide/bookmark/ui/BookmarksView;)V", "getView", "()Lcom/intellij/ide/bookmark/ui/BookmarksView;", "updateStructure", "", "fromRoot", "", "updatedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "invalidate", "file", "structure", "forEachTreePath", "action", "Lkotlin/Function1;", "Ljavax/swing/tree/TreePath;", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nFolderNodeUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FolderNodeUpdater.kt\ncom/intellij/ide/bookmark/ui/tree/FolderNodeUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1625#2:51\n1869#2:52\n1870#2:54\n1626#2:55\n1869#2,2:56\n1869#2,2:58\n1#3:53\n*S KotlinDebug\n*F\n+ 1 FolderNodeUpdater.kt\ncom/intellij/ide/bookmark/ui/tree/FolderNodeUpdater\n*L\n20#1:51\n20#1:52\n20#1:54\n20#1:55\n37#1:56,2\n47#1:58,2\n20#1:53\n*E\n"})
public final class FolderNodeUpdater
extends ProjectFileNodeUpdater {
    @NotNull
    private final BookmarksView view;

    public FolderNodeUpdater(@NotNull BookmarksView view) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        super(view.getProject(), view.getModel$intellij_platform_bookmarks().getInvoker());
        this.view = view;
    }

    @NotNull
    public final BookmarksView getView() {
        return this.view;
    }

    /*
     * WARNING - void declaration
     */
    protected void updateStructure(boolean fromRoot, @NotNull Set<? extends VirtualFile> updatedFiles) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(updatedFiles, (String)"updatedFiles");
        BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)this.view.getProject());
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        Set bookmarkedFiles = new LinkedHashSet();
        List list2 = manager.getBookmarks();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBookmarks(...)");
        Iterable iterable = list2;
        Collection destination$iv = bookmarkedFiles;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            Bookmark it = (Bookmark)element$iv;
            boolean bl2 = false;
            if ((it instanceof FileBookmark && ((FileBookmark)it).getFile().isValid() ? ((FileBookmark)it).getFile() : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        if (bookmarkedFiles.isEmpty()) {
            return;
        }
        Set roots = new LinkedHashSet();
        for (VirtualFile bookmarkedFile : bookmarkedFiles) {
            TreeCollector collector;
            if (fromRoot || updatedFiles.contains(bookmarkedFile)) {
                roots.add(bookmarkedFile);
                continue;
            }
            if (!bookmarkedFile.isDirectory()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)TreeCollector.VirtualFileRoots.create(), (String)"create(...)");
            for (VirtualFile virtualFile : updatedFiles) {
                VirtualFile root;
                VirtualFile virtualFile2;
                if (virtualFile.isDirectory()) {
                    virtualFile2 = virtualFile;
                } else {
                    virtualFile2 = virtualFile.getParent();
                    if (virtualFile2 == null) continue;
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)bookmarkedFile, (VirtualFile)(root = virtualFile2), (boolean)false)) continue;
                collector.add((Object)virtualFile);
            }
            List list3 = collector.get();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"get(...)");
            roots.addAll(list3);
        }
        Iterable $this$forEach$iv = roots;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile virtualFile = (VirtualFile)element$iv;
            boolean bl = false;
            this.invalidate(virtualFile, true);
        }
    }

    public final void invalidate(@NotNull VirtualFile file, boolean structure) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.forEachTreePath(file, (Function1<? super TreePath, Unit>)((Function1)arg_0 -> FolderNodeUpdater.invalidate$lambda$0(this, structure, arg_0)));
    }

    private final void forEachTreePath(VirtualFile file, Function1<? super TreePath, Unit> action) {
        TreeModel treeModel = this.view.getTree().getModel();
        TreeVisitor.LoadingAwareAcceptor loadingAwareAcceptor = treeModel instanceof TreeVisitor.LoadingAwareAcceptor ? (TreeVisitor.LoadingAwareAcceptor)treeModel : null;
        if (loadingAwareAcceptor == null) {
            return;
        }
        TreeVisitor.LoadingAwareAcceptor model = loadingAwareAcceptor;
        List paths = new ArrayList();
        model.accept((TreeVisitor)new VirtualFileVisitor(file, paths), false).onSuccess(arg_0 -> FolderNodeUpdater.forEachTreePath$lambda$1(arg_0 -> FolderNodeUpdater.forEachTreePath$lambda$0(paths, action, arg_0), arg_0));
    }

    private static final Unit invalidate$lambda$0(FolderNodeUpdater this$0, boolean $structure, TreePath it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.view.getModel$intellij_platform_bookmarks().invalidate(it, $structure);
        return Unit.INSTANCE;
    }

    private static final Unit forEachTreePath$lambda$0(List $paths, Function1 $action, TreePath it) {
        Iterable $this$forEach$iv = $paths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            $action.invoke(element$iv);
        }
        return Unit.INSTANCE;
    }

    private static final void forEachTreePath$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

