/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.actions.BookmarkTypeChooserKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&BA\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u000e\u001a\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000f\u00a2\u0006\u0002\b\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u0010\u0015\u001a\u00020\t2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J*\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ide/bookmark/actions/BookmarkLayoutGrid;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Ljava/awt/event/KeyListener;", "current", "Lcom/intellij/ide/bookmark/BookmarkType;", "assigned", "", "onChosen", "Lkotlin/Function1;", "", "save", "Lkotlin/Function0;", "<init>", "(Lcom/intellij/ide/bookmark/BookmarkType;Ljava/util/Set;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "buttons", "Lcom/intellij/util/containers/JBIterable;", "Ljavax/swing/JButton;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "createButton", "type", "updateButtons", "offset", "", "delta", "size", "next", "Ljava/awt/Component;", "source", "dx", "dy", "point", "Ljava/awt/Point;", "keyTyped", "event", "Ljava/awt/event/KeyEvent;", "keyReleased", "keyPressed", "Companion", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nBookmarkTypeChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarkTypeChooser.kt\ncom/intellij/ide/bookmark/actions/BookmarkLayoutGrid\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,267:1\n3919#2:268\n4434#2,2:269\n3919#2:273\n4434#2,2:274\n1869#3,2:271\n1869#3,2:276\n1869#3,2:278\n*S KotlinDebug\n*F\n+ 1 BookmarkTypeChooser.kt\ncom/intellij/ide/bookmark/actions/BookmarkLayoutGrid\n*L\n157#1:268\n157#1:269,2\n167#1:273\n167#1:274,2\n158#1:271,2\n168#1:276,2\n194#1:278,2\n*E\n"})
final class BookmarkLayoutGrid
extends BorderLayoutPanel
implements KeyListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<BookmarkType> assigned;
    @NotNull
    private final Function1<BookmarkType, Unit> onChosen;
    @NotNull
    private final Function0<Unit> save;
    @NotNull
    public static final String TYPE_KEY = "BookmarkLayoutGrid.Type";

    /*
     * WARNING - void declaration
     */
    public BookmarkLayoutGrid(@Nullable BookmarkType current, @NotNull Set<? extends BookmarkType> assigned, @NotNull Function1<? super BookmarkType, Unit> onChosen, @NotNull Function0<Unit> save) {
        void $this$_init__u24lambda_u241;
        int n;
        BookmarkType[] $this$forEach$iv;
        Object it;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        JPanel $this$_init__u24lambda_u240;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter(assigned, (String)"assigned");
        Intrinsics.checkNotNullParameter(onChosen, (String)"onChosen");
        Intrinsics.checkNotNullParameter(save, (String)"save");
        this.assigned = assigned;
        this.onChosen = onChosen;
        this.save = save;
        JPanel jPanel2 = jPanel = new JPanel((LayoutManager)((Object)BookmarkTypeChooserKt.access$getSHARED_LAYOUT()));
        BookmarkLayoutGrid bookmarkLayoutGrid = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setBorder(ExperimentalUI.Companion.isNewUI() ? (Border)JBUI.Borders.emptyRight((int)14) : JBUI.Borders.empty((int)5));
        $this$_init__u24lambda_u240.setOpaque(false);
        BookmarkType[] bookmarkTypeArray = BookmarkType.values();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        int n2 = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n2; ++i) {
            it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl2 = false;
            if (!Character.isDigit(it.getMnemonic())) continue;
            collection.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            BookmarkType it2 = (BookmarkType)t;
            n = 0;
            $this$_init__u24lambda_u240.add(this.createButton(it2));
        }
        bookmarkLayoutGrid.addToLeft(jPanel);
        $this$_init__u24lambda_u240 = jPanel = new JPanel((LayoutManager)((Object)BookmarkTypeChooserKt.access$getSHARED_LAYOUT()));
        bookmarkLayoutGrid = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u241.setBorder(ExperimentalUI.Companion.isNewUI() ? (Border)JBUI.Borders.empty() : JBUI.Borders.empty((int)5));
        $this$_init__u24lambda_u241.setOpaque(false);
        $this$forEach$iv = BookmarkType.values();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        Collection collection2 = new ArrayList();
        $i$f$filterTo = false;
        n2 = ((Object)$this$filterTo$iv$iv).length;
        for (n = 0; n < n2; ++n) {
            it = element$iv$iv = $this$filterTo$iv$iv[n];
            boolean bl4 = false;
            if (!Character.isLetter(it.getMnemonic())) continue;
            collection2.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection2;
        $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            BookmarkType it3 = (BookmarkType)t;
            boolean bl5 = false;
            $this$_init__u24lambda_u241.add(this.createButton(it3));
        }
        bookmarkLayoutGrid.addToRight(jPanel);
        this.setOpaque(false);
        this.updateButtons(current);
    }

    @NotNull
    public final JBIterable<JButton> buttons() {
        JBIterable jBIterable = UIUtil.uiTraverser((Component)((Component)((Object)this))).traverse().filter(JButton.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    @NotNull
    public final JButton createButton(@NotNull BookmarkType type) {
        JButton jButton;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        JButton $this$createButton_u24lambda_u240 = jButton = new JButton(String.valueOf(type.getMnemonic()));
        boolean bl = false;
        $this$createButton_u24lambda_u240.setMnemonic(type.getMnemonic());
        $this$createButton_u24lambda_u240.setOpaque(false);
        $this$createButton_u24lambda_u240.putClientProperty("ActionToolbar.smallVariant", true);
        $this$createButton_u24lambda_u240.putClientProperty(TYPE_KEY, type);
        $this$createButton_u24lambda_u240.addPropertyChangeListener(arg_0 -> BookmarkLayoutGrid.createButton$lambda$0$0($this$createButton_u24lambda_u240, arg_0));
        $this$createButton_u24lambda_u240.addActionListener(arg_0 -> BookmarkLayoutGrid.createButton$lambda$0$1(this, type, arg_0));
        $this$createButton_u24lambda_u240.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "released");
        $this$createButton_u24lambda_u240.getInputMap().put(KeyStroke.getKeyStroke(10, 0, false), "pressed");
        $this$createButton_u24lambda_u240.setCursor(BookmarkTypeChooserKt.access$getSHARED_CURSOR());
        $this$createButton_u24lambda_u240.addKeyListener(this);
        return jButton;
    }

    public final void updateButtons(@Nullable BookmarkType current) {
        Iterable $this$forEach$iv = (Iterable)this.buttons();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JButton it = (JButton)element$iv;
            boolean bl = false;
            Object object = it.getClientProperty(TYPE_KEY);
            BookmarkType type = object instanceof BookmarkType ? (BookmarkType)object : null;
            if (type == current) {
                it.putClientProperty("JButton.textColor", BookmarkTypeChooserKt.access$getCURRENT_FOREGROUND$p());
                it.putClientProperty("JButton.backgroundColor", BookmarkTypeChooserKt.access$getCURRENT_BACKGROUND$p());
                it.putClientProperty("JButton.borderColor", BookmarkTypeChooserKt.access$getCURRENT_BACKGROUND$p());
                continue;
            }
            if (CollectionsKt.contains((Iterable)this.assigned, (Object)type)) {
                it.putClientProperty("JButton.textColor", BookmarkTypeChooserKt.access$getASSIGNED_FOREGROUND$p());
                it.putClientProperty("JButton.backgroundColor", BookmarkTypeChooserKt.access$getASSIGNED_BACKGROUND$p());
                it.putClientProperty("JButton.borderColor", BookmarkTypeChooserKt.access$getASSIGNED_BACKGROUND$p());
                continue;
            }
            it.putClientProperty("JButton.textColor", UIManager.getColor("Bookmark.MnemonicAvailable.foreground"));
            it.putClientProperty("JButton.backgroundColor", JBUI.CurrentTheme.Popup.BACKGROUND);
            it.putClientProperty("JButton.borderColor", UIManager.getColor("Bookmark.MnemonicAvailable.borderColor"));
        }
    }

    private final int offset(int delta, int size) {
        return delta < 0 ? delta : (delta > 0 ? delta + size : size / 2);
    }

    private final Component next(Component source, int dx, int dy) {
        Point point = SwingUtilities.convertPoint(source, this.offset(dx, source.getWidth()), this.offset(dy, source.getHeight()), (Component)((Object)this));
        Intrinsics.checkNotNull((Object)point);
        Component component = this.next(source, dx, dy, point);
        if (component != null || !Registry.Companion.is("ide.bookmark.mnemonic.chooser.cyclic.scrolling.allowed")) {
            return component;
        }
        if (dx > 0) {
            point.x = 0;
        }
        if (dx < 0) {
            point.x = dx + this.getWidth();
        }
        if (dy > 0) {
            point.y = 0;
        }
        if (dy < 0) {
            point.y = dy + this.getHeight();
        }
        return this.next(source, dx, dy, point);
    }

    private final Component next(Component source, int dx, int dy, Point point) {
        while (this.contains(point)) {
            Component component = SwingUtilities.getDeepestComponentAt((Component)((Object)this), point.x, point.y);
            if (component instanceof JButton) {
                return component;
            }
            point.translate(dx * source.getWidth() / 2, dy * source.getHeight() / 2);
        }
        return null;
    }

    @Override
    public void keyTyped(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    public void keyReleased(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    public void keyPressed(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getModifiersEx() == 0) {
            switch (event.getKeyCode()) {
                case 38: 
                case 224: {
                    Component component = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getComponent(...)");
                    Component component2 = this.next(component, 0, -1);
                    if (component2 != null) {
                        component2.requestFocus();
                    }
                    break;
                }
                case 40: 
                case 225: {
                    Component component = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getComponent(...)");
                    Component component3 = this.next(component, 0, 1);
                    if (component3 != null) {
                        component3.requestFocus();
                    }
                    break;
                }
                case 37: 
                case 226: {
                    Component component = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getComponent(...)");
                    Component component4 = this.next(component, -1, 0);
                    if (component4 != null) {
                        component4.requestFocus();
                    }
                    break;
                }
                case 39: 
                case 227: {
                    Component component = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getComponent(...)");
                    Component component5 = this.next(component, 1, 0);
                    if (component5 != null) {
                        component5.requestFocus();
                    }
                    break;
                }
                case 10: {
                    JButton button;
                    Component component = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getComponent(...)");
                    Component component6 = this.next(component, 0, 0);
                    JButton jButton = button = component6 instanceof JButton ? (JButton)component6 : null;
                    if (jButton != null) {
                        jButton.doClick();
                    }
                    this.save.invoke();
                    break;
                }
                default: {
                    BookmarkType type = BookmarkType.Companion.get((char)event.getKeyCode());
                    if (type == BookmarkType.DEFAULT) break;
                    this.onChosen.invoke((Object)type);
                    this.save.invoke();
                }
            }
        }
    }

    private static final void createButton$lambda$0$0(JButton $this_apply, PropertyChangeEvent it) {
        $this_apply.repaint();
    }

    private static final void createButton$lambda$0$1(BookmarkLayoutGrid this$0, BookmarkType $type, ActionEvent it) {
        this$0.onChosen.invoke((Object)$type);
        this$0.updateButtons($type);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/bookmark/actions/BookmarkLayoutGrid$Companion;", "", "<init>", "()V", "TYPE_KEY", "", "intellij.platform.bookmarks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

