/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.bookmark.ui.tree.ExtensionsKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/FolderNode;", "Lcom/intellij/ide/bookmark/ui/tree/BookmarkNode;", "Lcom/intellij/ide/bookmark/FileBookmark;", "project", "Lcom/intellij/openapi/project/Project;", "bookmark", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/bookmark/FileBookmark;)V", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.bookmarks"})
@ApiStatus.Internal
public final class FolderNode
extends BookmarkNode<FileBookmark> {
    public FolderNode(@NotNull Project project, @NotNull FileBookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        super(project, (Bookmark)bookmark);
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        FileBookmark fileBookmark = (FileBookmark)this.getValue();
        return fileBookmark != null ? fileBookmark.getFile() : null;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        return ExtensionsKt.computeDirectoryChildren(this);
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        Pair<String, Icon> scratch = ExtensionsKt.computeScratchPresentation(this, file);
        if (scratch == null) {
            super.update(presentation);
        } else {
            Icon icon = (Icon)scratch.getSecond();
            if (icon == null) {
                icon = ExtensionsKt.findFileIcon(this);
            }
            presentation.setIcon(this.wrapIcon(icon));
            BookmarkNode.addTextTo$default(this, presentation, (String)scratch.getFirst(), null, 0, 12, null);
        }
    }
}

