/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.lang.ZipFilePool;
import com.intellij.util.lang.ZipResourceFile;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class PathClassLoader
extends UrlClassLoader {
    @VisibleForTesting
    public static final String RESET_CLASSPATH_FROM_MANIFEST_PROPERTY = "idea.reset.classpath.from.manifest";
    static final Function<Path, ResourceFile> RESOURCE_FILE_FACTORY;
    private static final boolean isParallelCapable;
    private BytecodeTransformer transformer;

    public PathClassLoader(@NotNull UrlClassLoader.Builder builder) {
        if (builder == null) {
            PathClassLoader.$$$reportNull$$$0(0);
        }
        super(builder, RESOURCE_FILE_FACTORY, isParallelCapable);
        PathClassLoader.parseManifestAndResetClassPath(this.classPath);
    }

    public void reset(Collection<Path> newClassPath) {
        this.classPath.reset(newClassPath);
    }

    public static Function<Path, ResourceFile> getResourceFileFactory() {
        return RESOURCE_FILE_FACTORY;
    }

    public void setTransformer(BytecodeTransformer transformer) {
        assert (this.transformer == null);
        this.transformer = transformer;
    }

    public PathClassLoader(@NotNull ClassLoader parent) {
        if (parent == null) {
            PathClassLoader.$$$reportNull$$$0(1);
        }
        super(PathClassLoader.createDefaultBuilderForJdk((ClassLoader)parent), RESOURCE_FILE_FACTORY, isParallelCapable);
        this.transformer = null;
        PathClassLoader.registerInClassLoaderValueMap((ClassLoader)parent, (ClassLoader)((Object)this));
        PathClassLoader.parseManifestAndResetClassPath(this.classPath);
    }

    public boolean isByteBufferSupported(@NotNull String name) {
        if (name == null) {
            PathClassLoader.$$$reportNull$$$0(2);
        }
        return this.transformer == null || !this.transformer.isApplicable(name, (ClassLoader)((Object)this));
    }

    protected boolean isPackageDefined(String packageName) {
        return this.getDefinedPackage(packageName) != null;
    }

    public Class<?> consumeClassData(@NotNull String name, byte[] data) throws IOException {
        byte[] transformedData;
        BytecodeTransformer transformer;
        if (name == null) {
            PathClassLoader.$$$reportNull$$$0(3);
        }
        if ((transformer = this.transformer) != null && transformer.isApplicable(name, (ClassLoader)((Object)this)) && (transformedData = transformer.transform((ClassLoader)((Object)this), name, data)) != null) {
            return super.consumeClassData(name, transformedData);
        }
        return super.consumeClassData(name, data);
    }

    private static void parseManifestAndResetClassPath(@NotNull ClassPath classPath) {
        String systemProp;
        if (classPath == null) {
            PathClassLoader.$$$reportNull$$$0(4);
        }
        if ((systemProp = System.getProperty(RESET_CLASSPATH_FROM_MANIFEST_PROPERTY)) == null || classPath.getFiles().size() != 1) {
            return;
        }
        try {
            Path jarPath = (Path)classPath.getFiles().get(0);
            try (JarFile zipFile = new JarFile(jarPath.toFile());){
                Manifest manifest = zipFile.getManifest();
                if (manifest == null) {
                    return;
                }
                String classPathAttr = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                if (classPathAttr == null) {
                    return;
                }
                String[] paths = classPathAttr.split(" ");
                ArrayList<Path> newPaths = new ArrayList<Path>(paths.length);
                for (String path : paths) {
                    if (!path.startsWith("file:")) {
                        throw new IllegalArgumentException("Classpath entry must be a file: URL: " + path);
                    }
                    newPaths.add(Paths.get(PathClassLoader.urlToFilePath((String)path), new String[0]));
                }
                classPath.reset(newPaths);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        boolean defineClassUsingBytes = Boolean.parseBoolean(System.getProperty("idea.define.class.using.byte.array", "false"));
        ZipFilePool zipPool = ZipFilePool.PATH_CLASSLOADER_POOL;
        RESOURCE_FILE_FACTORY = !defineClassUsingBytes && System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows") ? file -> {
            String path = file.toString();
            return new ZipResourceFile((Path)file, path.length() > 2 && path.charAt(0) == '\\' && path.charAt(1) == '\\', zipPool);
        } : file -> new ZipResourceFile((Path)file, defineClassUsingBytes, zipPool);
        isParallelCapable = PathClassLoader.registerAsParallelCapable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/lang/PathClassLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isByteBufferSupported";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeClassData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseManifestAndResetClassPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface BytecodeTransformer {
        default public boolean isApplicable(String className, ClassLoader loader) {
            return true;
        }

        public byte @Nullable [] transform(ClassLoader var1, String var2, byte[] var3);
    }
}

