/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.bootstrap;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.PathResolverKt;
import com.intellij.ide.plugins.PluginModuleId;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorBuilder;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorFromXmlStreamConsumer;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorReaderContext;
import com.intellij.platform.plugins.parser.impl.PluginXmlStreamConsumer;
import com.intellij.platform.plugins.parser.impl.PluginXmlStreamConsumerKt;
import com.intellij.platform.plugins.parser.impl.XIncludeLoader;
import com.intellij.platform.runtime.repository.RuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0001J#\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000eH\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/bootstrap/RunningFromSourceModuleBasedPathResolver;", "Lcom/intellij/ide/plugins/PathResolver;", "moduleRepository", "Lcom/intellij/platform/runtime/repository/RuntimeModuleRepository;", "fallbackResolver", "<init>", "(Lcom/intellij/platform/runtime/repository/RuntimeModuleRepository;Lcom/intellij/ide/plugins/PathResolver;)V", "resolveModuleFile", "Lcom/intellij/platform/plugins/parser/impl/PluginDescriptorBuilder;", "readContext", "Lcom/intellij/platform/plugins/parser/impl/PluginDescriptorReaderContext;", "dataLoader", "Lcom/intellij/ide/plugins/DataLoader;", "path", "", "resolveCustomModuleClassesRoots", "", "Ljava/nio/file/Path;", "moduleId", "Lcom/intellij/ide/plugins/PluginModuleId;", "loadXIncludeReference", "Lcom/intellij/platform/plugins/parser/impl/XIncludeLoader$LoadedXIncludeReference;", "resolvePath", "relativePath", "isFlat", "", "()Z", "intellij.platform.bootstrap"})
public final class RunningFromSourceModuleBasedPathResolver
implements PathResolver {
    @NotNull
    private final RuntimeModuleRepository moduleRepository;
    @NotNull
    private final PathResolver fallbackResolver;

    public RunningFromSourceModuleBasedPathResolver(@NotNull RuntimeModuleRepository moduleRepository, @NotNull PathResolver fallbackResolver) {
        Intrinsics.checkNotNullParameter((Object)moduleRepository, (String)"moduleRepository");
        Intrinsics.checkNotNullParameter((Object)fallbackResolver, (String)"fallbackResolver");
        this.moduleRepository = moduleRepository;
        this.fallbackResolver = fallbackResolver;
    }

    @NotNull
    public PluginDescriptorBuilder resolveModuleFile(@NotNull PluginDescriptorReaderContext readContext, @NotNull DataLoader dataLoader, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String moduleName = StringsKt.removeSuffix((String)path, (CharSequence)".xml");
        RuntimeModuleDescriptor moduleDescriptor = this.moduleRepository.resolveModule(RuntimeModuleId.module((String)moduleName)).getResolvedModule();
        if (moduleDescriptor != null) {
            InputStream inputStream = moduleDescriptor.readFile(path);
            if (inputStream == null) {
                throw new IllegalStateException(("Cannot resolve " + path + " in " + moduleDescriptor).toString());
            }
            InputStream input = inputStream;
            PluginDescriptorFromXmlStreamConsumer reader = new PluginDescriptorFromXmlStreamConsumer(readContext, PathResolverKt.toXIncludeLoader((PathResolver)this, (DataLoader)dataLoader));
            PluginXmlStreamConsumerKt.consume((PluginXmlStreamConsumer)((PluginXmlStreamConsumer)reader), (InputStream)input, (String)path);
            return reader.getBuilder();
        }
        return this.fallbackResolver.resolveModuleFile(readContext, dataLoader, path);
    }

    @NotNull
    public List<Path> resolveCustomModuleClassesRoots(@NotNull PluginModuleId moduleId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        RuntimeModuleDescriptor moduleDescriptor = this.moduleRepository.resolveModule(RuntimeModuleId.raw((String)moduleId.getName())).getResolvedModule();
        Object object2 = moduleDescriptor;
        boolean bl = object2 != null && (object2 = object2.getModuleId()) != null && (object2 = object2.getStringId()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object2), (CharSequence)".charts", (boolean)false, (int)2, null) : false;
        if (bl) {
            // empty if block
        }
        if ((object = moduleDescriptor) == null || (object = object.getResourceRootPaths()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public XIncludeLoader.LoadedXIncludeReference loadXIncludeReference(@NotNull DataLoader dataLoader, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)dataLoader, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.fallbackResolver.loadXIncludeReference(dataLoader, path);
    }

    @Nullable
    public PluginDescriptorBuilder resolvePath(@NotNull PluginDescriptorReaderContext readContext, @NotNull DataLoader dataLoader, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return this.fallbackResolver.resolvePath(readContext, dataLoader, relativePath);
    }

    public boolean isFlat() {
        return this.fallbackResolver.isFlat();
    }
}

