/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.startup.multiProcess;

import com.intellij.openapi.application.PathCustomizer;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.impl.P3Support;
import com.intellij.openapi.project.impl.P3SupportInstaller;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.platform.ide.impl.startup.multiProcess.ClientP3Support;
import com.intellij.platform.ide.impl.startup.multiProcess.PerProcessPathCustomization;
import com.intellij.util.UriUtilKt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class FrontendProcessPathCustomizer
implements PathCustomizer {
    public static final String PLUGINS_MIGRATED_MARKER = "frontend-plugins-migrated.txt";
    private static final String LOCK_FILE_NAME = "process.lock";
    private static final Set<String> FILES_TO_KEEP = ContainerUtil.newHashSet((Object[])new String[]{"process.lock", ".pid", ".appinfo"});
    private static FileLock ourConfigLock;

    public PathCustomizer.CustomPaths customizePaths(@NotNull List<String> args) {
        Path newConfig;
        FileLock configLock;
        if (args == null) {
            FrontendProcessPathCustomizer.$$$reportNull$$$0(0);
        }
        FrontendProcessPathCustomizer.updatePathSelectorForCommunityEditions(args);
        Path basePerProcessDir = FrontendProcessPathCustomizer.getFolderForPerProcessData();
        int directoryCounter = 0;
        while (true) {
            if ((configLock = FrontendProcessPathCustomizer.tryLockDirectory(newConfig = basePerProcessDir.resolve("per_process_config_" + directoryCounter))) != null) break;
            if (directoryCounter > 1000) {
                System.err.println("Can't lock temp directories in " + String.valueOf(basePerProcessDir));
                return null;
            }
            ++directoryCounter;
        }
        ourConfigLock = configLock;
        Path newSystem = basePerProcessDir.resolve("per_process_system_" + directoryCounter);
        Path baseLogDir = FrontendProcessPathCustomizer.getBaseLogDir();
        Path newLog = FrontendProcessPathCustomizer.computeLogDirPath(baseLogDir, directoryCounter);
        if (newLog == null) {
            System.err.println("Can't create log directory in " + String.valueOf(baseLogDir));
            return null;
        }
        FrontendProcessPathCustomizer.cleanDirectory(newConfig);
        FrontendProcessPathCustomizer.cleanDirectory(newSystem);
        P3SupportInstaller.INSTANCE.installPerProcessInstanceSupportImplementation((P3Support)new ClientP3Support());
        String originalPluginsPath = PathManager.getPluginsPath();
        boolean customizePluginsPath = FrontendProcessPathCustomizer.useCustomPluginsPath(originalPluginsPath);
        String pluginsPath = customizePluginsPath ? originalPluginsPath + File.separator + "frontend" : originalPluginsPath;
        boolean migratePlugins = customizePluginsPath && !Files.exists(Paths.get(pluginsPath, PLUGINS_MIGRATED_MARKER), new LinkOption[0]);
        PerProcessPathCustomization.prepareConfig(newConfig, PathManager.getConfigDir(), migratePlugins);
        Path startupScriptDir = PerProcessPathCustomization.getStartupScriptDir().resolve("frontend");
        return new PathCustomizer.CustomPaths(newConfig.toString(), newSystem.toString(), pluginsPath, newLog.toString(), startupScriptDir);
    }

    private static void updatePathSelectorForCommunityEditions(@NotNull List<String> args) {
        boolean isPyCharmProfessionalInstallation;
        String pathsSelector;
        if (args == null) {
            FrontendProcessPathCustomizer.$$$reportNull$$$0(1);
        }
        if ((pathsSelector = PathManager.getPathsSelector()) == null) {
            return;
        }
        String ideaUltimateSelector = "IntelliJIdea";
        String pycharmProfessionalSelector = "PyCharm";
        String pycharmCommunitySelector = "PyCharmCE";
        boolean isIdeaUltimateInstallation = pathsSelector.startsWith(ideaUltimateSelector);
        boolean bl = isPyCharmProfessionalInstallation = pathsSelector.startsWith(pycharmProfessionalSelector) && !pathsSelector.startsWith(pycharmCommunitySelector);
        if (!isIdeaUltimateInstallation && !isPyCharmProfessionalInstallation || args.size() < 2 || !"thinClient".equals(args.get(0))) {
            return;
        }
        try {
            URI uri = new URI(args.get(1));
            String productCode = (String)UriUtilKt.getFragmentParameters((URI)uri).get("p");
            if ("IC".equals(productCode) && isIdeaUltimateInstallation) {
                PathManager.setPathSelector((String)("IdeaIC" + pathsSelector.substring(ideaUltimateSelector.length())));
            } else if ("PC".equals(productCode) && isPyCharmProfessionalInstallation) {
                PathManager.setPathSelector((String)(pycharmCommunitySelector + pathsSelector.substring(pycharmProfessionalSelector.length())));
            }
        }
        catch (URISyntaxException e) {
            System.err.println("Failed to update path selector: " + String.valueOf(e));
        }
    }

    @NotNull
    private static Path getFolderForPerProcessData() {
        String pathsSelector = PathManager.getPathsSelector();
        if (pathsSelector != null && !FrontendProcessPathCustomizer.isGenericJetBrainsClient(pathsSelector)) {
            Path path = PathManager.getSystemDir().resolve("frontend");
            if (path == null) {
                FrontendProcessPathCustomizer.$$$reportNull$$$0(2);
            }
            return path;
        }
        Path path = Paths.get(PathManager.getTempPath(), new String[0]);
        if (path == null) {
            FrontendProcessPathCustomizer.$$$reportNull$$$0(3);
        }
        return path;
    }

    private static boolean isGenericJetBrainsClient(String pathsSelector) {
        return pathsSelector.startsWith("JetBrainsClient");
    }

    @NotNull
    private static Path getBaseLogDir() {
        String baseLogDirPath = PathManager.getLogPath();
        String pathsSelector = PathManager.getPathsSelector();
        if (pathsSelector != null && baseLogDirPath.equals(PathManager.getDefaultLogPathFor((String)pathsSelector)) && !FrontendProcessPathCustomizer.isGenericJetBrainsClient(pathsSelector)) {
            Path path = Paths.get(baseLogDirPath, "frontend");
            if (path == null) {
                FrontendProcessPathCustomizer.$$$reportNull$$$0(4);
            }
            return path;
        }
        Path path = Paths.get(baseLogDirPath, new String[0]);
        if (path == null) {
            FrontendProcessPathCustomizer.$$$reportNull$$$0(5);
        }
        return path;
    }

    private static boolean useCustomPluginsPath(String originalPluginsPath) {
        String pathsSelector = PathManager.getPathsSelector();
        return pathsSelector != null && !FrontendProcessPathCustomizer.isGenericJetBrainsClient(pathsSelector) && originalPluginsPath.equals(PathManager.getDefaultPluginPathFor((String)pathsSelector));
    }

    @Nullable
    private static Path computeLogDirPath(Path baseLogDir, int directoryCounter) {
        Object nameSuffix;
        String namePrefix = DateTimeFormatter.ofPattern("yyyy-MM-dd_'at'_HH-mm-ss").format(LocalDateTime.now());
        Path logPath = baseLogDir.resolve(namePrefix + (String)(nameSuffix = directoryCounter > 0 ? "_" + directoryCounter : ""));
        if (!Files.exists(logPath, new LinkOption[0])) {
            return logPath;
        }
        for (int i = 1; i < 1000; ++i) {
            Path newLogPath = baseLogDir.resolve(String.format("%s-%03d%s", namePrefix, i, nameSuffix));
            if (Files.exists(newLogPath, new LinkOption[0])) continue;
            return newLogPath;
        }
        return null;
    }

    @Nullable
    private static FileLock tryLockDirectory(@NotNull Path directory) {
        if (directory == null) {
            FrontendProcessPathCustomizer.$$$reportNull$$$0(6);
        }
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
            Path lockFile = directory.resolve(LOCK_FILE_NAME);
            FileChannel fc = FileChannel.open(lockFile, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
            return fc.tryLock();
        }
        catch (IOException ignore) {
            return null;
        }
    }

    private static void cleanDirectory(@NotNull Path directory) {
        if (directory == null) {
            FrontendProcessPathCustomizer.$$$reportNull$$$0(7);
        }
        try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(directory);){
            for (Path path : stream2) {
                if (FILES_TO_KEEP.contains(path.getFileName().toString())) continue;
                try {
                    NioFiles.deleteRecursively((Path)path);
                }
                catch (IOException e) {
                    System.err.println("Failed to delete " + String.valueOf(path) + ": " + String.valueOf(e));
                }
            }
        }
        catch (NoSuchFileException stream2) {
        }
        catch (IOException e) {
            System.err.println("Failed to clean directory " + String.valueOf(directory) + ": " + String.valueOf(e));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/ide/impl/startup/multiProcess/FrontendProcessPathCustomizer";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/ide/impl/startup/multiProcess/FrontendProcessPathCustomizer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolderForPerProcessData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLogDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizePaths";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updatePathSelectorForCommunityEditions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryLockDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cleanDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

