/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.bootstrap;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.PathResolverKt;
import com.intellij.ide.plugins.PluginModuleId;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorBuilder;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorFromXmlStreamConsumer;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorReaderContext;
import com.intellij.platform.plugins.parser.impl.PluginXmlStreamConsumer;
import com.intellij.platform.plugins.parser.impl.PluginXmlStreamConsumerKt;
import com.intellij.platform.plugins.parser.impl.XIncludeLoader;
import com.intellij.platform.plugins.parser.impl.elements.DependenciesElement;
import com.intellij.platform.runtime.product.IncludedRuntimeModule;
import com.intellij.platform.runtime.repository.RuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BE\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\t\u0012\u0006\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/platform/bootstrap/ModuleBasedPluginXmlPathResolver;", "Lcom/intellij/ide/plugins/PathResolver;", "includedModules", "", "Lcom/intellij/platform/runtime/product/IncludedRuntimeModule;", "optionalModuleIds", "", "Lcom/intellij/platform/runtime/repository/RuntimeModuleId;", "notLoadedModuleIds", "", "fallbackResolver", "<init>", "(Ljava/util/List;Ljava/util/Set;Ljava/util/Map;Lcom/intellij/ide/plugins/PathResolver;)V", "resolveModuleFile", "Lcom/intellij/platform/plugins/parser/impl/PluginDescriptorBuilder;", "readContext", "Lcom/intellij/platform/plugins/parser/impl/PluginDescriptorReaderContext;", "dataLoader", "Lcom/intellij/ide/plugins/DataLoader;", "path", "", "resolveCustomModuleClassesRoots", "Ljava/nio/file/Path;", "moduleId", "Lcom/intellij/ide/plugins/PluginModuleId;", "loadXIncludeReference", "Lcom/intellij/platform/plugins/parser/impl/XIncludeLoader$LoadedXIncludeReference;", "resolvePath", "relativePath", "intellij.platform.bootstrap"})
@SourceDebugExtension(value={"SMAP\nModuleBasedPluginXmlPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleBasedPluginXmlPathResolver.kt\ncom/intellij/platform/bootstrap/ModuleBasedPluginXmlPathResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class ModuleBasedPluginXmlPathResolver
implements PathResolver {
    @NotNull
    private final List<IncludedRuntimeModule> includedModules;
    @NotNull
    private final Set<RuntimeModuleId> optionalModuleIds;
    @NotNull
    private final Map<RuntimeModuleId, List<RuntimeModuleId>> notLoadedModuleIds;
    @NotNull
    private final PathResolver fallbackResolver;

    public ModuleBasedPluginXmlPathResolver(@NotNull List<? extends IncludedRuntimeModule> includedModules, @NotNull Set<RuntimeModuleId> optionalModuleIds, @NotNull Map<RuntimeModuleId, ? extends List<RuntimeModuleId>> notLoadedModuleIds, @NotNull PathResolver fallbackResolver) {
        Intrinsics.checkNotNullParameter(includedModules, (String)"includedModules");
        Intrinsics.checkNotNullParameter(optionalModuleIds, (String)"optionalModuleIds");
        Intrinsics.checkNotNullParameter(notLoadedModuleIds, (String)"notLoadedModuleIds");
        Intrinsics.checkNotNullParameter((Object)fallbackResolver, (String)"fallbackResolver");
        this.includedModules = includedModules;
        this.optionalModuleIds = optionalModuleIds;
        this.notLoadedModuleIds = notLoadedModuleIds;
        this.fallbackResolver = fallbackResolver;
    }

    @NotNull
    public PluginDescriptorBuilder resolveModuleFile(@NotNull PluginDescriptorReaderContext readContext, @NotNull DataLoader dataLoader, @NotNull String path) {
        RuntimeModuleDescriptor moduleDescriptor;
        Object v0;
        String moduleName;
        block8: {
            Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
            Intrinsics.checkNotNullParameter((Object)dataLoader, (String)"dataLoader");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            moduleName = StringsKt.removeSuffix((String)path, (CharSequence)".xml");
            Iterable iterable = this.includedModules;
            for (Object t : iterable) {
                IncludedRuntimeModule it = (IncludedRuntimeModule)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getModuleDescriptor().getModuleId().getStringId(), (Object)moduleName)) continue;
                v0 = t;
                break block8;
            }
            v0 = null;
        }
        IncludedRuntimeModule includedRuntimeModule = v0;
        Object object = moduleDescriptor = includedRuntimeModule != null ? includedRuntimeModule.getModuleDescriptor() : null;
        if (moduleDescriptor != null) {
            InputStream inputStream = moduleDescriptor.readFile(path);
            if (inputStream == null) {
                throw new IllegalStateException(("Cannot resolve " + path + " in " + moduleDescriptor).toString());
            }
            InputStream input = inputStream;
            PluginDescriptorFromXmlStreamConsumer reader = new PluginDescriptorFromXmlStreamConsumer(readContext, PathResolverKt.toXIncludeLoader((PathResolver)this, (DataLoader)dataLoader));
            PluginXmlStreamConsumerKt.consume((PluginXmlStreamConsumer)((PluginXmlStreamConsumer)reader), (InputStream)input, (String)path);
            return reader.getBuilder();
        }
        RuntimeModuleId runtimeModuleId = RuntimeModuleId.module((String)moduleName);
        Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId, (String)"module(...)");
        RuntimeModuleId moduleId = runtimeModuleId;
        if (this.optionalModuleIds.contains(moduleId)) {
            List reasonsWhyNotLoaded;
            PluginDescriptorBuilder pluginDescriptorBuilder;
            PluginDescriptorBuilder $this$resolveModuleFile_u24lambda_u241 = pluginDescriptorBuilder = PluginDescriptorBuilder.Companion.builder();
            boolean bl = false;
            $this$resolveModuleFile_u24lambda_u241.setPackage("unresolved." + moduleName);
            List list = this.notLoadedModuleIds.get(moduleId);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            if (!((Collection)(reasonsWhyNotLoaded = list)).isEmpty()) {
                for (RuntimeModuleId reason : reasonsWhyNotLoaded) {
                    String string = reason.getStringId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringId(...)");
                    $this$resolveModuleFile_u24lambda_u241.addDependency((DependenciesElement)new DependenciesElement.ModuleDependency(string, null));
                }
            } else {
                $this$resolveModuleFile_u24lambda_u241.addDependency((DependenciesElement)new DependenciesElement.ModuleDependency("incompatible.with.product.mode.or.unresolved", null));
            }
            return pluginDescriptorBuilder;
        }
        return this.fallbackResolver.resolveModuleFile(readContext, dataLoader, path);
    }

    @NotNull
    public List<Path> resolveCustomModuleClassesRoots(@NotNull PluginModuleId moduleId) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
            Iterable iterable = this.includedModules;
            for (Object t : iterable) {
                IncludedRuntimeModule it = (IncludedRuntimeModule)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getModuleDescriptor().getModuleId().getStringId(), (Object)moduleId.getName())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        IncludedRuntimeModule includedRuntimeModule = v0;
        Object moduleDescriptor = includedRuntimeModule != null ? includedRuntimeModule.getModuleDescriptor() : null;
        Object object = moduleDescriptor;
        if (object == null || (object = object.getResourceRootPaths()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public XIncludeLoader.LoadedXIncludeReference loadXIncludeReference(@NotNull DataLoader dataLoader, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)dataLoader, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.fallbackResolver.loadXIncludeReference(dataLoader, path);
    }

    @Nullable
    public PluginDescriptorBuilder resolvePath(@NotNull PluginDescriptorReaderContext readContext, @NotNull DataLoader dataLoader, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return this.fallbackResolver.resolvePath(readContext, dataLoader, relativePath);
    }
}

