/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.startup.multiProcess;

import com.intellij.openapi.application.PathCustomizer;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ex.P3PathsEx;
import com.intellij.openapi.project.impl.P3Support;
import com.intellij.openapi.project.impl.P3SupportInstaller;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.platform.ide.impl.startup.multiProcess.P3SupportImpl;
import com.intellij.platform.ide.impl.startup.multiProcess.PerProcessPathCustomization;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/ide/impl/startup/multiProcess/P3PathCustomizer;", "Lcom/intellij/openapi/application/PathCustomizer;", "<init>", "()V", "customizePaths", "Lcom/intellij/openapi/application/PathCustomizer$CustomPaths;", "args", "", "", "Companion", "intellij.platform.bootstrap"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nP3PathCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P3PathCustomizer.kt\ncom/intellij/platform/ide/impl/startup/multiProcess/P3PathCustomizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,150:1\n23#2:151\n*S KotlinDebug\n*F\n+ 1 P3PathCustomizer.kt\ncom/intellij/platform/ide/impl/startup/multiProcess/P3PathCustomizer\n*L\n51#1:151\n*E\n"})
public final class P3PathCustomizer
implements PathCustomizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String OPTION_NAME = "p3.project.location";

    @NotNull
    public PathCustomizer.CustomPaths customizePaths(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        String projectLocation = System.getProperty(OPTION_NAME);
        CharSequence charSequence = projectLocation;
        if (charSequence == null || charSequence.length() == 0) {
            projectLocation = "JetBrains_P3_Default_Project_Location";
        }
        Path projectStoreBaseDir = Path.of(projectLocation, new String[0]);
        Intrinsics.checkNotNull((Object)projectStoreBaseDir);
        P3PathsEx paths = new P3PathsEx(projectStoreBaseDir);
        Files.createDirectories(paths.getConfigDir(), new FileAttribute[0]);
        P3SupportInstaller.INSTANCE.installPerProcessInstanceSupportImplementation((P3Support)new P3SupportImpl(projectStoreBaseDir));
        PerProcessPathCustomization.prepareConfig(paths.getConfigDir(), PathManager.getConfigDir(), false);
        if (ApplicationManagerEx.isInIntegrationTest()) {
            long pid = ProcessHandle.current().pid();
            Path file = paths.getSystemDir().resolve("pids.txt");
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.writeString(file, (CharSequence)String.valueOf(pid), new OpenOption[0]);
            P3PathCustomizer $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(P3PathCustomizer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("current pid: " + pid + ", has been written to pids tile: " + file);
        }
        return new PathCustomizer.CustomPaths(NioPathUtil.toCanonicalPath((Path)paths.getConfigDir()), NioPathUtil.toCanonicalPath((Path)paths.getSystemDir()), NioPathUtil.toCanonicalPath((Path)paths.getPluginsDir()), NioPathUtil.toCanonicalPath((Path)paths.getLogDir()), PerProcessPathCustomization.getStartupScriptDir());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/ide/impl/startup/multiProcess/P3PathCustomizer$Companion;", "", "<init>", "()V", "OPTION_NAME", "", "intellij.platform.bootstrap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

