/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build.dependencies;

import com.dynatrace.hash4j.hashing.Hashing;
import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.time.Instant;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.sync.Mutex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.build.StripedMutex;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesDownloader;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesDownloaderKt;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesExtractOptions;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesUtil;
import org.jetbrains.intellij.build.dependencies.TeamCityHelper;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0016\u001a\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a-\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\u000e\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018H\u0002\u00a2\u0006\u0002\u0010!\u001a5\u0010\"\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\u000e\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018H\u0002\u00a2\u0006\u0002\u0010$\u001a5\u0010%\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\u000e\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018H\u0002\u00a2\u0006\u0002\u0010'\u001a\u001d\u0010(\u001a\u00020)2\u000e\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018H\u0002\u00a2\u0006\u0002\u0010*\u001a\u0010\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020)H\u0002\u001a\u0010\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020)H\u0002\u001a\u0010\u00107\u001a\u00020,2\u0006\u00108\u001a\u00020,H\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"2\u0010\f\u001a&\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u000e0\u000e \u0002*\u0012\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001a\"\u001b\u0010+\u001a\u00020,8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b-\u0010.\"\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "fileLocks", "Lorg/jetbrains/intellij/build/StripedMutex;", "cleanupFlag", "Ljava/util/concurrent/atomic/AtomicBoolean;", "EXTRACT_CODE_VERSION", "", "DOWNLOAD_CODE_VERSION", "extractCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "READ_OPERATION", "Ljava/util/EnumSet;", "Ljava/nio/file/StandardOpenOption;", "extractFileToCacheLocation", "Ljava/nio/file/Path;", "archiveFile", "communityRoot", "Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesCommunityRoot;", "stripRoot", "", "(Ljava/nio/file/Path;Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesCommunityRoot;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "EMPTY_OPTIONS", "", "Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesExtractOptions;", "[Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesExtractOptions;", "getProjectLocalDownloadCache", "getDownloadCachePath", "getExpectedFlagFileContent", "", "targetDirectory", "options", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesExtractOptions;)[B", "checkFlagFile", "flagFile", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;[Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesExtractOptions;)Z", "extractFileWithFlagFileLocation", "", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;[Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesExtractOptions;)V", "getExtractOptionsShortString", "", "([Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesExtractOptions;)Ljava/lang/String;", "sha2_256", "Ljava/security/MessageDigest;", "getSha2_256", "()Ljava/security/MessageDigest;", "sha2_256$delegate", "Lkotlin/Lazy;", "sunSecurityProvider", "Ljava/security/Provider;", "getMessageDigest", "algorithm", "hashString", "s", "cloneDigest", "digest", "intellij.platform.buildScripts.downloader"})
@SourceDebugExtension(value={"SMAP\nBuildDependenciesDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildDependenciesDownloader.kt\norg/jetbrains/intellij/build/dependencies/BuildDependenciesDownloaderKt\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,398:1\n116#2,10:399\n1#3:409\n12970#4,2:410\n*S KotlinDebug\n*F\n+ 1 BuildDependenciesDownloader.kt\norg/jetbrains/intellij/build/dependencies/BuildDependenciesDownloaderKt\n*L\n202#1:399,10\n323#1:410,2\n*E\n"})
public final class BuildDependenciesDownloaderKt {
    private static final Logger LOG = Logger.getLogger(BuildDependenciesDownloader.class.getName());
    @NotNull
    private static final StripedMutex fileLocks = new StripedMutex(1024);
    @NotNull
    private static final AtomicBoolean cleanupFlag = new AtomicBoolean(false);
    private static final int EXTRACT_CODE_VERSION = 5;
    private static final int DOWNLOAD_CODE_VERSION = 3;
    @NotNull
    private static final AtomicInteger extractCount = new AtomicInteger();
    private static final EnumSet<StandardOpenOption> READ_OPERATION = EnumSet.of((Enum)StandardOpenOption.READ);
    @NotNull
    private static final BuildDependenciesExtractOptions[] EMPTY_OPTIONS = new BuildDependenciesExtractOptions[0];
    @NotNull
    private static final Lazy sha2_256$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, BuildDependenciesDownloaderKt::sha2_256_delegate$lambda$0);
    @NotNull
    private static final Provider sunSecurityProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public static final Object extractFileToCacheLocation(@NotNull Path archiveFile, @NotNull BuildDependenciesCommunityRoot communityRoot, boolean stripRoot, @NotNull Continuation<? super Path> $completion) {
        if (!($completion instanceof extractFileToCacheLocation.1)) ** GOTO lbl-1000
        var20_4 = $completion;
        if ((var20_4.label & -2147483648) != 0) {
            var20_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                long J$0;
                int I$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BuildDependenciesDownloaderKt.extractFileToCacheLocation(null, null, false, (Continuation<? super Path>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var21_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                BuildDependenciesDownloader.INSTANCE.cleanUpIfRequired(communityRoot);
                archivePath = PathsKt.getInvariantSeparatorsPathString((Path)archiveFile);
                archivePathHash = Hashing.xxh3_64().hashBytesToLong(StringsKt.encodeToByteArray((String)archivePath));
                $this$withLock_u24default$iv = BuildDependenciesDownloaderKt.fileLocks.getLockByHash(archivePathHash);
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = archiveFile;
                $continuation.L$1 = communityRoot;
                $continuation.L$2 = archivePath;
                $continuation.L$3 = $this$withLock_u24default$iv;
                $continuation.Z$0 = stripRoot;
                $continuation.J$0 = archivePathHash;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl41
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                archivePathHash = $continuation.J$0;
                stripRoot = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$3;
                archivePath = (String)$continuation.L$2;
                communityRoot = (BuildDependenciesCommunityRoot)$continuation.L$1;
                archiveFile = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl41:
                // 2 sources

                try {
                    $i$a$-withLock$default-BuildDependenciesDownloaderKt$extractFileToCacheLocation$2 = false;
                    cachePath = BuildDependenciesDownloaderKt.getDownloadCachePath(communityRoot);
                    hasher = Hashing.xxh3_64().hashStream().putLong(archivePathHash).putInt(archivePath.length()).putBoolean(stripRoot != false).putInt(5);
                    dirName = archiveFile.getFileName() + "." + Long.toUnsignedString(hasher.getAsLong(), 36) + ".d";
                    targetDir = cachePath.resolve(dirName);
                    flagFile = cachePath.resolve(dirName + ".flag");
                    Intrinsics.checkNotNull((Object)targetDir);
                    Intrinsics.checkNotNull((Object)flagFile);
                    if (stripRoot) {
                        var16_19 = new BuildDependenciesExtractOptions[]{BuildDependenciesExtractOptions.STRIP_ROOT};
                        v1 = var16_19;
                    } else {
                        v1 = BuildDependenciesDownloaderKt.EMPTY_OPTIONS;
                    }
                    BuildDependenciesDownloaderKt.extractFileWithFlagFileLocation(archiveFile, targetDir, flagFile, v1);
                    var18_20 = targetDir;
                    return var18_20;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object extractFileToCacheLocation$default(Path path, BuildDependenciesCommunityRoot buildDependenciesCommunityRoot, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return BuildDependenciesDownloaderKt.extractFileToCacheLocation(path, buildDependenciesCommunityRoot, bl, (Continuation<? super Path>)continuation);
    }

    private static final Path getProjectLocalDownloadCache(BuildDependenciesCommunityRoot communityRoot) {
        Path path = Files.createDirectories(communityRoot.communityRoot.resolve("build/download"), new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createDirectories(...)");
        return path;
    }

    private static final Path getDownloadCachePath(BuildDependenciesCommunityRoot communityRoot) {
        Path path;
        if (TeamCityHelper.isUnderTeamCity) {
            path = TeamCityHelper.INSTANCE.getPersistentCachePath();
            if (path == null) {
                throw new IllegalStateException("'agent.persistent.cache' system property is required under TeamCity".toString());
            }
        } else {
            path = BuildDependenciesDownloaderKt.getProjectLocalDownloadCache(communityRoot);
        }
        Path path2 = path;
        Files.createDirectories(path2, new FileAttribute[0]);
        return path2;
    }

    private static final byte[] getExpectedFlagFileContent(Path archiveFile, Path targetDirectory, BuildDependenciesExtractOptions[] options) {
        Ref.LongRef fileCount = new Ref.LongRef();
        Ref.LongRef fileSizeSum = new Ref.LongRef();
        Files.walkFileTree(targetDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(fileCount, fileSizeSum){
            final /* synthetic */ Ref.LongRef $fileCount;
            final /* synthetic */ Ref.LongRef $fileSizeSum;
            {
                this.$fileCount = $fileCount;
                this.$fileSizeSum = $fileSizeSum;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                long l = this.$fileCount.element;
                this.$fileCount.element = l + 1L;
                this.$fileSizeSum.element += attrs.size();
                return FileVisitResult.CONTINUE;
            }
        });
        LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        return StringsKt.encodeToByteArray((String)("5\n" + archiveFile.toRealPath(linkOptionArray) + "\nfileCount:" + fileCount.element + "\nfileSizeSum:" + fileSizeSum.element + "\noptions:" + BuildDependenciesDownloaderKt.getExtractOptionsShortString(options) + "\n"));
    }

    private static final boolean checkFlagFile(Path archiveFile, Path flagFile, Path targetDirectory, BuildDependenciesExtractOptions[] options) {
        if (!Files.isRegularFile(flagFile, new LinkOption[0]) || !Files.isDirectory(targetDirectory, new LinkOption[0])) {
            return false;
        }
        byte[] existingContent = Files.readAllBytes(flagFile);
        return Arrays.equals(existingContent, BuildDependenciesDownloaderKt.getExpectedFlagFileContent(archiveFile, targetDirectory, options));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void extractFileWithFlagFileLocation(Path archiveFile, Path targetDirectory, Path flagFile, BuildDependenciesExtractOptions[] options) {
        boolean bl;
        ByteBuffer start;
        block37: {
            int n2;
            if (BuildDependenciesDownloaderKt.checkFlagFile(archiveFile, flagFile, targetDirectory, options)) {
                LOG.fine("Skipping extract to " + targetDirectory + " since flag file " + flagFile + " is correct");
                FileTime now = FileTime.from(Instant.now());
                try {
                    Files.setLastModifiedTime(targetDirectory, now);
                }
                catch (IOException e) {
                    LOG.fine("Error targetDirectory.setLastModifiedTime: " + e);
                }
                try {
                    Files.setLastModifiedTime(flagFile, now);
                }
                catch (IOException e) {
                    LOG.fine("Error flagFile.setLastModifiedTime: " + e);
                }
                return;
            }
            if (Files.exists(targetDirectory, new LinkOption[0])) {
                if (!Files.isDirectory(targetDirectory, new LinkOption[0])) {
                    boolean $i$a$-check-BuildDependenciesDownloaderKt$extractFileWithFlagFileLocation$32 = false;
                    String $i$a$-check-BuildDependenciesDownloaderKt$extractFileWithFlagFileLocation$32 = "Target '" + targetDirectory + "' exists, but it's not a directory. Please delete it manually";
                    throw new IllegalStateException($i$a$-check-BuildDependenciesDownloaderKt$extractFileWithFlagFileLocation$32.toString());
                }
                BuildDependenciesUtil.INSTANCE.cleanDirectory(targetDirectory);
            }
            LOG.info(" * Extracting " + archiveFile + " to " + targetDirectory);
            extractCount.incrementAndGet();
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
            List<Path> filesAfterCleaning = BuildDependenciesUtil.INSTANCE.listDirectory(targetDirectory);
            if (!filesAfterCleaning.isEmpty()) {
                boolean $i$a$-check-BuildDependenciesDownloaderKt$extractFileWithFlagFileLocation$52 = false;
                String $i$a$-check-BuildDependenciesDownloaderKt$extractFileWithFlagFileLocation$52 = "Target directory " + targetDirectory + " is not empty after cleaning: " + CollectionsKt.joinToString$default((Iterable)filesAfterCleaning, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                throw new IllegalStateException($i$a$-check-BuildDependenciesDownloaderKt$extractFileWithFlagFileLocation$52.toString());
            }
            start = ByteBuffer.allocate(4);
            Closeable $i$a$-check-BuildDependenciesDownloaderKt$extractFileWithFlagFileLocation$52 = FileChannel.open(archiveFile, (Set<? extends OpenOption>)READ_OPERATION, new FileAttribute[0]);
            Throwable throwable = null;
            try {
                FileChannel it22 = (FileChannel)$i$a$-check-BuildDependenciesDownloaderKt$extractFileWithFlagFileLocation$52;
                n2 = 0;
                int it22 = it22.read(start, 0L);
            }
            catch (Throwable n2) {
                throwable = n2;
                throw n2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$a$-check-BuildDependenciesDownloaderKt$extractFileWithFlagFileLocation$52, (Throwable)throwable);
            }
            start.flip();
            if (!(start.remaining() == 4)) {
                boolean $i$a$-check-BuildDependenciesDownloaderKt$extractFileWithFlagFileLocation$72 = false;
                String $i$a$-check-BuildDependenciesDownloaderKt$extractFileWithFlagFileLocation$72 = "File " + archiveFile + " is smaller than 4 bytes, could not be extracted";
                throw new IllegalStateException($i$a$-check-BuildDependenciesDownloaderKt$extractFileWithFlagFileLocation$72.toString());
            }
            BuildDependenciesExtractOptions[] $this$any$iv = options;
            boolean $i$f$any = false;
            int n3 = $this$any$iv.length;
            for (n2 = 0; n2 < n3; ++n2) {
                BuildDependenciesExtractOptions element$iv;
                BuildDependenciesExtractOptions it = element$iv = $this$any$iv[n2];
                boolean bl2 = false;
                if (!(it == BuildDependenciesExtractOptions.STRIP_ROOT)) continue;
                bl = true;
                break block37;
            }
            bl = false;
        }
        boolean stripRoot = bl;
        int magicNumber = start.order(ByteOrder.LITTLE_ENDIAN).getInt(0);
        if (magicNumber == -47205080) {
            Path unwrappedArchiveFile = archiveFile.getParent().resolve(archiveFile.getFileName() + ".unwrapped");
            try {
                Closeable n2 = Files.newOutputStream(unwrappedArchiveFile, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    long l;
                    OutputStream out = (OutputStream)n2;
                    boolean bl3 = false;
                    Closeable closeable = (Closeable)new ZstdInputStreamNoFinalizer(Files.newInputStream(archiveFile, new OpenOption[0]));
                    Throwable throwable2 = null;
                    try {
                        ZstdInputStreamNoFinalizer input = (ZstdInputStreamNoFinalizer)closeable;
                        boolean bl4 = false;
                        l = input.transferTo(out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    }
                    long l2 = l;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)n2, (Throwable)throwable);
                }
                Intrinsics.checkNotNull((Object)unwrappedArchiveFile);
                BuildDependenciesUtil.INSTANCE.extractZip(unwrappedArchiveFile, targetDirectory, stripRoot);
            }
            finally {
                Files.deleteIfExists(unwrappedArchiveFile);
            }
        }
        if (start.get(0) == 80 && start.get(1) == 75) {
            BuildDependenciesUtil.INSTANCE.extractZip(archiveFile, targetDirectory, stripRoot);
        } else if (start.get(0) == 31 && start.get(1) == -117) {
            BuildDependenciesUtil.INSTANCE.extractTarGz(archiveFile, targetDirectory, stripRoot);
        } else if (start.get(0) == 66 && start.get(1) == 90) {
            BuildDependenciesUtil.INSTANCE.extractTarBz2(archiveFile, targetDirectory, stripRoot);
        } else {
            throw new IllegalStateException("Unknown archive format at " + archiveFile + ". Magic number (little endian hex): " + Integer.toHexString(magicNumber) + ". Currently only .tar.gz or .zip are supported");
        }
        Files.write(flagFile, BuildDependenciesDownloaderKt.getExpectedFlagFileContent(archiveFile, targetDirectory, options), new OpenOption[0]);
        if (!BuildDependenciesDownloaderKt.checkFlagFile(archiveFile, flagFile, targetDirectory, options)) {
            boolean bl5 = false;
            String string = "'checkFlagFile' must be true right after extracting the archive. flagFile:" + flagFile + " archiveFile:" + archiveFile + " target:" + targetDirectory;
            throw new IllegalStateException(string.toString());
        }
    }

    private static final String getExtractOptionsShortString(BuildDependenciesExtractOptions[] options) {
        if (options.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (BuildDependenciesExtractOptions option : options) {
            if (option != BuildDependenciesExtractOptions.STRIP_ROOT) {
                throw new IllegalStateException("Unhandled case: " + option);
            }
            sb.append("s");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final MessageDigest getSha2_256() {
        Lazy lazy = sha2_256$delegate;
        return (MessageDigest)lazy.getValue();
    }

    private static final MessageDigest getMessageDigest(String algorithm) {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm, sunSecurityProvider);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        return messageDigest;
    }

    private static final String hashString(String s) {
        MessageDigest messageDigest = BuildDependenciesDownloaderKt.cloneDigest(BuildDependenciesDownloaderKt.getSha2_256());
        String string = s;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String string2 = new BigInteger(1, messageDigest.digest(byArray)).toString(36);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public static final MessageDigest cloneDigest(@NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        try {
            Object object = digest.clone();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.security.MessageDigest");
            return (MessageDigest)object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException("Message digest is not cloneable: " + digest);
        }
    }

    private static final MessageDigest sha2_256_delegate$lambda$0() {
        return BuildDependenciesDownloaderKt.getMessageDigest("SHA-256");
    }

    public static final /* synthetic */ String access$hashString(String s) {
        return BuildDependenciesDownloaderKt.hashString(s);
    }

    public static final /* synthetic */ Path access$getDownloadCachePath(BuildDependenciesCommunityRoot communityRoot) {
        return BuildDependenciesDownloaderKt.getDownloadCachePath(communityRoot);
    }

    public static final /* synthetic */ String access$getExtractOptionsShortString(BuildDependenciesExtractOptions[] options) {
        return BuildDependenciesDownloaderKt.getExtractOptionsShortString(options);
    }

    public static final /* synthetic */ void access$extractFileWithFlagFileLocation(Path archiveFile, Path targetDirectory, Path flagFile, BuildDependenciesExtractOptions[] options) {
        BuildDependenciesDownloaderKt.extractFileWithFlagFileLocation(archiveFile, targetDirectory, flagFile, options);
    }

    public static final /* synthetic */ StripedMutex access$getFileLocks$p() {
        return fileLocks;
    }

    public static final /* synthetic */ AtomicBoolean access$getCleanupFlag$p() {
        return cleanupFlag;
    }

    public static final /* synthetic */ Path access$getProjectLocalDownloadCache(BuildDependenciesCommunityRoot communityRoot) {
        return BuildDependenciesDownloaderKt.getProjectLocalDownloadCache(communityRoot);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ AtomicInteger access$getExtractCount$p() {
        return extractCount;
    }

    static {
        Provider provider = Security.getProvider("SUN");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"getProvider(...)");
        sunSecurityProvider = provider;
    }
}

