/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build.dependencies;

import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.Message;
import jetbrains.buildServer.messages.serviceMessages.MessageWithAttributes;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.build.dependencies.TeamCityHelper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u000b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesLogging;", "", "<init>", "()V", "setVerboseEnabled", "", "verboseEnabled", "", "warn", "message", "", "info", "verbose", "error", "fatal", "intellij.platform.buildScripts.downloader"})
public final class BuildDependenciesLogging {
    @NotNull
    public static final BuildDependenciesLogging INSTANCE = new BuildDependenciesLogging();
    private static boolean verboseEnabled;

    private BuildDependenciesLogging() {
    }

    @JvmStatic
    public static final void setVerboseEnabled(boolean verboseEnabled) {
        BuildDependenciesLogging.verboseEnabled = verboseEnabled;
    }

    @JvmStatic
    public static final void warn(@Nullable String message) {
        if (TeamCityHelper.isUnderTeamCity) {
            String string = message;
            Intrinsics.checkNotNull((Object)string);
            System.out.println((Object)new Message(string, "WARNING", null).asString());
        } else {
            System.out.println((Object)message);
        }
    }

    @JvmStatic
    public static final void info(@Nullable String message) {
        if (TeamCityHelper.isUnderTeamCity) {
            String string = message;
            Intrinsics.checkNotNull((Object)string);
            System.out.println((Object)new Message(string, "NORMAL", null).asString());
        } else {
            System.out.println((Object)message);
        }
    }

    @JvmStatic
    public static final void verbose(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (TeamCityHelper.isUnderTeamCity) {
            Map attributes;
            Map map = attributes = (Map)new HashMap();
            map.put("text", message);
            map = attributes;
            String string = "status";
            String string2 = "NORMAL";
            map.put(string, string2);
            map = attributes;
            string = "tc:tags";
            string2 = "tc:internal";
            map.put(string, string2);
            System.out.println((Object)new MessageWithAttributes(attributes){}.asString());
        } else if (verboseEnabled) {
            System.out.println((Object)message);
        }
    }

    @JvmStatic
    public static final void error(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (TeamCityHelper.isUnderTeamCity) {
            System.out.println((Object)new Message(message, "ERROR", null).asString());
        } else {
            System.out.println((Object)("ERROR: " + message));
        }
    }

    @JvmStatic
    public static final void fatal(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (TeamCityHelper.isUnderTeamCity) {
            System.out.println((Object)new Message(message, "FAILURE", null).asString());
        } else {
            System.err.println("\nFATAL: " + message);
        }
    }
}

