/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build;

import com.dynatrace.hash4j.hashing.Hasher64;
import com.dynatrace.hash4j.hashing.Hashing;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000bR\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/intellij/build/StripedMutex;", "", "stripeCount", "", "<init>", "(I)V", "locks", "", "Lkotlinx/coroutines/sync/Mutex;", "[Lkotlinx/coroutines/sync/Mutex;", "mask", "", "getLock", "string", "", "getLockByHash", "hash", "intellij.platform.buildScripts.downloader"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nstriped.kt\nKotlin\n*S Kotlin\n*F\n+ 1 striped.kt\norg/jetbrains/intellij/build/StripedMutex\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,25:1\n1#2:26\n*E\n"})
public final class StripedMutex {
    @NotNull
    private final Mutex[] locks;
    private final long mask;

    public StripedMutex(int stripeCount) {
        int n = 0;
        Mutex[] mutexArray = new Mutex[stripeCount];
        StripedMutex stripedMutex = this;
        while (n < stripeCount) {
            int n2 = n++;
            mutexArray[n2] = MutexKt.Mutex$default((boolean)false, (int)1, null);
        }
        stripedMutex.locks = mutexArray;
        this.mask = stripeCount - 1;
        if (!(stripeCount > 0)) {
            boolean $i$a$-require-StripedMutex$32 = false;
            String $i$a$-require-StripedMutex$32 = "Stripe count must be positive";
            throw new IllegalArgumentException($i$a$-require-StripedMutex$32.toString());
        }
        if (!((stripeCount & stripeCount - 1) == 0)) {
            boolean bl = false;
            String string = "Stripe count must be a power of 2";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ StripedMutex(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 64;
        }
        this(n);
    }

    @NotNull
    public final Mutex getLock(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Hasher64 hasher64 = Hashing.xxh3_64();
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.locks[(int)(hasher64.hashBytesToLong(byArray) & this.mask)];
    }

    @NotNull
    public final Mutex getLockByHash(long hash) {
        return this.locks[(int)(hash & this.mask)];
    }

    public StripedMutex() {
        this(0, 1, null);
    }
}

