/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build.dependencies;

import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.file.Path;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.sync.Mutex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.intellij.build.IExceptionWithRetryPolicy;
import org.jetbrains.intellij.build.KtorKt;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesDownloader;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesDownloaderKt;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesExtractOptions;
import org.jetbrains.intellij.build.dependencies.CacheDirCleanup;
import org.jetbrains.intellij.build.dependencies.DependenciesProperties;
import org.jetbrains.intellij.build.dependencies.TeamCityHelper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002-.B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0007J:\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000fH\u0007J&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007J\u0016\u0010\u001d\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0011J/\u0010\u001f\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00182\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"\"\u00020#\u00a2\u0006\u0002\u0010$J \u0010%\u001a\u00020&2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0007J:\u0010(\u001a\u00020&2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"\"\u00020#H\u0086@\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020&2\u0006\u0010\f\u001a\u00020\rJ\b\u0010+\u001a\u00020,H\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006/"}, d2={"Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesDownloader;", "", "<init>", "()V", "TRACER", "Lio/opentelemetry/api/trace/Tracer;", "getTRACER", "()Lio/opentelemetry/api/trace/Tracer;", "setTRACER", "(Lio/opentelemetry/api/trace/Tracer;)V", "getDependencyProperties", "Lorg/jetbrains/intellij/build/dependencies/DependenciesProperties;", "communityRoot", "Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesCommunityRoot;", "getUriForMavenArtifact", "Ljava/net/URI;", "mavenRepository", "", "groupId", "artifactId", "version", "packaging", "classifier", "downloadFileToCacheLocation", "Ljava/nio/file/Path;", "uri", "credentialsProvider", "Lkotlin/Function0;", "Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesDownloader$Credentials;", "getTargetFile", "uriString", "extractFileToCacheLocation", "archiveFile", "options", "", "Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesExtractOptions;", "(Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesCommunityRoot;Ljava/nio/file/Path;[Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesExtractOptions;)Ljava/nio/file/Path;", "extractFileSync", "", "target", "extractFile", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesCommunityRoot;[Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesExtractOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cleanUpIfRequired", "getExtractCount", "", "Credentials", "HttpStatusException", "intellij.platform.buildScripts.downloader"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBuildDependenciesDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildDependenciesDownloader.kt\norg/jetbrains/intellij/build/dependencies/BuildDependenciesDownloader\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,398:1\n116#2,11:399\n*S KotlinDebug\n*F\n+ 1 BuildDependenciesDownloader.kt\norg/jetbrains/intellij/build/dependencies/BuildDependenciesDownloader\n*L\n158#1:399,11\n*E\n"})
public final class BuildDependenciesDownloader {
    @NotNull
    public static final BuildDependenciesDownloader INSTANCE = new BuildDependenciesDownloader();
    @NotNull
    private static volatile Tracer TRACER;

    private BuildDependenciesDownloader() {
    }

    @NotNull
    public final Tracer getTRACER() {
        return TRACER;
    }

    public final void setTRACER(@NotNull Tracer tracer) {
        Intrinsics.checkNotNullParameter((Object)tracer, (String)"<set-?>");
        TRACER = tracer;
    }

    @NotNull
    public final DependenciesProperties getDependencyProperties(@NotNull BuildDependenciesCommunityRoot communityRoot) {
        Intrinsics.checkNotNullParameter((Object)communityRoot, (String)"communityRoot");
        return new DependenciesProperties(communityRoot, new Path[0]);
    }

    @JvmStatic
    @NotNull
    public static final URI getUriForMavenArtifact(@NotNull String mavenRepository, @NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String packaging) {
        Intrinsics.checkNotNullParameter((Object)mavenRepository, (String)"mavenRepository");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)packaging, (String)"packaging");
        return BuildDependenciesDownloader.getUriForMavenArtifact(mavenRepository, groupId, artifactId, version, null, packaging);
    }

    @JvmStatic
    @NotNull
    public static final URI getUriForMavenArtifact(@NotNull String mavenRepository, @NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier, @NotNull String packaging) {
        Intrinsics.checkNotNullParameter((Object)mavenRepository, (String)"mavenRepository");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)packaging, (String)"packaging");
        char[] cArray = new char[]{'/'};
        String base = StringsKt.trim((String)mavenRepository, (char[])cArray);
        String groupStr = StringsKt.replace$default((String)groupId, (char)'.', (char)'/', (boolean)false, (int)4, null);
        String string = classifier;
        Object classifierStr = string != null ? "-" + string : "";
        URI uRI = URI.create(base + "/" + groupStr + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + (String)classifierStr + "." + packaging);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        return uRI;
    }

    @JvmStatic
    @NotNull
    public static final Path downloadFileToCacheLocation(@NotNull BuildDependenciesCommunityRoot communityRoot, @NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)communityRoot, (String)"communityRoot");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return KtorKt.downloadFileToCacheLocationSync(string, communityRoot);
    }

    @JvmStatic
    @NotNull
    public static final Path downloadFileToCacheLocation(@NotNull BuildDependenciesCommunityRoot communityRoot, @NotNull URI uri, @NotNull Function0<Credentials> credentialsProvider) {
        Intrinsics.checkNotNullParameter((Object)communityRoot, (String)"communityRoot");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(credentialsProvider, (String)"credentialsProvider");
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return KtorKt.downloadFileToCacheLocationSync(string, communityRoot, credentialsProvider);
    }

    @NotNull
    public final Path getTargetFile(@NotNull BuildDependenciesCommunityRoot communityRoot, @NotNull String uriString) {
        Intrinsics.checkNotNullParameter((Object)communityRoot, (String)"communityRoot");
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        String string = uriString.substring(StringsKt.lastIndexOf$default((CharSequence)uriString, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String lastNameFromUri = string;
        String string2 = BuildDependenciesDownloaderKt.access$hashString(uriString + "V3").substring(0, 10);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String hashString = string2;
        Path path = BuildDependenciesDownloaderKt.access$getDownloadCachePath(communityRoot).resolve(hashString + "-" + lastNameFromUri);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final synchronized Path extractFileToCacheLocation(@NotNull BuildDependenciesCommunityRoot communityRoot, @NotNull Path archiveFile, BuildDependenciesExtractOptions ... options) {
        Intrinsics.checkNotNullParameter((Object)communityRoot, (String)"communityRoot");
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.cleanUpIfRequired(communityRoot);
        Path cachePath = BuildDependenciesDownloaderKt.access$getDownloadCachePath(communityRoot);
        String string = BuildDependenciesDownloaderKt.access$hashString(archiveFile + BuildDependenciesDownloaderKt.access$getExtractOptionsShortString(options) + "5").substring(0, 6);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String hash = string;
        String directoryName = archiveFile.getFileName() + "." + hash + ".d";
        Path targetDirectory = cachePath.resolve(directoryName);
        Path flagFile = cachePath.resolve(directoryName + ".flag");
        Intrinsics.checkNotNull((Object)targetDirectory);
        Intrinsics.checkNotNull((Object)flagFile);
        BuildDependenciesDownloaderKt.access$extractFileWithFlagFileLocation(archiveFile, targetDirectory, flagFile, options);
        return targetDirectory;
    }

    @Deprecated(message="Use BuildDependenciesDownloader.extractFile(communityRoot, archiveFile, options)", level=DeprecationLevel.ERROR)
    public final void extractFileSync(@NotNull Path archiveFile, @NotNull Path target, @NotNull BuildDependenciesCommunityRoot communityRoot) {
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)communityRoot, (String)"communityRoot");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(archiveFile, target, communityRoot, null){
            int label;
            final /* synthetic */ Path $archiveFile;
            final /* synthetic */ Path $target;
            final /* synthetic */ BuildDependenciesCommunityRoot $communityRoot;
            {
                this.$archiveFile = $archiveFile;
                this.$target = $target;
                this.$communityRoot = $communityRoot;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildDependenciesDownloader.INSTANCE.extractFile(this.$archiveFile, this.$target, this.$communityRoot, new BuildDependenciesExtractOptions[0], (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object extractFile(@NotNull Path archiveFile, @NotNull Path target, @NotNull BuildDependenciesCommunityRoot communityRoot, @NotNull BuildDependenciesExtractOptions[] options, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof extractFile.1)) ** GOTO lbl-1000
        var15_6 = $completion;
        if ((var15_6.label & -2147483648) != 0) {
            var15_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ BuildDependenciesDownloader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.extractFile(null, null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.cleanUpIfRequired(communityRoot);
                $this$withLock_u24default$iv = BuildDependenciesDownloaderKt.access$getFileLocks$p().getLock(target.toString());
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = archiveFile;
                $continuation.L$1 = target;
                $continuation.L$2 = communityRoot;
                $continuation.L$3 = options;
                $continuation.L$4 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var16_8) {
                    return var16_8;
                }
                ** GOTO lbl37
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$4;
                options = (BuildDependenciesExtractOptions[])$continuation.L$3;
                communityRoot = (BuildDependenciesCommunityRoot)$continuation.L$2;
                target = (Path)$continuation.L$1;
                archiveFile = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 2 sources

                try {
                    $i$a$-withLock$default-BuildDependenciesDownloader$extractFile$2 = false;
                    v1 = BuildDependenciesDownloaderKt.access$hashString(target.toString()).substring(0, 6);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                    hash = v1;
                    flagFile = BuildDependenciesDownloaderKt.access$getProjectLocalDownloadCache(communityRoot).resolve(hash + "-" + target.getFileName() + ".flag.txt");
                    Intrinsics.checkNotNull((Object)flagFile);
                    BuildDependenciesDownloaderKt.access$extractFileWithFlagFileLocation(archiveFile, target, flagFile, options);
                    var12_16 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void cleanUpIfRequired(@NotNull BuildDependenciesCommunityRoot communityRoot) {
        Intrinsics.checkNotNullParameter((Object)communityRoot, (String)"communityRoot");
        if (!BuildDependenciesDownloaderKt.access$getCleanupFlag$p().getAndSet(true)) {
            return;
        }
        if (TeamCityHelper.isUnderTeamCity) {
            return;
        }
        Path cacheDir = BuildDependenciesDownloaderKt.access$getProjectLocalDownloadCache(communityRoot);
        try {
            new CacheDirCleanup(cacheDir, 0L, 2, null).runCleanupIfRequired();
        }
        catch (Throwable t) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            BuildDependenciesDownloaderKt.access$getLOG$p().warning("Cleaning up failed for the directory '" + cacheDir + "'\n" + writer);
        }
    }

    @TestOnly
    public final int getExtractCount() {
        return BuildDependenciesDownloaderKt.access$getExtractCount$p().get();
    }

    static {
        Tracer tracer = TracerProvider.noop().get("noop-build-dependencies");
        Intrinsics.checkNotNullExpressionValue((Object)tracer, (String)"get(...)");
        TRACER = tracer;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesDownloader$Credentials;", "", "username", "", "password", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.buildScripts.downloader"})
    public static final class Credentials {
        @JvmField
        @NotNull
        public final String username;
        @JvmField
        @NotNull
        public final String password;

        public Credentials(@NotNull String username, @NotNull String password) {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            this.username = username;
            this.password = password;
        }

        @NotNull
        public final String component1() {
            return this.username;
        }

        @NotNull
        public final String component2() {
            return this.password;
        }

        @NotNull
        public final Credentials copy(@NotNull String username, @NotNull String password) {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            return new Credentials(username, password);
        }

        public static /* synthetic */ Credentials copy$default(Credentials credentials, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = credentials.username;
            }
            if ((n & 2) != 0) {
                string2 = credentials.password;
            }
            return credentials.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Credentials(username=" + this.username + ", password=" + this.password + ")";
        }

        public int hashCode() {
            int result = this.username.hashCode();
            result = result * 31 + this.password.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Credentials)) {
                return false;
            }
            Credentials credentials = (Credentials)other;
            if (!Intrinsics.areEqual((Object)this.username, (Object)credentials.username)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.password, (Object)credentials.password);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u0005H\u0016R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesDownloader$HttpStatusException;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "Lorg/jetbrains/intellij/build/IExceptionWithRetryPolicy;", "message", "", "statusCode", "", "url", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "toString", "isRetryAllowed", "", "()Z", "intellij.platform.buildScripts.downloader"})
    public static final class HttpStatusException
    extends IllegalStateException
    implements IExceptionWithRetryPolicy {
        @JvmField
        public final int statusCode;
        @NotNull
        private final String url;

        public HttpStatusException(@NotNull String message, int statusCode, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(message);
            this.statusCode = statusCode;
            this.url = url;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @Override
        @NotNull
        public String toString() {
            return "HttpStatusException(status=" + this.statusCode + ", url=" + this.url + ", message=" + this.getMessage() + ")";
        }

        @Override
        public boolean isRetryAllowed() {
            return this.statusCode != 404;
        }
    }
}

