/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build.dependencies;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/intellij/build/dependencies/EntryNameConverter;", "", "archiveFile", "Ljava/nio/file/Path;", "target", "stripRoot", "", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Z)V", "leadingComponentPrefix", "", "getOutputPath", "entryName", "isDirectory", "intellij.platform.buildScripts.downloader"})
@SourceDebugExtension(value={"SMAP\nBuildDependenciesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildDependenciesUtil.kt\norg/jetbrains/intellij/build/dependencies/EntryNameConverter\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,365:1\n37#2,2:366\n1#3:368\n*S KotlinDebug\n*F\n+ 1 BuildDependenciesUtil.kt\norg/jetbrains/intellij/build/dependencies/EntryNameConverter\n*L\n350#1:366,2\n*E\n"})
final class EntryNameConverter {
    @NotNull
    private final Path archiveFile;
    @NotNull
    private final Path target;
    private final boolean stripRoot;
    @Nullable
    private String leadingComponentPrefix;

    public EntryNameConverter(@NotNull Path archiveFile, @NotNull Path target, boolean stripRoot) {
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.archiveFile = archiveFile;
        this.target = target;
        this.stripRoot = stripRoot;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Path getOutputPath(@NotNull String entryName, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        String normalizedName = BuildDependenciesUtil.INSTANCE.normalizeEntryName(entryName);
        if (!this.stripRoot) {
            return this.target.resolve(normalizedName);
        }
        if (this.leadingComponentPrefix == null) {
            Path path;
            void $this$toTypedArray$iv;
            Object object = normalizedName;
            String string = "/";
            string = new Regex(string);
            int n = 2;
            object = string.split((CharSequence)object, n);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] split = thisCollection$iv.toArray(new String[0]);
            this.leadingComponentPrefix = split[0] + "/";
            if (split.length < 2) {
                if (!isDirectory) {
                    boolean $i$a$-check-EntryNameConverter$getOutputPath$32 = false;
                    String $i$a$-check-EntryNameConverter$getOutputPath$32 = this.archiveFile + ": first top-level entry must be a directory if strip root is enabled";
                    throw new IllegalStateException($i$a$-check-EntryNameConverter$getOutputPath$32.toString());
                }
                path = null;
            } else {
                path = this.target.resolve(split[1]);
            }
            return path;
        }
        String string = this.leadingComponentPrefix;
        Intrinsics.checkNotNull((Object)string);
        if (!StringsKt.startsWith$default((String)normalizedName, (String)string, (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string2 = this.archiveFile + ": entry name '" + normalizedName + "' should start with previously found prefix '" + this.leadingComponentPrefix + "'";
            throw new IllegalStateException(string2.toString());
        }
        String string3 = normalizedName;
        String string4 = this.leadingComponentPrefix;
        Intrinsics.checkNotNull((Object)string4);
        int n = string4.length();
        String string5 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        return this.target.resolve(string5);
    }
}

