/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build.dependencies;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0013\u0010\r\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR'\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R'\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/intellij/build/dependencies/TeamCityHelper;", "", "<init>", "()V", "isUnderTeamCity", "", "isPersonalBuild", "checkoutDirectory", "Ljava/nio/file/Path;", "getCheckoutDirectory", "()Ljava/nio/file/Path;", "persistentCachePath", "getPersistentCachePath", "tempDirectory", "getTempDirectory", "systemProperties", "", "", "getSystemProperties", "()Ljava/util/Map;", "systemProperties$delegate", "Lkotlin/Lazy;", "allProperties", "getAllProperties", "allProperties$delegate", "intellij.platform.buildScripts.downloader"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTeamCityHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamCityHelper.kt\norg/jetbrains/intellij/build/dependencies/TeamCityHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class TeamCityHelper {
    @NotNull
    public static final TeamCityHelper INSTANCE = new TeamCityHelper();
    @JvmField
    public static final boolean isUnderTeamCity = System.getenv("TEAMCITY_VERSION") != null;
    @JvmField
    public static final boolean isPersonalBuild = Intrinsics.areEqual((Object)System.getenv("BUILD_IS_PERSONAL"), (Object)"true");
    @NotNull
    private static final Lazy systemProperties$delegate = LazyKt.lazy(TeamCityHelper::systemProperties_delegate$lambda$0);
    @NotNull
    private static final Lazy allProperties$delegate = LazyKt.lazy(TeamCityHelper::allProperties_delegate$lambda$0);

    private TeamCityHelper() {
    }

    @Nullable
    public final Path getCheckoutDirectory() {
        if (!isUnderTeamCity) {
            return null;
        }
        String name = "teamcity.build.checkoutDir";
        String value = this.getSystemProperties().get(name);
        CharSequence charSequence = value;
        if (charSequence == null || charSequence.length() == 0) {
            throw new RuntimeException("TeamCity system property " + name + "was not found while running under TeamCity");
        }
        Path file = Path.of(value, new String[0]);
        if (!Files.isDirectory(file, new LinkOption[0])) {
            throw new RuntimeException("TeamCity system property " + name + " contains non existent directory: " + file);
        }
        return file;
    }

    @Nullable
    public final Path getPersistentCachePath() {
        Path path;
        String string = this.getSystemProperties().get("agent.persistent.cache");
        if (string == null) {
            string = System.getProperty("agent.persistent.cache");
        }
        if (string != null) {
            String it = string;
            boolean bl = false;
            path = Path.of(it, new String[0]);
        } else {
            path = null;
        }
        return path;
    }

    @Nullable
    public final Path getTempDirectory() {
        Map<String, String> systemProperties = this.getSystemProperties();
        if (systemProperties.isEmpty()) {
            return null;
        }
        String propertyName = "teamcity.build.tempDir";
        String string = systemProperties.get(propertyName);
        if (string == null) {
            throw new IllegalStateException("TeamCity must provide system property " + propertyName);
        }
        String tempPath = string;
        return Path.of(tempPath, new String[0]);
    }

    @NotNull
    public final Map<String, String> getSystemProperties() {
        Lazy lazy = systemProperties$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Map<String, String> getAllProperties() {
        Lazy lazy = allProperties$delegate;
        return (Map)lazy.getValue();
    }

    private static final Map systemProperties_delegate$lambda$0() {
        if (!isUnderTeamCity) {
            return MapsKt.emptyMap();
        }
        String systemPropertiesEnvName = "TEAMCITY_BUILD_PROPERTIES_FILE";
        String systemPropertiesFile = System.getenv(systemPropertiesEnvName);
        if (systemPropertiesFile == null || ((CharSequence)systemPropertiesFile).length() == 0) {
            throw new RuntimeException("TeamCity environment variable " + systemPropertiesEnvName + " was not found while running under TeamCity");
        }
        Path file = Path.of(systemPropertiesFile, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            throw new RuntimeException("TeamCity system properties file is not found: " + file);
        }
        Intrinsics.checkNotNull((Object)file);
        return BuildDependenciesUtil.INSTANCE.loadPropertiesFile(file);
    }

    private static final Map allProperties_delegate$lambda$0() {
        if (!isUnderTeamCity) {
            return new HashMap();
        }
        String propertyName = "teamcity.configuration.properties.file";
        String value = INSTANCE.getSystemProperties().get(propertyName);
        CharSequence charSequence = value;
        if (charSequence == null || charSequence.length() == 0) {
            throw new RuntimeException("TeamCity system property '" + propertyName + " is not found");
        }
        Path file = Path.of(value, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            throw new RuntimeException("TeamCity configuration properties file was not found: " + file);
        }
        Intrinsics.checkNotNull((Object)file);
        return BuildDependenciesUtil.INSTANCE.loadPropertiesFile(file);
    }
}

