/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.ide.actions.SettingsEntryPointAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.ToolboxSettingsActionRegistry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007\u0012\u000b\u0010\b\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001c\u001a\u00020\rH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\rH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\u0006\u0010$\u001a\u00020 J\u0010\u0010%\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lorg/jetbrains/ide/ToolboxUpdateAction;", "Lcom/intellij/ide/actions/SettingsEntryPointAction$UpdateAction;", "actionId", "", "lifetime", "Lcom/intellij/openapi/Disposable;", "text", "Lorg/jetbrains/annotations/Nls;", "description", "actionHandler", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "restartRequired", "", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/Disposable;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Runnable;Z)V", "getActionId", "()Ljava/lang/String;", "getLifetime", "()Lcom/intellij/openapi/Disposable;", "getRestartRequired", "()Z", "registry", "Lorg/jetbrains/ide/ToolboxSettingsActionRegistry;", "getRegistry", "()Lorg/jetbrains/ide/ToolboxSettingsActionRegistry;", "setRegistry", "(Lorg/jetbrains/ide/ToolboxSettingsActionRegistry;)V", "isIdeUpdate", "isRestartRequired", "isNewAction", "markAsRead", "", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.builtInServer.impl"})
public final class ToolboxUpdateAction
extends SettingsEntryPointAction.UpdateAction {
    @NotNull
    private final String actionId;
    @NotNull
    private final Disposable lifetime;
    @NotNull
    private final Runnable actionHandler;
    private final boolean restartRequired;
    public ToolboxSettingsActionRegistry registry;

    public ToolboxUpdateAction(@NotNull String actionId, @NotNull Disposable lifetime, @NotNull String text, @NotNull String description, @NotNull Runnable actionHandler, boolean restartRequired) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)actionHandler, (String)"actionHandler");
        super(text);
        this.actionId = actionId;
        this.lifetime = lifetime;
        this.actionHandler = actionHandler;
        this.restartRequired = restartRequired;
        this.getTemplatePresentation().setDescription(description);
    }

    @NotNull
    public final String getActionId() {
        return this.actionId;
    }

    @NotNull
    public final Disposable getLifetime() {
        return this.lifetime;
    }

    public final boolean getRestartRequired() {
        return this.restartRequired;
    }

    @NotNull
    public final ToolboxSettingsActionRegistry getRegistry() {
        ToolboxSettingsActionRegistry toolboxSettingsActionRegistry = this.registry;
        if (toolboxSettingsActionRegistry != null) {
            return toolboxSettingsActionRegistry;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"registry");
        return null;
    }

    public final void setRegistry(@NotNull ToolboxSettingsActionRegistry toolboxSettingsActionRegistry) {
        Intrinsics.checkNotNullParameter((Object)toolboxSettingsActionRegistry, (String)"<set-?>");
        this.registry = toolboxSettingsActionRegistry;
    }

    public boolean isIdeUpdate() {
        return true;
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    public boolean isNewAction() {
        return this.getRegistry().isNewAction(this.actionId);
    }

    public void markAsRead() {
        this.getRegistry().markAsRead(this.actionId);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.perform();
    }

    public final void perform() {
        this.actionHandler.run();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        if (Disposer.isDisposed((Disposable)this.lifetime)) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

