/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.NettyUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u0007H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/io/webSocket/WebSocketProtocolHandshakeHandler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "handshaker", "Lio/netty/handler/codec/http/websocketx/WebSocketClientHandshaker;", "<init>", "(Lio/netty/handler/codec/http/websocketx/WebSocketClientHandshaker;)V", "channelRead", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "message", "", "completed", "intellij.platform.builtInServer.impl"})
public class WebSocketProtocolHandshakeHandler
extends ChannelInboundHandlerAdapter {
    @NotNull
    private final WebSocketClientHandshaker handshaker;

    public WebSocketProtocolHandshakeHandler(@NotNull WebSocketClientHandshaker handshaker) {
        Intrinsics.checkNotNullParameter((Object)handshaker, (String)"handshaker");
        this.handshaker = handshaker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void channelRead(@NotNull ChannelHandlerContext context, @NotNull Object message) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Channel channel = context.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            try {
                this.handshaker.finishHandshake(channel, (FullHttpResponse)message);
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.replace((ChannelHandler)this, "aggregator", (ChannelHandler)new WebSocketFrameAggregator(NettyUtil.MAX_CONTENT_LENGTH));
                this.completed();
                return;
            }
            finally {
                ReferenceCountUtil.release((Object)message);
            }
        }
        if (message instanceof FullHttpResponse) {
            throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + ((FullHttpResponse)message).status() + ", content=" + ((FullHttpResponse)message).content().toString(CharsetUtil.UTF_8) + ")");
        }
        context.fireChannelRead(message);
    }

    protected void completed() {
    }
}

