/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.browsers.ReloadMode;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServerAuth;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a>\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007\u001a\u0010\u0010\r\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\u000e"}, d2={"getBuiltInServerUrls", "", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "currentAuthority", "", "appendAccessToken", "", "reloadMode", "Lcom/intellij/ide/browsers/ReloadMode;", "compareAuthority", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nBuiltInWebBrowserUrlProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInWebBrowserUrlProvider.kt\norg/jetbrains/builtInWebServer/BuiltInWebBrowserUrlProviderKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,99:1\n42#2,3:100\n*S KotlinDebug\n*F\n+ 1 BuiltInWebBrowserUrlProvider.kt\norg/jetbrains/builtInWebServer/BuiltInWebBrowserUrlProviderKt\n*L\n57#1:100,3\n*E\n"})
public final class BuiltInWebBrowserUrlProviderKt {
    @JvmOverloads
    @NotNull
    public static final List<Url> getBuiltInServerUrls(@NotNull VirtualFile file, @NotNull Project project, @Nullable String currentAuthority, boolean appendAccessToken, @Nullable ReloadMode reloadMode) {
        ReloadMode reloadMode2;
        ReloadMode reloadMode3;
        String authority;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (currentAuthority != null && !BuiltInWebBrowserUrlProviderKt.compareAuthority(currentAuthority)) {
            return CollectionsKt.emptyList();
        }
        PathInfo pathInfo = WebServerPathToFileManager.Companion.getInstance(project).getPathInfo(file);
        if (pathInfo == null) {
            return CollectionsKt.emptyList();
        }
        PathInfo info = pathInfo;
        int effectivePort = BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort();
        String path = info.getPath();
        Object object = currentAuthority;
        if (object == null) {
            object = authority = "localhost:" + effectivePort;
        }
        if ((reloadMode3 = reloadMode) == null) {
            ReloadMode reloadMode4 = WebBrowserManager.getInstance().getWebServerReloadMode();
            reloadMode3 = reloadMode4;
            Intrinsics.checkNotNullExpressionValue((Object)reloadMode4, (String)"getWebServerReloadMode(...)");
        }
        boolean appendReloadOnSave = (reloadMode2 = reloadMode3) != ReloadMode.DISABLED;
        StringBuilder queryBuilder = new StringBuilder();
        if (appendAccessToken || appendReloadOnSave) {
            queryBuilder.append('?');
        }
        if (appendAccessToken) {
            boolean $i$f$service = false;
            Class<BuiltInWebServerAuth> serviceClass$iv = BuiltInWebServerAuth.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            queryBuilder.append("_ijt").append('=').append(((BuiltInWebServerAuth)object2).acquireToken());
        }
        if (appendAccessToken && appendReloadOnSave) {
            queryBuilder.append('&');
        }
        if (appendReloadOnSave) {
            queryBuilder.append("_ij_reload").append('=').append(reloadMode2.name());
        }
        String string = queryBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String query = string;
        SmartList urls = new SmartList((Object)Urls.newHttpUrl((String)authority, (String)("/" + project.getName() + "/" + path), (String)query));
        String path2 = info.getRootLessPathIfPossible();
        if (path2 != null) {
            ((Collection)urls).add(Urls.newHttpUrl((String)authority, (String)("/" + project.getName() + "/" + path2), (String)query));
        }
        int defaultPort = BuiltInServerManager.Companion.getInstance().getPort();
        if (currentAuthority == null && defaultPort != effectivePort) {
            String defaultAuthority = "localhost:" + defaultPort;
            ((Collection)urls).add(Urls.newHttpUrl((String)defaultAuthority, (String)("/" + project.getName() + "/" + path), (String)query));
            if (path2 != null) {
                ((Collection)urls).add(Urls.newHttpUrl((String)defaultAuthority, (String)("/" + project.getName() + "/" + path2), (String)query));
            }
        }
        return (List)urls;
    }

    public static /* synthetic */ List getBuiltInServerUrls$default(VirtualFile virtualFile, Project project, String string, boolean bl, ReloadMode reloadMode, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            reloadMode = null;
        }
        return BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls(virtualFile, project, string, bl, reloadMode);
    }

    public static final boolean compareAuthority(@Nullable String currentAuthority) {
        CharSequence charSequence = currentAuthority;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        int portIndex = StringsKt.indexOf$default((CharSequence)currentAuthority, (char)':', (int)0, (boolean)false, (int)6, null);
        if (portIndex < 0) {
            return false;
        }
        String string = currentAuthority.substring(0, portIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String host = string;
        if (!BuiltInWebServerKt.isOwnHostName(host)) {
            return false;
        }
        String string2 = currentAuthority.substring(portIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        int port = StringUtil.parseInt((String)string2, (int)-1);
        return port == BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort() || port == BuiltInServerManager.Companion.getInstance().getPort();
    }

    @JvmOverloads
    @NotNull
    public static final List<Url> getBuiltInServerUrls(@NotNull VirtualFile file, @NotNull Project project, @Nullable String currentAuthority, boolean appendAccessToken) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls$default(file, project, currentAuthority, appendAccessToken, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public static final List<Url> getBuiltInServerUrls(@NotNull VirtualFile file, @NotNull Project project, @Nullable String currentAuthority) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls$default(file, project, currentAuthority, false, null, 24, null);
    }
}

