/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.google.common.net.InetAddresses;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.ide.ui.ProductIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.util.io.NettyKt;
import com.intellij.util.ui.ImageUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URI;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServerAuth;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/builtInWebServer/BuiltInWebServer;", "Lorg/jetbrains/ide/HttpRequestHandler;", "<init>", "()V", "PATH_HANDLER_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lorg/jetbrains/builtInWebServer/WebServerPathHandler;", "authService", "Lorg/jetbrains/builtInWebServer/BuiltInWebServerAuth;", "isAccessible", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "isSupported", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "sendDefaultFavIcon", "rawPath", "", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nBuiltInWebServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInWebServer.kt\norg/jetbrains/builtInWebServer/BuiltInWebServer\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,328:1\n42#2,3:329\n1400#3,2:332\n1#4:334\n82#5,3:335\n*S KotlinDebug\n*F\n+ 1 BuiltInWebServer.kt\norg/jetbrains/builtInWebServer/BuiltInWebServer\n*L\n77#1:329,3\n136#1:332,2\n202#1:335,3\n*E\n"})
public final class BuiltInWebServer
extends HttpRequestHandler {
    @NotNull
    private final ExtensionPointName<WebServerPathHandler> PATH_HANDLER_EP_NAME = ExtensionPointName.Companion.create("org.jetbrains.webServerPathHandler");
    @NotNull
    private final BuiltInWebServerAuth authService;

    public BuiltInWebServer() {
        boolean $i$f$service = false;
        Class<BuiltInWebServerAuth> serviceClass$iv = BuiltInWebServerAuth.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.authService = (BuiltInWebServerAuth)object;
    }

    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return BuiltInServerOptions.getInstance().builtInServerAvailableExternally || NettyKt.isLocalOrigin((HttpRequest)request, (boolean)false, (boolean)true);
    }

    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return super.isSupported(request) || request.method() == HttpMethod.POST;
    }

    /*
     * Unable to fully structure code
     */
    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        block41: {
            block40: {
                block36: {
                    Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    decodedPath = urlDecoder.path();
                    Intrinsics.checkNotNull((Object)decodedPath);
                    if (this.sendDefaultFavIcon(decodedPath, request, context)) {
                        return true;
                    }
                    v0 = NettyKt.getHostName((HttpRequest)((HttpRequest)request));
                    if (v0 == null) {
                        return false;
                    }
                    hostName = v0;
                    v1 = isIpv6 = StringsKt.startsWith$default((CharSequence)hostName, (char)'[', (boolean)false, (int)2, null) != false && StringsKt.endsWith$default((CharSequence)hostName, (char)']', (boolean)false, (int)2, null) != false;
                    if (isIpv6) {
                        v2 = hostName.substring(1, hostName.length() - 1);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                        hostName = v2;
                    }
                    if (isIpv6 || InetAddresses.isInetAddress((String)hostName) || BuiltInWebServerKt.isOwnHostName(hostName) || StringsKt.endsWith$default((String)hostName, (String)".ngrok.io", (boolean)false, (int)2, null)) {
                        if (decodedPath.length() < 2) {
                            return false;
                        }
                        v3 = null;
                    } else {
                        v3 = StringsKt.endsWith$default((String)hostName, (String)".localhost", (boolean)false, (int)2, null) != false ? StringsKt.take((String)hostName, (int)StringsKt.lastIndexOf$default((CharSequence)hostName, (char)'.', (int)0, (boolean)false, (int)6, null)) : hostName;
                    }
                    projectNameAsHost = v3;
                    isCustomHost = projectNameAsHost != null;
                    offset = 0;
                    offset = isCustomHost != false ? 0 : StringsKt.indexOf$default((CharSequence)decodedPath, (char)'/', (int)1, (boolean)false, (int)4, null);
                    projectName = null;
                    if (isCustomHost) {
                        v4 = projectNameAsHost;
                    } else {
                        v5 = decodedPath.substring(1, offset == -1 ? decodedPath.length() : offset);
                        v4 = v5;
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"substring(...)");
                    }
                    projectName = v4;
                    isEmptyPath = false;
                    isEmptyPath = isCustomHost ? ((CharSequence)decodedPath).length() == 0 : offset == -1;
                    referer = request.headers().get((CharSequence)HttpHeaderNames.REFERER);
                    if (!isCustomHost && referer != null) {
                        try {
                            uri = URI.create(referer);
                            refererPath = uri.getPath();
                            if (refererPath != null && StringsKt.startsWith$default((CharSequence)refererPath, (char)'/', (boolean)false, (int)2, null)) {
                                secondSlashOffset = StringsKt.indexOf$default((CharSequence)refererPath, (char)'/', (int)1, (boolean)false, (int)4, null);
                                if (secondSlashOffset > 1) {
                                    v6 = refererPath.substring(1, secondSlashOffset);
                                    v7 = v6;
                                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"substring(...)");
                                } else {
                                    v7 = null;
                                }
                            } else {
                                v7 = null;
                            }
                            uri = v7;
                        }
                        catch (Throwable <unused var>) {
                            uri = null;
                        }
                        v8 = uri;
                    } else {
                        v8 = null;
                    }
                    projectNameFromReferer = v8;
                    candidateByDirectoryName = null;
                    isCandidateFromReferer = false;
                    v9 = ProjectManager.getInstance().getOpenProjects();
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getOpenProjects(...)");
                    $this$firstOrNull$iv = v9;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        block38: {
                            block39: {
                                block37: {
                                    project = (Project)element$iv;
                                    $i$a$-firstOrNull-BuiltInWebServer$process$project$1 = false;
                                    if (!project.isDisposed()) break block37;
                                    v10 = false;
                                    break block38;
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)project.getName(), (String)"getName(...)");
                                if (!isCustomHost) break block39;
                                if (!StringsKt.equals((String)projectName, (String)name, (boolean)true)) ** GOTO lbl-1000
                                if (!SystemInfo.isFileSystemCaseSensitive) {
                                    projectName = name;
                                }
                                v10 = true;
                                break block38;
                            }
                            if (!StringsKt.regionMatches((String)decodedPath, (int)1, (String)name, (int)0, (int)name.length(), (boolean)(SystemInfo.isFileSystemCaseSensitive == false))) ** GOTO lbl-1000
                            v11 = isEmptyPathCandidate = decodedPath.length() == name.length() + 1;
                            if (isEmptyPathCandidate || decodedPath.charAt(name.length() + 1) == '/') {
                                projectName = name;
                                offset = name.length() + 1;
                                isEmptyPath = isEmptyPathCandidate;
                                v10 = true;
                            } else lbl-1000:
                            // 3 sources

                            {
                                if (candidateByDirectoryName == null && BuiltInWebServerKt.compareNameAndProjectBasePath((String)projectName, project)) {
                                    candidateByDirectoryName = project;
                                }
                                if (candidateByDirectoryName == null && projectNameFromReferer != null && (Intrinsics.areEqual((Object)projectNameFromReferer, (Object)name) || BuiltInWebServerKt.compareNameAndProjectBasePath((String)projectNameFromReferer, project))) {
                                    candidateByDirectoryName = project;
                                    isCandidateFromReferer = true;
                                }
                                v10 = false;
                            }
                        }
                        if (!v10) continue;
                        v12 = element$iv;
                        break block36;
                    }
                    v12 = null;
                }
                if ((v13 = (Project)v12) == null) {
                    v13 = project = candidateByDirectoryName;
                }
                if (isCandidateFromReferer) {
                    v14 = projectNameFromReferer;
                    Intrinsics.checkNotNull((Object)v14);
                    projectName = v14;
                    offset = 0;
                    isEmptyPath = false;
                }
                if (isEmptyPath) {
                    v15 = (HttpRequest)request;
                    v16 = context.channel();
                    Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"channel(...)");
                    BuiltInWebServerKt.redirectToDirectory(v15, v16, null);
                    return true;
                }
                v17 = this.authService.validateToken$intellij_platform_builtInServer_impl((HttpRequest)request);
                if (v17 == null) {
                    return false;
                }
                authHeaders = v17;
                if (project == null) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)request.headers().get("Service-Worker"), (Object)"script") && !TrustedProjects.isProjectTrusted((Project)project)) {
                    return false;
                }
                v18 = decodedPath.substring(offset);
                Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"substring(...)");
                it = var20_24 = v18;
                $i$a$-takeIf-BuiltInWebServer$process$path$1 = false;
                v19 = StringsKt.startsWith$default((CharSequence)it, (char)'/', (boolean)false, (int)2, null) != false ? var20_24 : null;
                if (v19 == null) break block40;
                it = v19;
                $i$a$-let-BuiltInWebServer$process$path$2 = false;
                v20 = FileUtil.toCanonicalPath((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"toCanonicalPath(...)");
                $i$a$-firstOrNull-BuiltInWebServer$process$project$1 = v20;
                name = 1;
                v21 = $i$a$-firstOrNull-BuiltInWebServer$process$project$1.substring(name);
                Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"substring(...)");
                v19 = v21;
                if (v21 != null) break block41;
            }
            $this$process_u24lambda_u243 = this;
            $i$a$-run-BuiltInWebServer$process$path$3 = false;
            v22 = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"NOT_FOUND");
            v23 = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)v23, (String)"channel(...)");
            Responses.send$default((HttpResponseStatus)v22, (Channel)v23, (HttpRequest)((HttpRequest)request), null, (HttpHeaders)authHeaders, (int)4, null);
            return true;
        }
        path = v19;
        for (WebServerPathHandler pathHandler : this.PATH_HANDLER_EP_NAME.getExtensionList()) {
            $this$runAndLogException$iv = BuiltInWebServerKt.getLOG();
            $i$f$runAndLogException = false;
            var23_35 = $this$runAndLogException$iv;
            try {
                $this$runAndLogException_u24lambda_u240$iv = var23_35;
                $i$a$-runCatching-LoggerKt$runAndLogException$1$iv = false;
                $i$a$-runAndLogException-BuiltInWebServer$process$1 = false;
                if (pathHandler.process(path, project, request, context, (String)projectName, authHeaders, isCustomHost)) {
                    return true;
                }
                var24_37 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable var25_41) {
                var24_37 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var25_41));
            }
            LoggerKt.getOrLogException((Object)var24_37, (Logger)$this$runAndLogException$iv);
        }
        v24 = HttpResponseStatus.NOT_FOUND;
        Intrinsics.checkNotNullExpressionValue((Object)v24, (String)"NOT_FOUND");
        v25 = context.channel();
        Intrinsics.checkNotNullExpressionValue((Object)v25, (String)"channel(...)");
        Responses.send$default((HttpResponseStatus)v24, (Channel)v25, (HttpRequest)((HttpRequest)request), null, (HttpHeaders)authHeaders, (int)4, null);
        return true;
    }

    private final boolean sendDefaultFavIcon(String rawPath, FullHttpRequest request, ChannelHandlerContext context) {
        return switch (rawPath) {
            case "/favicon.ico" -> {
                Icon v0 = ProductIcons.getInstance().getProductIcon();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProductIcon(...)");
                Icon icon = v0;
                CachedImageIcon v1 = icon instanceof CachedImageIcon ? (CachedImageIcon)icon : null;
                Image var8_6 = v1 != null ? v1.getRealImage() : null;
                BufferedImage v2 = var8_6 instanceof BufferedImage ? (BufferedImage)var8_6 : null;
                if (v2 == null) {
                    BufferedImage var9_7;
                    BufferedImage $this$sendDefaultFavIcon_u24lambda_u240 = var9_7 = ImageUtil.createImage((int)icon.getIconWidth(), (int)icon.getIconHeight(), (int)2);
                    boolean $i$a$-apply-BuiltInWebServer$sendDefaultFavIcon$image$1 = false;
                    icon.paintIcon(null, $this$sendDefaultFavIcon_u24lambda_u240.getGraphics(), 0, 0);
                    BufferedImage v3 = var9_7;
                    v2 = v3;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"apply(...)");
                }
                BufferedImage image = v2;
                byte[] icoBytes = Imaging.writeImageToBytes((BufferedImage)image, (ImageFormat)((ImageFormat)ImageFormats.ICO), null);
                HttpResponse v4 = Responses.addNoCache((HttpResponse)((HttpResponse)Responses.response((String)FileResponses.INSTANCE.getContentType(rawPath), (ByteBuf)Unpooled.wrappedBuffer((byte[])icoBytes))));
                Channel v5 = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"channel(...)");
                Responses.send$default((HttpResponse)v4, (Channel)v5, (HttpRequest)((HttpRequest)request), null, (int)4, null);
                yield true;
            }
            case "/apple-touch-icon.png", "/apple-touch-icon-precomposed.png" -> {
                HttpResponseStatus v7 = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"NOT_FOUND");
                Channel v8 = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"channel(...)");
                Responses.send$default((HttpResponseStatus)v7, (Channel)v8, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
                yield true;
            }
            default -> false;
        };
    }
}

