/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.CharArrayUtil;
import io.netty.buffer.ByteBufUtf8Writer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.ssi.SsiCommand;
import org.jetbrains.builtInWebServer.ssi.SsiConditional;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiFsize;
import org.jetbrains.builtInWebServer.ssi.SsiProcessingState;
import org.jetbrains.builtInWebServer.ssi.SsiProcessorKt;
import org.jetbrains.builtInWebServer.ssi.SsiStopProcessingException;
import org.jetbrains.builtInWebServer.ssi.Strftime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J1\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00182\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001b\u001a\u00020\u00062\n\u0010\u001c\u001a\u00060\u0013j\u0002`\u0014H\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/builtInWebServer/ssi/SsiProcessor;", "", "<init>", "()V", "commands", "", "", "Lorg/jetbrains/builtInWebServer/ssi/SsiCommand;", "process", "", "ssiExternalResolver", "Lorg/jetbrains/builtInWebServer/ssi/SsiExternalResolver;", "file", "Ljava/nio/file/Path;", "writer", "Lio/netty/buffer/ByteBufUtf8Writer;", "parseParamNames", "", "command", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "start", "", "parseParamValues", "", "count", "(Ljava/lang/StringBuilder;II)[Ljava/lang/String;", "parseCommand", "instruction", "charCmp", "", "buf", "", "index", "isSpace", "c", "", "isQuote", "intellij.platform.builtInServer.impl"})
public class SsiProcessor {
    @NotNull
    private final Map<String, SsiCommand> commands = new HashMap();

    public SsiProcessor() {
        this.commands.put("config", SsiProcessor::_init_$lambda$0);
        this.commands.put("echo", SsiProcessor::_init_$lambda$1);
        this.commands.put("include", SsiProcessor::_init_$lambda$2);
        this.commands.put("flastmod", SsiProcessor::_init_$lambda$3);
        this.commands.put("fsize", new SsiFsize());
        this.commands.put("printenv", SsiProcessor::_init_$lambda$4);
        this.commands.put("set", SsiProcessor::_init_$lambda$5);
        SsiConditional ssiConditional = new SsiConditional();
        this.commands.put("if", ssiConditional);
        this.commands.put("elif", ssiConditional);
        this.commands.put("endif", ssiConditional);
        this.commands.put("else", ssiConditional);
    }

    public final long process(@NotNull SsiExternalResolver ssiExternalResolver, @NotNull Path file, @NotNull ByteBufUtf8Writer writer) {
        Intrinsics.checkNotNullParameter((Object)ssiExternalResolver, (String)"ssiExternalResolver");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        CharSequence fileContents = PathKt.readChars((Path)file);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        FileTime fileTime = Files.getLastModifiedTime(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
        long lastModifiedDate = fileTime.toMillis();
        SsiProcessingState ssiProcessingState = new SsiProcessingState(ssiExternalResolver, lastModifiedDate);
        int index = 0;
        boolean inside = false;
        StringBuilder command = new StringBuilder();
        writer.ensureWritable((int)Files.size(file));
        try {
            while (index < fileContents.length()) {
                char c = fileContents.charAt(index);
                if (inside) {
                    if (c == '-' && this.charCmp(fileContents, index, "-->")) {
                        long newLastModified;
                        inside = false;
                        index += 3;
                        String commandName = this.parseCommand(command);
                        if (SsiProcessorKt.getLOG().isDebugEnabled()) {
                            SsiProcessorKt.getLOG().debug("SSIProcessor.process -- processing command: " + commandName);
                        }
                        List<String> paramNames = this.parseParamNames(command, commandName.length());
                        String[] paramValues = this.parseParamValues(command, commandName.length(), paramNames.size());
                        String configErrMsg = ssiProcessingState.configErrorMessage;
                        String string = commandName;
                        Locale locale = Locale.ENGLISH;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                        String string2 = string.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        SsiCommand ssiCommand = this.commands.get(string2);
                        Object errorMessage = null;
                        if (ssiCommand == null) {
                            errorMessage = "Unknown command: " + commandName;
                        } else if (paramValues == null) {
                            errorMessage = "Error parsing directive parameters.";
                        } else if (paramNames.size() != paramValues.length) {
                            errorMessage = "Parameter names count does not match parameter values count on command: " + commandName;
                        } else if ((!ssiProcessingState.conditionalState.processConditionalCommandsOnly || ssiCommand instanceof SsiConditional) && (newLastModified = ssiCommand.process(ssiProcessingState, commandName, paramNames, paramValues, writer)) > lastModifiedDate) {
                            lastModifiedDate = newLastModified;
                        }
                        if (errorMessage == null) continue;
                        SsiProcessorKt.getLOG().warn((String)errorMessage);
                        Intrinsics.checkNotNull((Object)configErrMsg);
                        writer.write(configErrMsg);
                        continue;
                    }
                    command.append(c);
                    ++index;
                    continue;
                }
                if (c == '<' && this.charCmp(fileContents, index, "<!--#")) {
                    inside = true;
                    index += 5;
                    command.setLength(0);
                    continue;
                }
                if (!ssiProcessingState.conditionalState.processConditionalCommandsOnly) {
                    writer.append(c);
                }
                ++index;
            }
        }
        catch (SsiStopProcessingException ssiStopProcessingException) {
            // empty catch block
        }
        return lastModifiedDate;
    }

    private final List<String> parseParamNames(StringBuilder command, int start2) {
        int bIdx = start2;
        SmartList values = new SmartList();
        boolean inside = false;
        StringBuilder builder = new StringBuilder();
        while (bIdx < command.length()) {
            if (inside) {
                while (bIdx < command.length() && command.charAt(bIdx) != '=') {
                    builder.append(command.charAt(bIdx));
                    ++bIdx;
                }
                values.add((Object)builder.toString());
                builder.setLength(0);
                inside = false;
                int quotes = 0;
                boolean escaped = false;
                while (bIdx < command.length() && quotes != 2) {
                    char c = command.charAt(bIdx);
                    if (c == '\\' && !escaped) {
                        escaped = true;
                        ++bIdx;
                        continue;
                    }
                    if (c == '\"' && !escaped) {
                        ++quotes;
                    }
                    escaped = false;
                    ++bIdx;
                }
                continue;
            }
            while (bIdx < command.length() && this.isSpace(command.charAt(bIdx))) {
                ++bIdx;
            }
            if (bIdx >= command.length()) break;
            inside = true;
        }
        return (List)values;
    }

    private final String[] parseParamValues(StringBuilder command, int start2, int count) {
        int valueIndex = 0;
        boolean inside = false;
        String[] values = new String[count];
        StringBuilder builder = new StringBuilder();
        char endQuote = '\u0000';
        for (int bIdx = start2; bIdx < command.length(); ++bIdx) {
            if (!inside) {
                while (bIdx < command.length() && !this.isQuote(command.charAt(bIdx))) {
                    ++bIdx;
                }
                if (bIdx >= command.length()) break;
                inside = true;
                endQuote = command.charAt(bIdx);
                continue;
            }
            boolean escaped = false;
            while (bIdx < command.length()) {
                char c = command.charAt(bIdx);
                if (c == '\\' && !escaped) {
                    escaped = true;
                    ++bIdx;
                    continue;
                }
                if (c == endQuote && !escaped) break;
                if (c == '$' && escaped) {
                    builder.append('\\');
                }
                escaped = false;
                builder.append(c);
                ++bIdx;
            }
            if (bIdx == command.length()) {
                return null;
            }
            values[valueIndex++] = builder.toString();
            builder.setLength(0);
            inside = false;
        }
        return values;
    }

    private final String parseCommand(StringBuilder instruction) {
        String string;
        int firstLetter = -1;
        int lastLetter = -1;
        int n = ((CharSequence)instruction).length();
        for (int i = 0; i < n; ++i) {
            char c = instruction.charAt(i);
            if (Character.isLetter(c)) {
                if (firstLetter == -1) {
                    firstLetter = i;
                }
                lastLetter = i;
                continue;
            }
            if (!this.isSpace(c) || lastLetter > -1) break;
        }
        if (firstLetter == -1) {
            string = "";
        } else {
            String string2 = instruction.substring(firstLetter, lastLetter + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return string;
    }

    private final boolean charCmp(CharSequence buf, int index, String command) {
        return CharArrayUtil.regionMatches((CharSequence)buf, (int)index, (int)(index + command.length()), (CharSequence)command);
    }

    private final boolean isSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private final boolean isQuote(char c) {
        return c == '\'' || c == '\"' || c == '`';
    }

    private static final long _init_$lambda$0(SsiProcessingState state, String string, List paramNames, String[] paramValues, ByteBufUtf8Writer writer) {
        int n = ((Collection)paramNames).size();
        for (int i = 0; i < n; ++i) {
            String paramName = (String)paramNames.get(i);
            String paramValue = paramValues[i];
            String substitutedValue = state.substituteVariables(paramValue);
            if (StringsKt.equals((String)paramName, (String)"errmsg", (boolean)true)) {
                state.configErrorMessage = substitutedValue;
                continue;
            }
            if (StringsKt.equals((String)paramName, (String)"sizefmt", (boolean)true)) {
                state.configSizeFmt = substitutedValue;
                continue;
            }
            if (StringsKt.equals((String)paramName, (String)"timefmt", (boolean)true)) {
                state.setConfigTimeFormat(substitutedValue, false);
                continue;
            }
            SsiProcessorKt.getLOG().info("#config--Invalid attribute: " + paramName);
            String string2 = state.configErrorMessage;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"configErrorMessage");
            writer.write(string2);
        }
        return 0L;
    }

    private static final long _init_$lambda$1(SsiProcessingState state, String string, List paramNames, String[] paramValues, ByteBufUtf8Writer writer) {
        String encoding = "entity";
        String originalValue = null;
        String errorMessage = state.configErrorMessage;
        int n = ((Collection)paramNames).size();
        for (int i = 0; i < n; ++i) {
            String paramName = (String)paramNames.get(i);
            String paramValue = paramValues[i];
            if (StringsKt.equals((String)paramName, (String)"var", (boolean)true)) {
                originalValue = paramValue;
                continue;
            }
            if (StringsKt.equals((String)paramName, (String)"encoding", (boolean)true)) {
                if (StringsKt.equals((String)paramValue, (String)"url", (boolean)true) || StringsKt.equals((String)paramValue, (String)"entity", (boolean)true) || StringsKt.equals((String)paramValue, (String)"none", (boolean)true)) {
                    Intrinsics.checkNotNull((Object)paramValue);
                    encoding = paramValue;
                    continue;
                }
                SsiProcessorKt.getLOG().info("#echo--Invalid encoding: " + paramValue);
                Intrinsics.checkNotNull((Object)errorMessage);
                writer.write(errorMessage);
                continue;
            }
            SsiProcessorKt.getLOG().info("#echo--Invalid attribute: " + paramName);
            Intrinsics.checkNotNull((Object)errorMessage);
            writer.write(errorMessage);
        }
        String string2 = originalValue;
        Intrinsics.checkNotNull(string2);
        String variableValue = state.getVariableValue(string2, encoding);
        String string3 = variableValue;
        if (string3 == null) {
            string3 = "(none)";
        }
        writer.write(string3);
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long _init_$lambda$2(SsiProcessingState state, String string, List paramNames, String[] paramValues, ByteBufUtf8Writer writer) {
        long lastModified = 0L;
        String configErrorMessage = state.configErrorMessage;
        int n = ((Collection)paramNames).size();
        for (int i = 0; i < n; ++i) {
            String paramName = (String)paramNames.get(i);
            if (StringsKt.equals((String)paramName, (String)"file", (boolean)true) || StringsKt.equals((String)paramName, (String)"virtual", (boolean)true)) {
                String substitutedValue = state.substituteVariables(paramValues[i]);
                try {
                    boolean virtual = StringsKt.equals((String)paramName, (String)"virtual", (boolean)true);
                    SsiExternalResolver ssiExternalResolver = state.ssiExternalResolver;
                    Intrinsics.checkNotNull((Object)substitutedValue);
                    lastModified = ssiExternalResolver.getFileLastModified(substitutedValue, virtual);
                    Path file = state.ssiExternalResolver.findFileInProject(substitutedValue, virtual);
                    if (file == null) {
                        SsiProcessorKt.getLOG().warn("#include-- Couldn't find file: " + substitutedValue);
                        return 0L;
                    }
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                    Closeable closeable = inputStream;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl = false;
                        writer.write(it, (int)Files.size(file));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (IOException e) {
                    SsiProcessorKt.getLOG().warn("#include--Couldn't include file: " + substitutedValue, (Throwable)e);
                    Intrinsics.checkNotNull((Object)configErrorMessage);
                    writer.write(configErrorMessage);
                }
                continue;
            }
            SsiProcessorKt.getLOG().info("#include--Invalid attribute: " + paramName);
            Intrinsics.checkNotNull((Object)configErrorMessage);
            writer.write(configErrorMessage);
        }
        return lastModified;
    }

    private static final long _init_$lambda$3(SsiProcessingState state, String string, List paramNames, String[] paramValues, ByteBufUtf8Writer writer) {
        long lastModified = 0L;
        String configErrMsg = state.configErrorMessage;
        int n = ((Collection)paramNames).size();
        for (int i = 0; i < n; ++i) {
            String paramName = (String)paramNames.get(i);
            String paramValue = paramValues[i];
            String substitutedValue = state.substituteVariables(paramValue);
            if (StringsKt.equals((String)paramName, (String)"file", (boolean)true) || StringsKt.equals((String)paramName, (String)"virtual", (boolean)true)) {
                boolean virtual = StringsKt.equals((String)paramName, (String)"virtual", (boolean)true);
                SsiExternalResolver ssiExternalResolver = state.ssiExternalResolver;
                Intrinsics.checkNotNull((Object)substitutedValue);
                lastModified = ssiExternalResolver.getFileLastModified(substitutedValue, virtual);
                Strftime strftime = new Strftime(state.configTimeFmt, Locale.US);
                String string2 = strftime.format(new Date(lastModified));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                writer.write(string2);
                continue;
            }
            SsiProcessorKt.getLOG().info("#flastmod--Invalid attribute: " + paramName);
            Intrinsics.checkNotNull((Object)configErrMsg);
            writer.write(configErrMsg);
        }
        return lastModified;
    }

    private static final long _init_$lambda$4(SsiProcessingState state, String string, List paramNames, String[] stringArray, ByteBufUtf8Writer writer) {
        long lastModified = 0L;
        if (paramNames.isEmpty()) {
            LinkedHashSet<String> variableNames = new LinkedHashSet<String>();
            variableNames.add("DATE_GMT");
            variableNames.add("DATE_LOCAL");
            variableNames.add("LAST_MODIFIED");
            state.ssiExternalResolver.addVariableNames((Collection<String>)variableNames);
            Iterator iterator = variableNames.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String variableName = (String)e;
                String variableValue = state.getVariableValue(variableName);
                if (variableValue == null) {
                    variableValue = "(none)";
                }
                writer.append((CharSequence)variableName).append('=').append(variableValue).append('\n');
                lastModified = System.currentTimeMillis();
            }
        } else {
            String string2 = state.configErrorMessage;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"configErrorMessage");
            writer.write(string2);
        }
        return lastModified;
    }

    private static final long _init_$lambda$5(SsiProcessingState state, String string, List paramNames, String[] paramValues, ByteBufUtf8Writer writer) {
        long lastModified = 0L;
        String errorMessage = state.configErrorMessage;
        String variableName = null;
        int n = ((Collection)paramNames).size();
        for (int i = 0; i < n; ++i) {
            String paramName = (String)paramNames.get(i);
            String paramValue = paramValues[i];
            if (StringsKt.equals((String)paramName, (String)"var", (boolean)true)) {
                variableName = paramValue;
                continue;
            }
            if (StringsKt.equals((String)paramName, (String)"value", (boolean)true)) {
                if (variableName != null) {
                    String substitutedValue = state.substituteVariables(paramValue);
                    SsiExternalResolver ssiExternalResolver = state.ssiExternalResolver;
                    Intrinsics.checkNotNull((Object)substitutedValue);
                    ssiExternalResolver.setVariableValue(variableName, substitutedValue);
                    lastModified = System.currentTimeMillis();
                    continue;
                }
                SsiProcessorKt.getLOG().info("#set--no variable specified");
                Intrinsics.checkNotNull((Object)errorMessage);
                writer.write(errorMessage);
                throw new SsiStopProcessingException();
            }
            SsiProcessorKt.getLOG().info("#set--Invalid attribute: " + paramName);
            Intrinsics.checkNotNull((Object)errorMessage);
            writer.write(errorMessage);
            throw new SsiStopProcessingException();
        }
        return lastModified;
    }
}

