/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.codeWithMe.ClientId;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.util.SystemProperties;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServerAuth;
import org.jetbrains.ide.BuiltInServerBundle;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.BuiltInServerManagerImpl;
import org.jetbrains.ide.BuiltInServerManagerImplKt;
import org.jetbrains.ide.CustomPortServerManager;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.SubServer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0001H\u0016J\u000e\u0010\u0019\u001a\u00020\u001aH\u0082@\u00a2\u0006\u0002\u0010\u001bJ\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0017\u0010!\u001a\u00020\u001a2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u000bH\u0002J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\r\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lorg/jetbrains/ide/BuiltInServerManagerImpl;", "Lorg/jetbrains/ide/BuiltInServerManager;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "serverStartFuture", "Lkotlinx/coroutines/Job;", "server", "Lorg/jetbrains/io/BuiltInServer;", "portOverride", "", "Ljava/lang/Integer;", "port", "getPort", "()I", "serverDisposable", "Lcom/intellij/openapi/Disposable;", "getServerDisposable", "()Lcom/intellij/openapi/Disposable;", "createClientBootstrap", "Lio/netty/bootstrap/Bootstrap;", "createServerBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "waitForStart", "startServerInPooledThread", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isOnBuiltInWebServer", "", "url", "Lcom/intellij/util/Url;", "addAuthToken", "overridePort", "(Ljava/lang/Integer;)V", "configureRequestToWebServer", "connection", "Ljava/net/URLConnection;", "getDefaultPort", "bindCustomPorts", "Companion", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nBuiltInServerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInServerManagerImpl.kt\norg/jetbrains/ide/BuiltInServerManagerImpl\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,189:1\n42#2,3:190\n42#2,3:193\n*S KotlinDebug\n*F\n+ 1 BuiltInServerManagerImpl.kt\norg/jetbrains/ide/BuiltInServerManagerImpl\n*L\n152#1:190,3\n162#1:193,3\n*E\n"})
public final class BuiltInServerManagerImpl
extends BuiltInServerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private Job serverStartFuture;
    @Nullable
    private BuiltInServer server;
    @Nullable
    private Integer portOverride;
    @NotNull
    public static final String NOTIFICATION_GROUP = "Built-in Server";

    public BuiltInServerManagerImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        Application app = ApplicationManager.getApplication();
        this.serverStartFuture = app.isUnitTestMode() ? null : BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BuiltInServerManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.startServerInPooledThread((Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public int getPort() {
        int n;
        Integer n2 = this.portOverride;
        if (n2 != null) {
            n = n2;
        } else {
            BuiltInServer builtInServer = this.server;
            Integer n3 = builtInServer != null ? Integer.valueOf(builtInServer.getPort()) : null;
            n = n3 != null ? n3.intValue() : this.getDefaultPort();
        }
        return n;
    }

    @Nullable
    public Disposable getServerDisposable() {
        return this.server;
    }

    @NotNull
    public Bootstrap createClientBootstrap() {
        BuiltInServer builtInServer = this.server;
        Intrinsics.checkNotNull((Object)builtInServer);
        Bootstrap bootstrap = NettyUtil.nioClientBootstrap((EventLoopGroup)builtInServer.getChildEventLoopGroup());
        Intrinsics.checkNotNullExpressionValue((Object)bootstrap, (String)"nioClientBootstrap(...)");
        return bootstrap;
    }

    @NotNull
    public final ServerBootstrap createServerBootstrap() {
        BuiltInServer builtInServer = this.server;
        Intrinsics.checkNotNull((Object)builtInServer);
        return builtInServer.createServerBootstrap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public BuiltInServerManager waitForStart() {
        Application app = ApplicationManager.getApplication();
        BuiltInServerManagerImplKt.access$getLOG$p().assertTrue(app.isUnitTestMode() || app.isHeadlessEnvironment() || !app.isDispatchThread(), (Object)"Should not wait for built-in server on EDT");
        Job future = null;
        BuiltInServerManagerImpl builtInServerManagerImpl = this;
        synchronized (builtInServerManagerImpl) {
            boolean bl = false;
            future = this.serverStartFuture;
            if (future == null) {
                this.serverStartFuture = future = BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ BuiltInServerManagerImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = BuiltInServerManagerImpl.access$startServerInPooledThread(this.this$0, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        Job job = future;
        Intrinsics.checkNotNull((Object)job);
        FutureKt.asCompletableFuture((Job)job).join();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private final Object startServerInPooledThread(Continuation<? super Unit> $completion) {
        if (!($completion instanceof startServerInPooledThread.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BuiltInServerManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BuiltInServerManagerImpl.access$startServerInPooledThread(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (SystemProperties.getBooleanProperty((String)"idea.builtin.server.disabled", (boolean)false)) {
                    return Unit.INSTANCE;
                }
                $continuation.label = 1;
                v0 = RegistryManager.Companion.getInstanceAsync((Continuation)$continuation);
                if (v0 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                $continuation.label = 2;
                v1 = ((RegistryManager)v0).awaitRegistryLoad((Continuation)$continuation);
                if (v1 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl31
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl31:
                // 3 sources

                var5_5 = this;
                $continuation.L$0 = var5_5;
                $continuation.label = 3;
                v2 = BuiltInServer.Companion.start$default(BuiltInServer.Companion, this.getDefaultPort(), 20, true, null, (Continuation)$continuation, 8, null);
                ** if (v2 != var8_4) goto lbl38
lbl37:
                // 1 sources

                return var8_4;
lbl38:
                // 1 sources

                ** GOTO lbl45
            }
            case 3: {
                var5_5 = (BuiltInServerManagerImpl)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl45:
                    // 2 sources

                    var5_5.server = (BuiltInServer)v2;
                    v3 = this.server;
                    Intrinsics.checkNotNull((Object)v3);
                    this.bindCustomPorts(v3);
                }
                catch (CancellationException <unused var>) {
                    return Unit.INSTANCE;
                }
                catch (Throwable e) {
                    BuiltInServerManagerImplKt.access$getLOG$p().info(e);
                    var4_8 = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()};
                    v4 = BuiltInServerBundle.message((String)"notification.content.cannot.start.internal.http.server.and.ask.for.restart.0", (Object[])var4_8);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"message(...)");
                    message = v4;
                    new Notification("Built-in Server", message, NotificationType.ERROR).notify(null);
                    return Unit.INSTANCE;
                }
                v5 = BuiltInServerManagerImplKt.access$getLOG$p();
                v6 = this.server;
                Intrinsics.checkNotNull((Object)v6);
                v5.info("built-in server started, port " + v6.getPort());
                v7 = (Disposable)ApplicationManager.getApplication();
                v8 = this.server;
                Intrinsics.checkNotNull((Object)v8);
                Disposer.register((Disposable)v7, (Disposable)v8);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOnBuiltInWebServer(@Nullable Url url) {
        if (url == null) return false;
        CharSequence charSequence = url.getAuthority();
        if (charSequence == null) return false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        String string = url.getAuthority();
        Intrinsics.checkNotNull((Object)string);
        if (!Companion.isOnBuiltInWebServerByAuthority(string)) return false;
        return true;
    }

    @NotNull
    public Url addAuthToken(@NotNull Url url) {
        Url url2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (url.getParameters() != null) {
            url2 = url;
        } else {
            String string = url.getScheme();
            Intrinsics.checkNotNull((Object)string);
            String string2 = url.getAuthority();
            Intrinsics.checkNotNull((Object)string2);
            String string3 = url.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            boolean $i$f$service = false;
            Class<BuiltInWebServerAuth> serviceClass$iv = BuiltInWebServerAuth.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            url2 = Urls.newUrl((String)string, (String)string2, (String)string3, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"_ijt", (Object)((BuiltInWebServerAuth)object).acquireToken())));
        }
        return url2;
    }

    public void overridePort(@Nullable Integer port) {
        Integer n = port;
        int n2 = this.getPort();
        if (n == null || n != n2) {
            this.portOverride = port;
        }
    }

    public void configureRequestToWebServer(@NotNull URLConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        boolean $i$f$service = false;
        Class<BuiltInWebServerAuth> serviceClass$iv = BuiltInWebServerAuth.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        connection.setRequestProperty("x-ijt", ((BuiltInWebServerAuth)object).acquireToken());
    }

    private final int getDefaultPort() {
        Object object = System.getProperty("rpc.port");
        return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : (ApplicationManager.getApplication().isUnitTestMode() ? 64463 : 63342);
    }

    private final void bindCustomPorts(BuiltInServer server) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        CustomPortServerManager.EP_NAME.forEachExtensionSafe(arg_0 -> BuiltInServerManagerImpl.bindCustomPorts$lambda$1(arg_0 -> BuiltInServerManagerImpl.bindCustomPorts$lambda$0(server, arg_0), arg_0));
    }

    private static final Unit bindCustomPorts$lambda$0(BuiltInServer $server, CustomPortServerManager customPortServerManager) {
        Intrinsics.checkNotNullParameter((Object)customPortServerManager, (String)"customPortServerManager");
        new SubServer(customPortServerManager, $server).bind(customPortServerManager.getPort());
        return Unit.INSTANCE;
    }

    private static final void bindCustomPorts$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @JvmStatic
    public static final boolean isOnBuiltInWebServerByAuthority(@NotNull String authority) {
        return Companion.isOnBuiltInWebServerByAuthority(authority);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/ide/BuiltInServerManagerImpl$Companion;", "", "<init>", "()V", "NOTIFICATION_GROUP", "", "isOnBuiltInWebServerByAuthority", "", "authority", "intellij.platform.builtInServer.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isOnBuiltInWebServerByAuthority(@NotNull String authority) {
            Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
            int portIndex = StringsKt.indexOf$default((CharSequence)authority, (char)':', (int)0, (boolean)false, (int)6, null);
            if (portIndex < 0 || portIndex == authority.length() - 1) {
                return false;
            }
            String string = authority.substring(portIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Integer n = StringsKt.toIntOrNull((String)string);
            if (n == null) {
                return false;
            }
            int port = n;
            BuiltInServerOptions options = BuiltInServerOptions.getInstance();
            int idePort = BuiltInServerManager.Companion.getInstance().getPort();
            if (options.builtInServerPort != port && idePort != port) {
                return false;
            }
            String host = StringsKt.take((String)authority, (int)portIndex);
            if (NetUtils.isLocalhost((String)host)) {
                return true;
            }
            try {
                InetAddress inetAddress = InetAddress.getByName(host);
                return inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress() || options.builtInServerAvailableExternally && idePort != port && NetworkInterface.getByInetAddress(inetAddress) != null;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

