/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Security;
import java.util.UUID;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BinaryRequestHandler;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.Decoder;
import org.jetbrains.io.DelegatingHttpRequestHandler;
import org.jetbrains.io.NettyUtil;

@ChannelHandler.Sharable
final class PortUnificationServerHandler
extends Decoder {
    private static final Supplier<SslContext> SSL_SERVER_CONTEXT = new SynchronizedClearableLazy(() -> {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        try {
            KeyStore ks = KeyStore.getInstance("JCEKS");
            char[] password = "jb".toCharArray();
            String keyStoreResourceName = "cert.jceks";
            InputStream keyStoreData = PortUnificationServerHandler.class.getResourceAsStream(keyStoreResourceName);
            if (keyStoreData == null) {
                throw new RuntimeException("Cannot find " + keyStoreResourceName);
            }
            ks.load(keyStoreData, password);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
            keyManagerFactory.init(ks, password);
            return SslContextBuilder.forServer((KeyManagerFactory)keyManagerFactory).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    });
    private final boolean detectSsl;
    private final boolean detectGzip;
    private final DelegatingHttpRequestHandler delegatingHttpRequestHandler;

    PortUnificationServerHandler() {
        this(new DelegatingHttpRequestHandler(), true, true);
    }

    private PortUnificationServerHandler(@NotNull DelegatingHttpRequestHandler delegatingHttpRequestHandler, boolean detectSsl, boolean detectGzip) {
        if (delegatingHttpRequestHandler == null) {
            PortUnificationServerHandler.$$$reportNull$$$0(0);
        }
        this.delegatingHttpRequestHandler = delegatingHttpRequestHandler;
        this.detectSsl = detectSsl;
        this.detectGzip = detectGzip;
    }

    protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) {
        ByteBuf buffer;
        if (context == null) {
            PortUnificationServerHandler.$$$reportNull$$$0(1);
        }
        if (input == null) {
            PortUnificationServerHandler.$$$reportNull$$$0(2);
        }
        if ((buffer = this.getBufferIfSufficient(input, 5, context)) != null) {
            this.decode(context, buffer);
        }
    }

    private void decode(@NotNull ChannelHandlerContext context, @NotNull ByteBuf buffer) {
        if (context == null) {
            PortUnificationServerHandler.$$$reportNull$$$0(3);
        }
        if (buffer == null) {
            PortUnificationServerHandler.$$$reportNull$$$0(4);
        }
        ChannelPipeline pipeline = context.pipeline();
        if (this.detectSsl && SslHandler.isEncrypted((ByteBuf)buffer, (boolean)false)) {
            SSLEngine engine = SSL_SERVER_CONTEXT.get().newEngine(context.alloc());
            engine.setUseClientMode(false);
            pipeline.addLast(new ChannelHandler[]{new SslHandler(engine), new ChunkedWriteHandler(), new PortUnificationServerHandler(this.delegatingHttpRequestHandler, false, this.detectGzip)});
        } else {
            short magic1 = buffer.getUnsignedByte(buffer.readerIndex());
            short magic2 = buffer.getUnsignedByte(buffer.readerIndex() + 1);
            if (this.detectGzip && magic1 == 31 && magic2 == 139) {
                pipeline.addLast(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.GZIP), ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP), new PortUnificationServerHandler(this.delegatingHttpRequestHandler, this.detectSsl, false)});
            } else if (PortUnificationServerHandler.isHttp(magic1, magic2)) {
                NettyUtil.addHttpServerCodec((ChannelPipeline)pipeline);
                pipeline.addLast("delegatingHttpHandler", (ChannelHandler)this.delegatingHttpRequestHandler);
                final Logger logger = Logger.getInstance(BuiltInServer.class);
                if (logger.isDebugEnabled()) {
                    pipeline.addLast(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(this){

                        public void write(ChannelHandlerContext context, Object message, ChannelPromise promise) throws Exception {
                            if (message instanceof HttpResponse) {
                                HttpResponse response = (HttpResponse)message;
                                logger.debug("OUT HTTP: " + String.valueOf(response));
                            }
                            super.write(context, message, promise);
                        }
                    }});
                }
            } else if (magic1 == 67 && magic2 == 72) {
                buffer.skipBytes(2);
                pipeline.addLast(new ChannelHandler[]{new CustomHandlerDelegator()});
            } else {
                Logger.getInstance(BuiltInServer.class).warn("unknown request, first two bytes " + magic1 + " " + magic2);
                context.close();
            }
        }
        pipeline.remove((ChannelHandler)this);
        buffer.retain();
        context.fireChannelRead((Object)buffer);
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        NettyUtil.logAndClose((Throwable)cause, (Logger)Logger.getInstance(BuiltInServer.class), (Channel)context.channel());
    }

    private static boolean isHttp(int magic1, int magic2) {
        return magic1 == 71 && magic2 == 69 || magic1 == 80 && magic2 == 79 || magic1 == 80 && magic2 == 85 || magic1 == 72 && magic2 == 69 || magic1 == 79 && magic2 == 80 || magic1 == 80 && magic2 == 65 || magic1 == 68 && magic2 == 69 || magic1 == 84 && magic2 == 82 || magic1 == 67 && magic2 == 79;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegatingHttpRequestHandler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/io/PortUnificationServerHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "messageReceived";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "decode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CustomHandlerDelegator
    extends Decoder {
        private static final int UUID_LENGTH = 16;

        private CustomHandlerDelegator() {
        }

        protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) {
            ByteBuf buffer;
            if (context == null) {
                CustomHandlerDelegator.$$$reportNull$$$0(0);
            }
            if (input == null) {
                CustomHandlerDelegator.$$$reportNull$$$0(1);
            }
            if ((buffer = this.getBufferIfSufficient(input, 16, context)) == null) {
                return;
            }
            UUID uuid = new UUID(buffer.readLong(), buffer.readLong());
            for (BinaryRequestHandler customHandler : BinaryRequestHandler.EP_NAME.getExtensionList()) {
                if (!uuid.equals(customHandler.getId())) continue;
                ChannelPipeline pipeline = context.pipeline();
                pipeline.addLast(new ChannelHandler[]{customHandler.getInboundHandler(context)});
                pipeline.addLast(new ChannelHandler[]{ChannelExceptionHandler.getInstance()});
                pipeline.remove((ChannelHandler)this);
                context.fireChannelRead((Object)buffer);
                break;
            }
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
            NettyUtil.logAndClose((Throwable)cause, (Logger)Logger.getInstance(BuiltInServer.class), (Channel)context.channel());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "input";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/io/PortUnificationServerHandler$CustomHandlerDelegator";
            objectArray[2] = "messageReceived";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

