/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0016\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\u001dJ \u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiRequest;", "", "requestId", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "<init>", "(ILio/netty/buffer/ByteBufAllocator;)V", "getRequestId", "()I", "params", "Lio/netty/buffer/ByteBuf;", "kotlin.jvm.PlatformType", "writeFileHeaders", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalRequestPath", "", "addHeader", "key", "", "value", "writeParamLength", "length", "writeHeaders", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "clientChannel", "Lio/netty/channel/Channel;", "writeToServerChannel", "content", "fastCgiChannel", "writeHeader", "buffer", "type", "intellij.platform.builtInServer.impl"})
public final class FastCgiRequest {
    private final int requestId;
    private final ByteBuf params;

    public FastCgiRequest(int requestId, @NotNull ByteBufAllocator allocator) {
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        this.requestId = requestId;
        this.params = allocator.ioBuffer(4096);
    }

    public final int getRequestId() {
        return this.requestId;
    }

    public final void writeFileHeaders(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalRequestPath) {
        Intrinsics.checkNotNullParameter((Object)pathInfo, (String)"pathInfo");
        Intrinsics.checkNotNullParameter((Object)canonicalRequestPath, (String)"canonicalRequestPath");
        VirtualFile root = pathInfo.getRoot();
        this.addHeader("DOCUMENT_ROOT", FileUtil.toSystemDependentName((String)root.getPath()));
        this.addHeader("SCRIPT_FILENAME", pathInfo.getFilePath());
        this.addHeader("SCRIPT_NAME", canonicalRequestPath);
    }

    private final void addHeader(String key, CharSequence value) {
        int n;
        byte[] byArray;
        if (value == null) {
            return;
        }
        CharSequence charSequence = value;
        String string = charSequence instanceof String ? (String)charSequence : null;
        if (string != null) {
            charSequence = string;
            byte[] byArray2 = ((String)charSequence).getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        } else {
            byArray = null;
        }
        byte[] valBytes = byArray;
        ByteBuffer valBuffer = value instanceof String ? null : Charsets.UTF_8.encode(CharBuffer.wrap(value));
        int keyLength = key.length();
        if (valBytes != null) {
            n = valBytes.length;
        } else {
            ByteBuffer byteBuffer = valBuffer;
            Intrinsics.checkNotNull((Object)byteBuffer);
            n = byteBuffer.limit();
        }
        int valLength = n;
        this.writeParamLength(keyLength);
        this.writeParamLength(valLength);
        ByteBufUtil.writeAscii((ByteBuf)this.params, (CharSequence)key);
        ByteBuf byteBuf = valBuffer == null ? this.params.writeBytes(valBytes) : this.params.writeBytes(valBuffer);
    }

    private final void writeParamLength(int length) {
        ByteBuf byteBuf = length > 127 ? this.params.writeInt(length | Integer.MIN_VALUE) : this.params.writeByte(length);
    }

    public final void writeHeaders(@NotNull FullHttpRequest request, @NotNull Channel clientChannel) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)clientChannel, (String)"clientChannel");
        this.addHeader("REQUEST_URI", request.uri());
        this.addHeader("REQUEST_METHOD", request.method().name());
        SocketAddress socketAddress = clientChannel.remoteAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        InetSocketAddress remote = (InetSocketAddress)socketAddress;
        this.addHeader("REMOTE_ADDR", remote.getAddress().getHostAddress());
        this.addHeader("REMOTE_PORT", String.valueOf(remote.getPort()));
        SocketAddress socketAddress2 = clientChannel.localAddress();
        Intrinsics.checkNotNull((Object)socketAddress2, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        InetSocketAddress local = (InetSocketAddress)socketAddress2;
        this.addHeader("SERVER_NAME", Responses.getServerHeaderValue());
        this.addHeader("SERVER_ADDR", local.getAddress().getHostAddress());
        this.addHeader("SERVER_PORT", String.valueOf(local.getPort()));
        this.addHeader("GATEWAY_INTERFACE", "CGI/1.1");
        this.addHeader("SERVER_PROTOCOL", request.protocolVersion().text());
        this.addHeader("REDIRECT_STATUS", "200");
        String queryString = "";
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        int queryIndex = StringsKt.indexOf$default((CharSequence)string, (char)'?', (int)0, (boolean)false, (int)6, null);
        if (queryIndex != -1) {
            String string2 = request.uri();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri(...)");
            object = string2;
            int n = queryIndex + 1;
            String string3 = ((String)object).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            queryString = string3;
            String string4 = request.uri();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"uri(...)");
            object = string4;
            n = 0;
            String string5 = ((String)object).substring(n, queryIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            this.addHeader("DOCUMENT_URI", string5);
        } else {
            this.addHeader("DOCUMENT_URI", request.uri());
        }
        this.addHeader("QUERY_STRING", queryString);
        this.addHeader("CONTENT_LENGTH", String.valueOf(request.content().readableBytes()));
        String string6 = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (string6 == null) {
            string6 = "";
        }
        this.addHeader("CONTENT_TYPE", string6);
        Iterator iterator = request.headers().iteratorAsString();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iteratorAsString(...)");
        object = iterator;
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            Intrinsics.checkNotNull((Object)entry);
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (StringsKt.equals((String)key, (String)"keep-alive", (boolean)true) || StringsKt.equals((String)key, (String)"connection", (boolean)true)) continue;
            Intrinsics.checkNotNull((Object)key);
            String string7 = StringsKt.replace$default((String)key, (char)'-', (char)'_', (boolean)false, (int)4, null);
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string8 = string7.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toUpperCase(...)");
            this.addHeader("HTTP_" + string8, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToServerChannel(@Nullable ByteBuf content, @NotNull Channel fastCgiChannel) {
        Intrinsics.checkNotNullParameter((Object)fastCgiChannel, (String)"fastCgiChannel");
        if (fastCgiChannel.pipeline().first() == null) {
            throw new IllegalStateException("No handler in the pipeline");
        }
        try {
            ByteBuf buffer = fastCgiChannel.alloc().ioBuffer(4096);
            Intrinsics.checkNotNull((Object)buffer);
            this.writeHeader(buffer, 1, 8);
            buffer.writeShort(1);
            buffer.writeByte(1);
            buffer.writeZero(5);
            this.writeHeader(buffer, 4, this.params.readableBytes());
            buffer.writeBytes(this.params);
            this.writeHeader(buffer, 4, 0);
            fastCgiChannel.write((Object)buffer);
            if (content != null) {
                int position = content.readerIndex();
                int toWrite = content.readableBytes();
                while (toWrite > 0) {
                    int length = Math.min(65535, toWrite);
                    ByteBuf headerBuffer = fastCgiChannel.alloc().ioBuffer(8, 8);
                    Intrinsics.checkNotNull((Object)headerBuffer);
                    this.writeHeader(headerBuffer, 5, length);
                    fastCgiChannel.write((Object)headerBuffer);
                    ByteBuf chunk = content.slice(position, length);
                    chunk.retain();
                    fastCgiChannel.write((Object)chunk);
                    toWrite -= length;
                    position += length;
                }
                ByteBuf headerBuffer = fastCgiChannel.alloc().ioBuffer(8, 8);
                Intrinsics.checkNotNull((Object)headerBuffer);
                this.writeHeader(headerBuffer, 5, 0);
                fastCgiChannel.write((Object)headerBuffer);
            }
        }
        finally {
            ByteBuf byteBuf = content;
            if (byteBuf != null) {
                byteBuf.release();
            }
        }
        fastCgiChannel.flush();
    }

    private final void writeHeader(ByteBuf buffer, int type, int length) {
        buffer.writeByte(1);
        buffer.writeByte(type);
        buffer.writeShort(this.requestId);
        buffer.writeShort(length);
        buffer.writeZero(2);
    }
}

