/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import com.intellij.util.net.NetUtils;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.ConsoleManager;
import org.jetbrains.builtInWebServer.NetService;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001$B\u001b\b\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0010H$J4\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J\b\u0010\u001a\u001a\u00020\u0014H$J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u0019H%J\b\u0010 \u001a\u00020!H$J\b\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lorg/jetbrains/builtInWebServer/NetService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "consoleManager", "Lorg/jetbrains/builtInWebServer/ConsoleManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/builtInWebServer/ConsoleManager;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "processHandler", "Lorg/jetbrains/concurrency/AsyncValueLoader;", "Lcom/intellij/execution/process/OSProcessHandler;", "getProcessHandler", "()Lorg/jetbrains/concurrency/AsyncValueLoader;", "getAvailableSocketPort", "", "createProcessHandler", "port", "connectToProcess", "", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "closeProcessConnections", "dispose", "configureConsole", "consoleBuilder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "getConsoleToolWindowId", "getConsoleToolWindowIcon", "Ljavax/swing/Icon;", "getConsoleToolWindowActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "MyProcessAdapter", "intellij.platform.builtInServer.impl"})
public abstract class NetService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ConsoleManager consoleManager;
    @NotNull
    private final AsyncValueLoader<OSProcessHandler> processHandler;

    @JvmOverloads
    protected NetService(@NotNull Project project, @NotNull ConsoleManager consoleManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)consoleManager, (String)"consoleManager");
        this.project = project;
        this.consoleManager = consoleManager;
        this.processHandler = (AsyncValueLoader)new AsyncValueLoader<OSProcessHandler>(this){
            final /* synthetic */ NetService this$0;
            {
                this.this$0 = $receiver;
            }

            protected boolean isCancelOnReject() {
                return true;
            }

            private final OSProcessHandler doGetProcessHandler(int port) {
                try {
                    return this.this$0.createProcessHandler(this.this$0.getProject(), port);
                }
                catch (ExecutionException e) {
                    BuiltInWebServerKt.getLOG().error((Throwable)e);
                    return null;
                }
            }

            protected Promise<OSProcessHandler> load(AsyncPromise<OSProcessHandler> promise) {
                Intrinsics.checkNotNullParameter(promise, (String)"promise");
                int port = this.this$0.getAvailableSocketPort();
                OSProcessHandler processHandler2 = this.doGetProcessHandler(port);
                if (processHandler2 == null) {
                    promise.setError("rejected");
                    return (Promise)promise;
                }
                promise.onError(arg_0 -> processHandler.1.load$lambda$1(arg_0 -> processHandler.1.load$lambda$0(processHandler2, arg_0), arg_0));
                MyProcessAdapter processListener = this.this$0.new MyProcessAdapter(processHandler2);
                processHandler2.addProcessListener((ProcessListener)processListener);
                processHandler2.startNotify();
                if (Promises.isRejected((Promise)((Promise)promise))) {
                    return (Promise)promise;
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> processHandler.1.load$lambda$2(promise, this.this$0, port, processHandler2, processListener));
                return (Promise)promise;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void disposeResult(OSProcessHandler processHandler2) {
                Intrinsics.checkNotNullParameter((Object)processHandler2, (String)"processHandler");
                try {
                    this.this$0.closeProcessConnections();
                }
                finally {
                    processHandler2.destroyProcess();
                }
            }

            private static final Unit load$lambda$0(OSProcessHandler $processHandler, Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $processHandler.destroyProcess();
                Promises.errorIfNotMessage((Logger)BuiltInWebServerKt.getLOG(), (Throwable)it);
                return Unit.INSTANCE;
            }

            private static final void load$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            private static final void load$lambda$2(AsyncPromise $promise, NetService this$0, int $port, OSProcessHandler $processHandler, MyProcessAdapter $processListener) {
                block3: {
                    if (!Promises.isRejected((Promise)((Promise)$promise))) {
                        try {
                            this$0.connectToProcess((AsyncPromise<OSProcessHandler>)$promise, $port, $processHandler, (Consumer<String>)((Consumer)$processListener));
                        }
                        catch (Throwable e) {
                            if ($promise.setError(e)) break block3;
                            BuiltInWebServerKt.getLOG().error(e);
                        }
                    }
                }
            }
        };
    }

    public /* synthetic */ NetService(Project project, ConsoleManager consoleManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            consoleManager = new ConsoleManager();
        }
        this(project, consoleManager);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final AsyncValueLoader<OSProcessHandler> getProcessHandler() {
        return this.processHandler;
    }

    protected int getAvailableSocketPort() {
        return NetUtils.findAvailableSocketPort();
    }

    @Nullable
    protected abstract OSProcessHandler createProcessHandler(@NotNull Project var1, int var2) throws ExecutionException;

    protected void connectToProcess(@NotNull AsyncPromise<OSProcessHandler> promise, int port, @NotNull OSProcessHandler processHandler2, @NotNull Consumer<String> errorOutputConsumer) {
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        Intrinsics.checkNotNullParameter((Object)processHandler2, (String)"processHandler");
        Intrinsics.checkNotNullParameter(errorOutputConsumer, (String)"errorOutputConsumer");
        promise.setResult((Object)processHandler2);
    }

    protected abstract void closeProcessConnections();

    public void dispose() {
        this.processHandler.reset();
    }

    protected void configureConsole(@NotNull TextConsoleBuilder consoleBuilder) {
        Intrinsics.checkNotNullParameter((Object)consoleBuilder, (String)"consoleBuilder");
    }

    @NonNls
    @NotNull
    protected abstract String getConsoleToolWindowId();

    @NotNull
    protected abstract Icon getConsoleToolWindowIcon();

    @NotNull
    public ActionGroup getConsoleToolWindowActions() {
        return (ActionGroup)new DefaultActionGroup();
    }

    @JvmOverloads
    protected NetService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(project, null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0011\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/builtInWebServer/NetService$MyProcessAdapter;", "Lcom/intellij/execution/process/ProcessListener;", "Lcom/intellij/util/Consumer;", "", "osProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "<init>", "(Lorg/jetbrains/builtInWebServer/NetService;Lcom/intellij/execution/process/OSProcessHandler;)V", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "print", "text", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "processTerminated", "consume", "message", "intellij.platform.builtInServer.impl"})
    private final class MyProcessAdapter
    implements ProcessListener,
    Consumer<String> {
        @Nullable
        private final OSProcessHandler osProcessHandler;

        public MyProcessAdapter(OSProcessHandler osProcessHandler) {
            this.osProcessHandler = osProcessHandler;
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType(outputType);
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getConsoleViewType(...)");
            this.print(string, consoleViewContentType);
        }

        private final void print(String text, ConsoleViewContentType contentType) {
            NetService.this.consoleManager.getConsole(NetService.this).print(text, contentType);
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            OSProcessHandler result = (OSProcessHandler)NetService.this.getProcessHandler().getResultIfFullFilled();
            if (result != null && Intrinsics.areEqual((Object)result, (Object)this.osProcessHandler)) {
                NetService.this.getProcessHandler().reset();
            }
            String string = NetService.this.getConsoleToolWindowId() + " terminated\n";
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"SYSTEM_OUTPUT");
            this.print(string, consoleViewContentType);
        }

        public void consume(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ERROR_OUTPUT");
            this.print(message, consoleViewContentType);
        }
    }
}

