/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.liveReload;

import com.intellij.CommonBundle;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.browsers.ReloadMode;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.ide.browsers.actions.WebPreviewFileEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.GotItTooltip;
import com.intellij.util.SingleAlarm;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.liveReload.WebServerFileContentListener;
import org.jetbrains.builtInWebServer.liveReload.WebServerPageConnectionService;
import org.jetbrains.ide.BuiltInServerBundle;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.JsonRpcServer;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.WebSocketClient;
import org.jetbrains.io.webSocket.WebSocketHandshakeHandler;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 %2\u00020\u0001:\u0003#$%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00150\u0014J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\"\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService;", "", "<init>", "()V", "RELOAD_PAGE_MESSAGE", "Lio/netty/buffer/ByteBuf;", "kotlin.jvm.PlatformType", "myServer", "Lorg/jetbrains/io/jsonRpc/ClientManager;", "myRpcServer", "Lorg/jetbrains/io/jsonRpc/JsonRpcServer;", "myState", "Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$RequestedPagesState;", "fileRequested", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "onlyIfHtmlFile", "", "fileSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/vfs/VirtualFile;", "reloadRelatedClients", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "modifiedFiles", "", "clientConnected", "", "client", "Lorg/jetbrains/io/webSocket/WebSocketClient;", "referrer", "reloadMode", "Lcom/intellij/ide/browsers/ReloadMode;", "clientDisconnected", "showGotItTooltip", "WebServerPageRequestHandler", "RequestedPagesState", "Companion", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nWebServerPageConnectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebServerPageConnectionService.kt\norg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,502:1\n1#2:503\n*E\n"})
public final class WebServerPageConnectionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final ByteBuf RELOAD_PAGE_MESSAGE = Unpooled.copiedBuffer((CharSequence)"reload", (Charset)CharsetUtil.US_ASCII).asReadOnly();
    @Nullable
    private ClientManager myServer;
    @Nullable
    private JsonRpcServer myRpcServer;
    @NotNull
    private final RequestedPagesState myState = new RequestedPagesState();
    @NotNull
    public static final String RELOAD_URL_PARAM = "_ij_reload";
    @NotNull
    public static final String SERVER_RELOAD_TOOLTIP_ID = "builtin.web.server.reload.on.save";
    @NotNull
    private static final String RELOAD_WS_REQUEST = "reload";
    @NotNull
    private static final String UPDATE_LINK_WS_REQUEST_PREFIX = "update-css ";
    @NotNull
    private static final String RELOAD_WS_URL_PREFIX = "jb-server-page";
    @NotNull
    private static final String RELOAD_MODE_URL_PARAMETER = "reloadMode";
    @NotNull
    private static final String REFERRER_URL_PARAMETER = "referrer";
    @NotNull
    private static final String UPDATE_LINKS_ID_URL_PARAMETER = "jbUpdateLinksId";
    @NotNull
    private static final Logger LOGGER;

    @Nullable
    public final String fileRequested(@NotNull FullHttpRequest request, boolean onlyIfHtmlFile, @NotNull Supplier<? extends VirtualFile> fileSupplier) {
        String path;
        String uri;
        Object reloadRequest;
        block9: {
            Object object;
            block10: {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter(fileSupplier, (String)"fileSupplier");
                reloadRequest = ReloadMode.DISABLED;
                uri = request.uri();
                path = null;
                if (uri == null || !StringsKt.contains$default((CharSequence)uri, (CharSequence)RELOAD_URL_PARAM, (boolean)false, (int)2, null)) break block9;
                QueryStringDecoder decoder = new QueryStringDecoder(uri);
                path = decoder.path();
                object = (List)decoder.parameters().get(RELOAD_URL_PARAM);
                if (object == null || (object = (String)object.get(0)) == null) break block10;
                Object it = object;
                boolean bl = false;
                ReloadMode reloadMode = ReloadMode.valueOf((String)it);
                object = reloadMode;
                if (reloadMode != null) break block9;
            }
            object = reloadRequest = ReloadMode.DISABLED;
        }
        if (reloadRequest == ReloadMode.DISABLED && this.myState.isEmpty()) {
            return null;
        }
        VirtualFile file = fileSupplier.get();
        if (reloadRequest == ReloadMode.DISABLED && file != null) {
            this.myState.resourceRequested(request, file);
            return null;
        }
        if (reloadRequest == ReloadMode.DISABLED) {
            return null;
        }
        if (file == null) {
            LOGGER.warn("VirtualFile for " + uri + " isn't resolved, reload on save can't be started");
            return null;
        }
        if (onlyIfHtmlFile && !WebBrowserXmlService.Companion.getInstance().isHtmlFile(file)) {
            return null;
        }
        if (path == null) {
            LOGGER.warn("path not evaluated for " + uri);
            return null;
        }
        this.myState.pageRequested(path, file, (ReloadMode)reloadRequest);
        String optionalConsoleLog = LOGGER.isDebugEnabled() ? "\nconsole.log('JetBrains Reload on Save script loaded');" : "";
        return StringsKt.trimIndent((String)("\n<script>\n(function() {" + optionalConsoleLog + "\n  var ws = new WebSocket('ws://' + window.location.host + \n             '/jb-server-page?reloadMode=" + reloadRequest + "&'+\n             'referrer=' + encodeURIComponent(window.location.pathname));\n  ws.onmessage = function (msg) {\n      if (msg.data === 'reload') {\n          window.location.reload();\n      }\n      if (msg.data.startsWith('update-css ')) {\n          var messageId = msg.data.substring(11);\n          var links = document.getElementsByTagName('link');\n          for (var i = 0; i < links.length; i++) {\n              var link = links[i];\n              if (link.rel !== 'stylesheet') continue;\n              var clonedLink = link.cloneNode(true);\n              var newHref = link.href.replace(/(&|\\?)jbUpdateLinksId=\\d+/, \"$1jbUpdateLinksId=\" + messageId);\n              if (newHref !== link.href) {\n                clonedLink.href = newHref;\n              }\n              else {\n                var indexOfQuest = newHref.indexOf('?');\n                if (indexOfQuest >= 0) {\n                  // to support ?foo#hash \n                  clonedLink.href = newHref.substring(0, indexOfQuest + 1) + 'jbUpdateLinksId=' + messageId + '&' + \n                                    newHref.substring(indexOfQuest + 1);\n                }\n                else {\n                  clonedLink.href += '?' + 'jbUpdateLinksId=' + messageId;\n                }\n              }\n              link.replaceWith(clonedLink);\n          }\n      }\n  };\n})();\n</script>\n    "));
    }

    @Nullable
    public final AsyncFileListener.ChangeApplier reloadRelatedClients(@NotNull List<? extends VirtualFile> modifiedFiles) {
        Intrinsics.checkNotNullParameter(modifiedFiles, (String)"modifiedFiles");
        if (this.myServer == null) {
            return null;
        }
        if (this.myState.isRequestedFileWithoutReferrerModified(modifiedFiles)) {
            return new AsyncFileListener.ChangeApplier(this, modifiedFiles){
                final /* synthetic */ WebServerPageConnectionService this$0;
                final /* synthetic */ List<VirtualFile> $modifiedFiles;
                {
                    this.this$0 = $receiver;
                    this.$modifiedFiles = $modifiedFiles;
                }

                public void afterVfsChange() {
                    block0: {
                        ClientManager server;
                        WebServerPageConnectionService.access$showGotItTooltip(this.this$0, this.$modifiedFiles);
                        WebServerPageConnectionService.access$getMyState$p(this.this$0).clear();
                        ClientManager clientManager = server = WebServerPageConnectionService.access$getMyServer$p(this.this$0);
                        if (clientManager == null) break block0;
                        ByteBuf byteBuf = WebServerPageConnectionService.access$getRELOAD_PAGE_MESSAGE$p(this.this$0).retainedDuplicate();
                        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"retainedDuplicate(...)");
                        clientManager.send(-1, byteBuf, null);
                    }
                }
            };
        }
        Map<RequestedPagesState.RequestedPage, List<VirtualFile>> affectedClients = this.myState.collectAffectedPages(modifiedFiles);
        return affectedClients.isEmpty() ? null : (AsyncFileListener.ChangeApplier)new AsyncFileListener.ChangeApplier(this, modifiedFiles, affectedClients){
            final /* synthetic */ WebServerPageConnectionService this$0;
            final /* synthetic */ List<VirtualFile> $modifiedFiles;
            final /* synthetic */ Map<RequestedPagesState.RequestedPage, List<VirtualFile>> $affectedClients;
            {
                this.this$0 = $receiver;
                this.$modifiedFiles = $modifiedFiles;
                this.$affectedClients = $affectedClients;
            }

            public void afterVfsChange() {
                WebServerPageConnectionService.access$showGotItTooltip(this.this$0, this.$modifiedFiles);
                for (Map.Entry<RequestedPagesState.RequestedPage, List<VirtualFile>> entry : this.$affectedClients.entrySet()) {
                    RequestedPagesState.RequestedPage requestedPage = entry.getKey();
                    List<VirtualFile> affectedFiles = entry.getValue();
                    if (affectedFiles.isEmpty()) {
                        WebServerPageConnectionService.access$getLOGGER$cp().debug("Reloading page for " + requestedPage);
                        for (RequestedPagesState.RequestedPageClient client : requestedPage.getClients()) {
                            client.getWebSocket().send(WebServerPageConnectionService.access$getRELOAD_PAGE_MESSAGE$p(this.this$0).retainedDuplicate());
                        }
                        continue;
                    }
                    Iterator<Object> iterator = ((Iterable)requestedPage.getClients()).iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        int clientIndex = n++;
                        RequestedPagesState.RequestedPageClient client = (RequestedPagesState.RequestedPageClient)iterator.next();
                        int messageId = WebServerPageConnectionService.access$getMyState$p(this.this$0).getNextMessageId();
                        WebServerPageConnectionService.access$getMyState$p(this.this$0).linkedFilesRequested(messageId, affectedFiles);
                        String message = "update-css " + messageId;
                        for (VirtualFile affectedFile : affectedFiles) {
                            if (clientIndex == 0) {
                                WebServerPageConnectionService.access$getLOGGER$cp().debug("Reload file " + affectedFile.getName() + " for " + requestedPage);
                            }
                            client.getWebSocket().send(Unpooled.copiedBuffer((CharSequence)message, (Charset)Charsets.UTF_8));
                        }
                        JobScheduler.getScheduler().schedule(() -> reloadRelatedClients.2.afterVfsChange$lambda$0(this.this$0, messageId, requestedPage, client), 1L, TimeUnit.SECONDS);
                    }
                }
            }

            private static final void afterVfsChange$lambda$0(WebServerPageConnectionService this$0, int $messageId, RequestedPagesState.RequestedPage $requestedPage, RequestedPagesState.RequestedPageClient $client) {
                if (!WebServerPageConnectionService.access$getMyState$p(this$0).isAllLinkedFilesReloaded($messageId)) {
                    WebServerPageConnectionService.access$getLOGGER$cp().debug("Some files weren't reloaded, reload whole " + $requestedPage + " for client");
                    $client.getWebSocket().send(WebServerPageConnectionService.access$getRELOAD_PAGE_MESSAGE$p(this$0).retainedDuplicate());
                }
            }
        };
    }

    private final void clientConnected(WebSocketClient client, String referrer, ReloadMode reloadMode) {
        this.myState.clientConnected(client, referrer, reloadMode);
    }

    private final void clientDisconnected(WebSocketClient client) {
        this.myState.clientDisconnected(client);
    }

    private final void showGotItTooltip(List<? extends VirtualFile> modifiedFiles) {
        String string = BuiltInServerBundle.message((String)"reload.on.save.got.it.content", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ClientManager clientManager = this.myServer;
        Intrinsics.checkNotNull((Object)clientManager);
        GotItTooltip gotItTooltip = new GotItTooltip(SERVER_RELOAD_TOOLTIP_ID, string, (Disposable)clientManager);
        if (!gotItTooltip.canShow() || WebPreviewFileEditor.Companion.isPreviewOpened()) {
            return;
        }
        if (WebBrowserManager.BROWSER_RELOAD_MODE_DEFAULT != ReloadMode.RELOAD_ON_SAVE) {
            Logger.getInstance(WebServerPageConnectionService.class).error("Default value for " + BuiltInServerBundle.message((String)"reload.on.save.got.it.title", (Object[])new Object[0]) + " has changed, tooltip is outdated.");
            return;
        }
        if (WebBrowserManager.getInstance().getWebServerReloadMode() != ReloadMode.RELOAD_ON_SAVE) {
            return;
        }
        String string2 = BuiltInServerBundle.message((String)"reload.on.save.got.it.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        gotItTooltip.withHeader(string2).withPosition(Balloon.Position.above);
        Component component = IdeFocusManager.getGlobalInstance().getFocusOwner();
        EditorComponentImpl editorComponentImpl = component instanceof EditorComponentImpl ? (EditorComponentImpl)component : null;
        if (editorComponentImpl == null) {
            return;
        }
        EditorComponentImpl editorComponent = editorComponentImpl;
        VirtualFile editorFile = FileDocumentManager.getInstance().getFile((Document)editorComponent.getEditor().getDocument());
        if (!CollectionsKt.contains((Iterable)modifiedFiles, (Object)editorFile)) {
            return;
        }
        String string3 = CommonBundle.message((String)"action.text.configure.ellipsis", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        gotItTooltip.withLink(string3, () -> WebServerPageConnectionService.showGotItTooltip$lambda$0(editorComponent));
        gotItTooltip.show((JComponent)editorComponent, WebServerPageConnectionService::showGotItTooltip$lambda$1);
    }

    private static final Unit showGotItTooltip$lambda$0(EditorComponentImpl $editorComponent) {
        ShowSettingsUtil.getInstance().showSettingsDialog($editorComponent.getEditor().getProject(), arg_0 -> WebServerPageConnectionService.showGotItTooltip$lambda$0$1(WebServerPageConnectionService::showGotItTooltip$lambda$0$0, arg_0), null);
        return Unit.INSTANCE;
    }

    private static final boolean showGotItTooltip$lambda$0$0(Configurable it) {
        ConfigurableWrapper configurableWrapper = it instanceof ConfigurableWrapper ? (ConfigurableWrapper)it : null;
        return Intrinsics.areEqual((Object)(configurableWrapper != null ? configurableWrapper.getId() : null), (Object)"reference.settings.ide.settings.web.browsers");
    }

    private static final boolean showGotItTooltip$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Point showGotItTooltip$lambda$1(Component component, Balloon balloon) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"<unused var>");
        EditorComponentImpl editorComponentImpl = component instanceof EditorComponentImpl ? (EditorComponentImpl)component : null;
        if (editorComponentImpl == null || (editorComponentImpl = editorComponentImpl.getEditor()) == null) {
            return new Point(0, 0);
        }
        EditorComponentImpl editor = editorComponentImpl;
        Point point = editor.visualPositionToXY(editor.getCaretModel().getCurrentCaret().getVisualPosition());
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"visualPositionToXY(...)");
        Point p = point;
        Rectangle v = ((EditorComponentImpl)component).getVisibleRect();
        return new Point(RangesKt.coerceIn((int)p.x, (int)v.x, (int)(v.x + v.width)), RangesKt.coerceIn((int)p.y, (int)v.y, (int)(v.y + v.height)));
    }

    public static final /* synthetic */ void access$showGotItTooltip(WebServerPageConnectionService $this, List modifiedFiles) {
        $this.showGotItTooltip(modifiedFiles);
    }

    public static final /* synthetic */ RequestedPagesState access$getMyState$p(WebServerPageConnectionService $this) {
        return $this.myState;
    }

    public static final /* synthetic */ ClientManager access$getMyServer$p(WebServerPageConnectionService $this) {
        return $this.myServer;
    }

    public static final /* synthetic */ ByteBuf access$getRELOAD_PAGE_MESSAGE$p(WebServerPageConnectionService $this) {
        return $this.RELOAD_PAGE_MESSAGE;
    }

    static {
        Logger logger = Logger.getInstance(WebServerPageConnectionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$Companion;", "", "<init>", "()V", "RELOAD_URL_PARAM", "", "SERVER_RELOAD_TOOLTIP_ID", "RELOAD_WS_REQUEST", "UPDATE_LINK_WS_REQUEST_PREFIX", "RELOAD_WS_URL_PREFIX", "RELOAD_MODE_URL_PARAMETER", "REFERRER_URL_PARAMETER", "UPDATE_LINKS_ID_URL_PARAMETER", "instance", "Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService;", "getInstance", "()Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService;", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.builtInServer.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WebServerPageConnectionService getInstance() {
            Object object = ApplicationManager.getApplication().getService(WebServerPageConnectionService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (WebServerPageConnectionService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001:\u000256B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u001e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0006H\u0002J\u001e\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010%\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#J\b\u0010&\u001a\u00020\u0013H\u0002J\u0016\u0010'\u001a\u00020\u001f2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060)J*\u0010*\u001a\u0018\u0012\b\u0012\u00060\nR\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060)0+2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060)J\u0006\u0010,\u001a\u00020\u0011J\u001c\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u00112\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00060)J\u000e\u00100\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u0011J\u0012\u00103\u001a\u00020\u00132\n\u00104\u001a\u00060\nR\u00020\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\nR\u00020\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u00067"}, d2={"Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$RequestedPagesState;", "", "<init>", "()V", "myRequestedFilesWithoutReferrer", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "myRequestedPages", "", "", "Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$RequestedPagesState$RequestedPage;", "myFileListenerDisposable", "Lcom/intellij/openapi/Disposable;", "myDocumentListenerDisposable", "myMessageId", "Ljava/util/concurrent/atomic/AtomicInteger;", "myLinkedFilesToReload", "", "clear", "", "resourceRequested", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "file", "extractRequestedPagePath", "referer", "pageRequested", "path", "reloadMode", "Lcom/intellij/ide/browsers/ReloadMode;", "isTrackedFile", "", "virtualFile", "clientConnected", "client", "Lorg/jetbrains/io/webSocket/WebSocketClient;", "referrer", "clientDisconnected", "cleanupIfEmpty", "isRequestedFileWithoutReferrerModified", "files", "", "collectAffectedPages", "", "getNextMessageId", "linkedFilesRequested", "messageId", "affectedFiles", "isAllLinkedFilesReloaded", "isEmpty", "()Z", "removeRequestedPageIfEmpty", "requestedPage", "RequestedPage", "RequestedPageClient", "intellij.platform.builtInServer.impl"})
    @SourceDebugExtension(value={"SMAP\nWebServerPageConnectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebServerPageConnectionService.kt\norg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$RequestedPagesState\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,502:1\n382#2,7:503\n1761#3,2:510\n1761#3,3:512\n1763#3:515\n*S KotlinDebug\n*F\n+ 1 WebServerPageConnectionService.kt\norg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$RequestedPagesState\n*L\n345#1:503,7\n352#1:510,2\n353#1:512,3\n352#1:515\n*E\n"})
    private static final class RequestedPagesState {
        @NotNull
        private final Set<VirtualFile> myRequestedFilesWithoutReferrer = new HashSet();
        @NotNull
        private final Map<String, RequestedPage> myRequestedPages = new HashMap();
        @Nullable
        private Disposable myFileListenerDisposable;
        @Nullable
        private Disposable myDocumentListenerDisposable;
        @NotNull
        private final AtomicInteger myMessageId = new AtomicInteger(0);
        @NotNull
        private final Map<Integer, Set<VirtualFile>> myLinkedFilesToReload = new HashMap();

        public final synchronized void clear() {
            LOGGER.debug("Requested pages cleared");
            for (RequestedPage requestedPage : this.myRequestedPages.values()) {
                requestedPage.clear();
            }
            this.myRequestedPages.clear();
            this.cleanupIfEmpty();
        }

        public final synchronized void resourceRequested(@NotNull FullHttpRequest request, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String referer = request.headers().get("Referer");
            boolean associatedPageFound = false;
            try {
                Intrinsics.checkNotNull((Object)referer);
                String path = this.extractRequestedPagePath(referer);
                RequestedPage page = this.myRequestedPages.get(path);
                Object object = page;
                if (object != null && (object = ((RequestedPage)object).getAssociatedFiles()) != null) {
                    object.add(file);
                }
                associatedPageFound = page != null;
                List messageIds = (List)new QueryStringDecoder(request.uri()).parameters().get(WebServerPageConnectionService.UPDATE_LINKS_ID_URL_PARAMETER);
                if (messageIds != null && messageIds.size() == 1) {
                    Object e = messageIds.get(0);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    Set<VirtualFile> set = this.myLinkedFilesToReload.get(Integer.parseInt((String)e));
                    if (set != null) {
                        set.remove(file);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!associatedPageFound) {
                this.myRequestedFilesWithoutReferrer.add(file);
            }
        }

        private final String extractRequestedPagePath(String referer) {
            String string = URI.create(referer).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        public final synchronized void pageRequested(@NotNull String path, @NotNull VirtualFile file, @NotNull ReloadMode reloadMode) {
            Object object;
            void $this$getOrPut$iv;
            Disposable disposable;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)reloadMode, (String)WebServerPageConnectionService.RELOAD_MODE_URL_PARAMETER);
            LOGGER.assertTrue(this.myRequestedPages.isEmpty() == (this.myFileListenerDisposable == null), (Object)("isEmpty: " + this.myRequestedPages.isEmpty() + ", disposable is null: " + (this.myFileListenerDisposable == null)));
            if (this.myFileListenerDisposable == null) {
                Disposable disposable2 = Disposer.newDisposable((Disposable)((Disposable)ApplicationManager.getApplication()), (String)"RequestedPagesState.myFileListenerDisposable");
                Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
                disposable = disposable2;
                VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new WebServerFileContentListener(), disposable);
                this.myFileListenerDisposable = disposable;
            }
            if (reloadMode == ReloadMode.RELOAD_ON_CHANGE && this.myDocumentListenerDisposable == null) {
                Disposable disposable3 = Disposer.newDisposable((Disposable)((Disposable)ApplicationManager.getApplication()), (String)"RequestedPagesState.myDocumentListenerDisposable");
                Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"newDisposable(...)");
                disposable = disposable3;
                EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(this){
                    final /* synthetic */ RequestedPagesState this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void documentChanged(DocumentEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(event.getDocument());
                        if (RequestedPagesState.access$isTrackedFile(this.this$0, virtualFile)) {
                            FileDocumentManager.getInstance().saveDocument(event.getDocument());
                        }
                    }
                }, disposable);
                this.myDocumentListenerDisposable = disposable;
            }
            LOGGER.debug("Page is requested for " + path);
            Map<String, RequestedPage> map = this.myRequestedPages;
            String key$iv = path;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                RequestedPage answer$iv = new RequestedPage(path);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            RequestedPage page = (RequestedPage)object;
            page.getAssociatedFiles().add(file);
            page.scheduleCleanup();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isTrackedFile(VirtualFile virtualFile) {
            boolean bl;
            if (this.myRequestedFilesWithoutReferrer.contains(virtualFile)) return true;
            Iterable $this$any$iv = this.myRequestedPages.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                RequestedPage it = (RequestedPage)element$iv;
                boolean bl2 = false;
                if (CollectionsKt.contains((Iterable)it.getAssociatedFiles(), (Object)virtualFile)) {
                    boolean bl3;
                    Iterable $this$any$iv2 = it.getClients();
                    boolean $i$f$any2 = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv2) {
                            RequestedPageClient c = (RequestedPageClient)element$iv2;
                            boolean bl4 = false;
                            if (c.getReloadMode() == ReloadMode.RELOAD_ON_CHANGE) {
                                return true;
                            }
                            boolean bl5 = false;
                            if (!bl5) continue;
                            return true;
                        }
                        bl3 = false;
                    }
                    if (bl3) {
                        return true;
                    }
                }
                bl = false;
            } while (!bl);
            return true;
        }

        public final synchronized void clientConnected(@NotNull WebSocketClient client, @NotNull String referrer, @NotNull ReloadMode reloadMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            Intrinsics.checkNotNullParameter((Object)referrer, (String)WebServerPageConnectionService.REFERRER_URL_PARAMETER);
            Intrinsics.checkNotNullParameter((Object)reloadMode, (String)WebServerPageConnectionService.RELOAD_MODE_URL_PARAMETER);
            LOGGER.debug("WebSocket client connected for " + referrer);
            RequestedPage requestedPage = this.myRequestedPages.get(this.extractRequestedPagePath(referrer));
            if (requestedPage == null) {
                LOGGER.warn("referrer not found");
                return;
            }
            requestedPage.clientConnected(client, reloadMode);
        }

        public final synchronized void clientDisconnected(@NotNull WebSocketClient client) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
                RequestedPage requestedPage = null;
                for (RequestedPage page : this.myRequestedPages.values()) {
                    if (!page.getClients().removeIf(arg_0 -> RequestedPagesState.clientDisconnected$lambda$1(arg_0 -> RequestedPagesState.clientDisconnected$lambda$0(client, arg_0), arg_0))) continue;
                    requestedPage = page;
                    break;
                }
                LOGGER.debug("WebSocket client disconnected for " + requestedPage);
                RequestedPage requestedPage2 = requestedPage;
                if (requestedPage2 == null) break block1;
                requestedPage2.scheduleCleanup();
            }
        }

        private final void cleanupIfEmpty() {
            if (this.myRequestedPages.isEmpty()) {
                this.myRequestedFilesWithoutReferrer.clear();
                if (this.myFileListenerDisposable != null) {
                    Disposable disposable = Objects.requireNonNull(this.myFileListenerDisposable);
                    Intrinsics.checkNotNull((Object)disposable);
                    Disposer.dispose((Disposable)disposable);
                    this.myFileListenerDisposable = null;
                }
                if (this.myDocumentListenerDisposable != null) {
                    Disposable disposable = Objects.requireNonNull(this.myDocumentListenerDisposable);
                    Intrinsics.checkNotNull((Object)disposable);
                    Disposer.dispose((Disposable)disposable);
                    this.myDocumentListenerDisposable = null;
                }
            }
        }

        public final synchronized boolean isRequestedFileWithoutReferrerModified(@NotNull List<? extends VirtualFile> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            for (VirtualFile virtualFile : files) {
                if (!this.myRequestedFilesWithoutReferrer.contains(virtualFile)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public final synchronized Map<RequestedPage, List<VirtualFile>> collectAffectedPages(@NotNull List<? extends VirtualFile> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            HashMap result = new HashMap();
            for (VirtualFile virtualFile : files) {
                for (RequestedPage requestedPage : this.myRequestedPages.values()) {
                    if (!requestedPage.getAssociatedFiles().contains(virtualFile)) continue;
                    if (StringUtil.equalsIgnoreCase((CharSequence)virtualFile.getExtension(), (CharSequence)"css")) {
                        if (!result.containsKey(requestedPage)) {
                            Map map = result;
                            Object object = new VirtualFile[]{virtualFile};
                            object = CollectionsKt.mutableListOf((Object[])object);
                            map.put(requestedPage, object);
                            continue;
                        }
                        Object v = result.get(requestedPage);
                        Intrinsics.checkNotNull(v);
                        if (!(!((Collection)v).isEmpty())) continue;
                        Object v2 = result.get(requestedPage);
                        Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.openapi.vfs.VirtualFile>");
                        TypeIntrinsics.asMutableList(v2).add(virtualFile);
                        continue;
                    }
                    ((Map)result).put(requestedPage, CollectionsKt.emptyList());
                }
            }
            return result;
        }

        public final int getNextMessageId() {
            return this.myMessageId.incrementAndGet();
        }

        public final synchronized void linkedFilesRequested(int messageId, @NotNull List<? extends VirtualFile> affectedFiles) {
            Intrinsics.checkNotNullParameter(affectedFiles, (String)"affectedFiles");
            this.myLinkedFilesToReload.put(messageId, new HashSet(affectedFiles));
        }

        public final synchronized boolean isAllLinkedFilesReloaded(int messageId) {
            Set<VirtualFile> set = this.myLinkedFilesToReload.get(messageId);
            boolean isEmpty = set != null ? set.isEmpty() : true;
            this.myLinkedFilesToReload.remove(messageId);
            return isEmpty;
        }

        public final synchronized boolean isEmpty() {
            return this.myRequestedPages.isEmpty();
        }

        public final synchronized void removeRequestedPageIfEmpty(@NotNull RequestedPage requestedPage) {
            Intrinsics.checkNotNullParameter((Object)requestedPage, (String)"requestedPage");
            LOGGER.assertTrue(Intrinsics.areEqual((Object)this.myRequestedPages.get(requestedPage.getUrl()), (Object)requestedPage));
            if (requestedPage.getClients().isEmpty()) {
                requestedPage.clear();
                this.myRequestedPages.remove(requestedPage.getUrl());
                this.cleanupIfEmpty();
            }
        }

        private static final boolean clientDisconnected$lambda$0(WebSocketClient $client, RequestedPageClient it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)((Object)it.getWebSocket()), (Object)((Object)$client));
        }

        private static final boolean clientDisconnected$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ boolean access$isTrackedFile(RequestedPagesState $this, VirtualFile virtualFile) {
            return $this.isTrackedFile(virtualFile);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u0016\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$RequestedPagesState$RequestedPage;", "", "url", "", "<init>", "(Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$RequestedPagesState;Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "clients", "", "Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$RequestedPagesState$RequestedPageClient;", "getClients", "()Ljava/util/Collection;", "associatedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAssociatedFiles", "()Ljava/util/Set;", "waitForClient", "Lcom/intellij/util/SingleAlarm;", "getWaitForClient", "()Lcom/intellij/util/SingleAlarm;", "setWaitForClient", "(Lcom/intellij/util/SingleAlarm;)V", "clear", "", "scheduleCleanup", "clientConnected", "client", "Lorg/jetbrains/io/webSocket/WebSocketClient;", "reloadMode", "Lcom/intellij/ide/browsers/ReloadMode;", "toString", "intellij.platform.builtInServer.impl"})
        public final class RequestedPage {
            @NotNull
            private final String url;
            @NotNull
            private final Collection<RequestedPageClient> clients;
            @NotNull
            private final Set<VirtualFile> associatedFiles;
            @NotNull
            private SingleAlarm waitForClient;

            public RequestedPage(String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                this.url = url;
                this.clients = new ArrayList();
                this.associatedFiles = new HashSet();
                this.waitForClient = new SingleAlarm(() -> RequestedPage.waitForClient$lambda$0(RequestedPagesState.this, this), (int)TimeUnit.SECONDS.toMillis(30L));
            }

            @NotNull
            public final String getUrl() {
                return this.url;
            }

            @NotNull
            public final Collection<RequestedPageClient> getClients() {
                return this.clients;
            }

            @NotNull
            public final Set<VirtualFile> getAssociatedFiles() {
                return this.associatedFiles;
            }

            @NotNull
            public final SingleAlarm getWaitForClient() {
                return this.waitForClient;
            }

            public final void setWaitForClient(@NotNull SingleAlarm singleAlarm) {
                Intrinsics.checkNotNullParameter((Object)singleAlarm, (String)"<set-?>");
                this.waitForClient = singleAlarm;
            }

            public final void clear() {
                Disposer.dispose((Disposable)((Disposable)this.waitForClient));
            }

            public final void scheduleCleanup() {
                SingleAlarm.cancelAndRequest$default((SingleAlarm)this.waitForClient, (boolean)false, (int)1, null);
            }

            public final void clientConnected(@NotNull WebSocketClient client, @NotNull ReloadMode reloadMode) {
                Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
                Intrinsics.checkNotNullParameter((Object)reloadMode, (String)WebServerPageConnectionService.RELOAD_MODE_URL_PARAMETER);
                this.clients.add(new RequestedPageClient(client, reloadMode));
                this.waitForClient.cancel();
            }

            @NotNull
            public String toString() {
                return "page (url=..." + StringsKt.takeLast((String)this.url, (int)10) + ", " + this.clients.size() + " client(s)}";
            }

            private static final void waitForClient$lambda$0(RequestedPagesState this$0, RequestedPage this$1) {
                this$0.removeRequestedPageIfEmpty(this$1);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$RequestedPagesState$RequestedPageClient;", "", "webSocket", "Lorg/jetbrains/io/webSocket/WebSocketClient;", "reloadMode", "Lcom/intellij/ide/browsers/ReloadMode;", "<init>", "(Lorg/jetbrains/io/webSocket/WebSocketClient;Lcom/intellij/ide/browsers/ReloadMode;)V", "getWebSocket", "()Lorg/jetbrains/io/webSocket/WebSocketClient;", "getReloadMode", "()Lcom/intellij/ide/browsers/ReloadMode;", "intellij.platform.builtInServer.impl"})
        public static final class RequestedPageClient {
            @NotNull
            private final WebSocketClient webSocket;
            @NotNull
            private final ReloadMode reloadMode;

            public RequestedPageClient(@NotNull WebSocketClient webSocket, @NotNull ReloadMode reloadMode) {
                Intrinsics.checkNotNullParameter((Object)((Object)webSocket), (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)reloadMode, (String)WebServerPageConnectionService.RELOAD_MODE_URL_PARAMETER);
                this.webSocket = webSocket;
                this.reloadMode = reloadMode;
            }

            @NotNull
            public final WebSocketClient getWebSocket() {
                return this.webSocket;
            }

            @NotNull
            public final ReloadMode getReloadMode() {
                return this.reloadMode;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0014J,\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u001a\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0014\u0018\u00010\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/builtInWebServer/liveReload/WebServerPageConnectionService$WebServerPageRequestHandler;", "Lorg/jetbrains/io/webSocket/WebSocketHandshakeHandler;", "<init>", "()V", "serverCreated", "", "server", "Lorg/jetbrains/io/jsonRpc/ClientManager;", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "getMessageServer", "Lorg/jetbrains/io/jsonRpc/MessageServer;", "connected", "client", "Lorg/jetbrains/io/jsonRpc/Client;", "parameters", "", "", "", "disconnected", "intellij.platform.builtInServer.impl"})
    public static final class WebServerPageRequestHandler
    extends WebSocketHandshakeHandler {
        @Override
        protected void serverCreated(@NotNull ClientManager server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            WebServerPageConnectionService instance = Companion.getInstance();
            instance.myServer = server;
            instance.myRpcServer = new JsonRpcServer(server);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isSupported(@NotNull FullHttpRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            if (!super.isSupported(request)) return false;
            String string = request.uri();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
            if (!HttpRequestHandler.Companion.checkPrefix(string, WebServerPageConnectionService.RELOAD_WS_URL_PREFIX)) return false;
            return true;
        }

        @Override
        @NotNull
        protected MessageServer getMessageServer() {
            JsonRpcServer jsonRpcServer = Companion.getInstance().myRpcServer;
            Intrinsics.checkNotNull((Object)jsonRpcServer);
            return jsonRpcServer;
        }

        public void connected(@NotNull Client client, @Nullable Map<String, ? extends List<String>> parameters) {
            ReloadMode reloadMode;
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            if (parameters == null || !(client instanceof WebSocketClient)) {
                return;
            }
            List<String> list = parameters.get(WebServerPageConnectionService.RELOAD_MODE_URL_PARAMETER);
            if (list == null) {
                return;
            }
            List<String> reloadModeParam = list;
            if (reloadModeParam.size() != 1) {
                return;
            }
            try {
                reloadMode = ReloadMode.valueOf((String)reloadModeParam.get(0));
            }
            catch (Throwable throwable) {
                reloadMode = null;
            }
            ReloadMode reloadMode2 = reloadMode;
            if (reloadMode2 == null) {
                return;
            }
            ReloadMode reloadMode3 = reloadMode2;
            List<String> list2 = parameters.get(WebServerPageConnectionService.REFERRER_URL_PARAMETER);
            if (list2 == null) {
                return;
            }
            List<String> referrerParam = list2;
            if (referrerParam.size() != 1) {
                return;
            }
            String referrer = referrerParam.get(0);
            Companion.getInstance().clientConnected((WebSocketClient)client, referrer, reloadMode3);
        }

        @Override
        public void disconnected(@NotNull Client client) {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            if (client instanceof WebSocketClient) {
                Companion.getInstance().clientDisconnected((WebSocketClient)client);
            }
        }
    }
}

