/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.project.Project;
import java.util.ArrayDeque;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.Item;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/ide/SearchConfigurableByNameHelper;", "", "name", "", "rootGroup", "Lcom/intellij/openapi/options/ConfigurableGroup;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/options/ConfigurableGroup;)V", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "names", "", "stack", "Ljava/util/ArrayDeque;", "Lorg/jetbrains/ide/Item;", "searchByName", "Lcom/intellij/openapi/options/Configurable;", "processChildren", "parent", "isMatched", "", "child", "intellij.platform.builtInServer.impl"})
public final class SearchConfigurableByNameHelper {
    @NotNull
    private final ConfigurableGroup rootGroup;
    @NotNull
    private final List<String> names;
    @NotNull
    private final ArrayDeque<Item> stack;

    public SearchConfigurableByNameHelper(@NotNull String name, @NotNull ConfigurableGroup rootGroup) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rootGroup, (String)"rootGroup");
        this.rootGroup = rootGroup;
        String[] stringArray = new String[]{"--", "|"};
        this.names = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)name, (String[])stringArray, (boolean)false, (int)0, (int)6, null), SearchConfigurableByNameHelper::names$lambda$0));
        this.stack = new ArrayDeque();
    }

    public SearchConfigurableByNameHelper(@NotNull String name, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ConfigurableGroup configurableGroup = ConfigurableExtensionPointUtil.getConfigurableGroup((Project)project, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)configurableGroup, (String)"getConfigurableGroup(...)");
        this(name, configurableGroup);
    }

    @Nullable
    public final Configurable searchByName() {
        this.stack.add(new Item((Configurable.Composite)this.rootGroup, null));
        while (this.stack.pollFirst() != null) {
            Item item;
            Configurable result = this.processChildren(item);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private final Configurable processChildren(Item parent) {
        Configurable[] configurableArray = parent.getConfigurable().getConfigurables();
        Intrinsics.checkNotNullExpressionValue((Object)configurableArray, (String)"getConfigurables(...)");
        for (Configurable configurable : configurableArray) {
            Intrinsics.checkNotNull((Object)configurable);
            Configurable child = configurable;
            if (this.isMatched(child, parent)) {
                return child;
            }
            if (!(child instanceof Configurable.Composite)) continue;
            this.stack.add(new Item((Configurable.Composite)child, parent));
        }
        return null;
    }

    private final boolean isMatched(Configurable child, Item parent) {
        if (this.names.size() > 1 && parent.getParent() == null) {
            return false;
        }
        if (!StringsKt.equals((String)((String)CollectionsKt.last(this.names)), (String)child.getDisplayName(), (boolean)true)) {
            return false;
        }
        Item currentParent = parent;
        for (int i = this.names.size() - 2; -1 < i; --i) {
            Configurable.Composite composite = currentParent.getConfigurable();
            Intrinsics.checkNotNull((Object)composite, (String)"null cannot be cast to non-null type com.intellij.openapi.options.Configurable");
            String currentName = ((Configurable)composite).getDisplayName();
            if (!StringsKt.equals((String)this.names.get(i), (String)currentName, (boolean)true)) {
                return false;
            }
            if (currentParent.getParent() != null) continue;
            return false;
        }
        return true;
    }

    private static final String names$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }
}

