/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.net.NetKt;
import io.netty.bootstrap.ServerBootstrap;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.CustomPortServerManager;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.NettyUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/io/SubServer;", "Lorg/jetbrains/ide/CustomPortServerManager$CustomPortService;", "Lcom/intellij/openapi/Disposable;", "user", "Lorg/jetbrains/ide/CustomPortServerManager;", "server", "Lorg/jetbrains/io/BuiltInServer;", "<init>", "(Lorg/jetbrains/ide/CustomPortServerManager;Lorg/jetbrains/io/BuiltInServer;)V", "channelRegistrar", "Lorg/jetbrains/io/ChannelRegistrar;", "isBound", "", "()Z", "bind", "port", "", "stop", "", "rebind", "dispose", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nSubServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubServer.kt\norg/jetbrains/io/SubServer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,67:1\n13#2:68\n*S KotlinDebug\n*F\n+ 1 SubServer.kt\norg/jetbrains/io/SubServer\n*L\n39#1:68\n*E\n"})
public final class SubServer
implements CustomPortServerManager.CustomPortService,
Disposable {
    @NotNull
    private final CustomPortServerManager user;
    @NotNull
    private final BuiltInServer server;
    @Nullable
    private ChannelRegistrar channelRegistrar;

    public SubServer(@NotNull CustomPortServerManager user, @NotNull BuiltInServer server) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.user = user;
        this.server = server;
        this.user.setManager((CustomPortServerManager.CustomPortService)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBound() {
        if (this.channelRegistrar == null) return false;
        ChannelRegistrar channelRegistrar = this.channelRegistrar;
        Intrinsics.checkNotNull((Object)channelRegistrar);
        if (channelRegistrar.isEmpty()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean bind(int port) {
        if (port == this.server.getPort() || port == -1) {
            return true;
        }
        if (this.channelRegistrar == null) {
            Disposer.register((Disposable)this.server, (Disposable)this);
            this.channelRegistrar = new ChannelRegistrar();
        }
        ServerBootstrap bootstrap = this.server.createServerBootstrap();
        ChannelRegistrar channelRegistrar = this.channelRegistrar;
        Intrinsics.checkNotNull((Object)channelRegistrar);
        BuiltInServer.Companion.configureChildHandler(bootstrap, channelRegistrar, null);
        try {
            bootstrap.localAddress((SocketAddress)(this.user.isAvailableExternally() ? new InetSocketAddress(port) : NetKt.loopbackSocketAddress((int)port)));
            ChannelRegistrar channelRegistrar2 = this.channelRegistrar;
            Intrinsics.checkNotNull((Object)channelRegistrar2);
            channelRegistrar2.setServerChannel(bootstrap.bind().syncUninterruptibly().channel(), false);
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SubServer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            String string = this.user.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            logger.info("Built-in sub-server '" + StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null) + "' started on port " + port);
            return true;
        }
        catch (Exception e) {
            try {
                NettyUtil.log((Throwable)e, (Logger)Logger.getInstance(BuiltInServer.class));
            }
            finally {
                this.user.cannotBind(e, port);
            }
            return false;
        }
    }

    private final void stop() {
        block0: {
            ChannelRegistrar channelRegistrar = this.channelRegistrar;
            if (channelRegistrar == null) break block0;
            channelRegistrar.close();
        }
    }

    public boolean rebind() {
        this.stop();
        return this.bind(this.user.getPort());
    }

    public void dispose() {
        this.stop();
        this.user.setManager(null);
    }
}

