/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SimpleTimerTask;
import com.intellij.util.containers.CollectionFactory;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.ExceptionHandler;
import org.jetbrains.io.webSocket.WebSocketServerOptions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u0015H\u0016J@\u0010\u001e\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u001f2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\"\b\u0002\u0010#\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\u001f0&0%\u0018\u00010$J\u001e\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u001cJ\u0016\u0010+\u001a\u00020\u00152\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110-H\u0002J\u0018\u0010.\u001a\u0004\u0018\u00010\u00112\u000e\u0010/\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001100R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u000f\u001a.\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0015\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0013\u00a2\u0006\u0002\b\u000e0\u0010\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00061"}, d2={"Lorg/jetbrains/io/jsonRpc/ClientManager;", "Lcom/intellij/openapi/Disposable;", "listener", "Lorg/jetbrains/io/jsonRpc/ClientListener;", "exceptionHandler", "Lorg/jetbrains/io/jsonRpc/ExceptionHandler;", "options", "Lorg/jetbrains/io/webSocket/WebSocketServerOptions;", "<init>", "(Lorg/jetbrains/io/jsonRpc/ClientListener;Lorg/jetbrains/io/jsonRpc/ExceptionHandler;Lorg/jetbrains/io/webSocket/WebSocketServerOptions;)V", "getExceptionHandler", "()Lorg/jetbrains/io/jsonRpc/ExceptionHandler;", "heartbeatTimer", "Lcom/intellij/openapi/util/SimpleTimerTask;", "Lorg/jetbrains/annotations/NotNull;", "clients", "", "Lorg/jetbrains/io/jsonRpc/Client;", "kotlin.jvm.PlatformType", "", "addClient", "", "client", "clientCount", "", "getClientCount", "()I", "hasClients", "", "dispose", "send", "T", "messageId", "message", "Lio/netty/buffer/ByteBuf;", "results", "", "Lorg/jetbrains/concurrency/Promise;", "Lkotlin/Pair;", "disconnectClient", "channel", "Lio/netty/channel/Channel;", "closeChannel", "forEachClient", "procedure", "Ljava/util/function/Consumer;", "findClient", "predicate", "Ljava/util/function/Predicate;", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nClientManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientManager.kt\norg/jetbrains/io/jsonRpc/ClientManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1#2:105\n295#3,2:106\n*S KotlinDebug\n*F\n+ 1 ClientManager.kt\norg/jetbrains/io/jsonRpc/ClientManager\n*L\n101#1:106,2\n*E\n"})
public final class ClientManager
implements Disposable {
    @Nullable
    private final ClientListener listener;
    @NotNull
    private final ExceptionHandler exceptionHandler;
    @NotNull
    private final SimpleTimerTask heartbeatTimer;
    @NotNull
    private final Set<Client> clients;

    public ClientManager(@Nullable ClientListener listener, @NotNull ExceptionHandler exceptionHandler, @Nullable WebSocketServerOptions options) {
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
        this.listener = listener;
        this.exceptionHandler = exceptionHandler;
        SimpleTimer simpleTimer = SimpleTimer.getInstance();
        Runnable runnable = () -> ClientManager.heartbeatTimer$lambda$0(this);
        WebSocketServerOptions webSocketServerOptions = options;
        if (webSocketServerOptions == null) {
            webSocketServerOptions = new WebSocketServerOptions();
        }
        SimpleTimerTask simpleTimerTask = simpleTimer.setUp(runnable, (long)webSocketServerOptions.heartbeatDelay);
        Intrinsics.checkNotNullExpressionValue((Object)simpleTimerTask, (String)"setUp(...)");
        this.heartbeatTimer = simpleTimerTask;
        Set set = CollectionFactory.createSmallMemoryFootprintSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createSmallMemoryFootprintSet(...)");
        this.clients = set;
    }

    public /* synthetic */ ClientManager(ClientListener clientListener, ExceptionHandler exceptionHandler, WebSocketServerOptions webSocketServerOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            webSocketServerOptions = null;
        }
        this(clientListener, exceptionHandler, webSocketServerOptions);
    }

    @NotNull
    public final ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addClient(@NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Set<Client> set = this.clients;
        synchronized (set) {
            boolean bl = false;
            boolean bl2 = this.clients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getClientCount() {
        int n;
        Set<Client> set = this.clients;
        synchronized (set) {
            boolean bl = false;
            n = this.clients.size();
        }
        return n;
    }

    public final boolean hasClients() {
        return this.getClientCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.heartbeatTimer.cancel();
        }
        finally {
            Set<Client> set = this.clients;
            synchronized (set) {
                boolean bl = false;
                this.clients.clear();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final <T> void send(int messageId, @NotNull ByteBuf message, @Nullable List<Promise<Pair<Client, T>>> results) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        message.retain();
        this.forEachClient(new Consumer<Client>(messageId, message, results, this){
            private boolean first;
            final /* synthetic */ int $messageId;
            final /* synthetic */ ByteBuf $message;
            final /* synthetic */ List<Promise<Pair<Client, T>>> $results;
            final /* synthetic */ ClientManager this$0;
            {
                this.$messageId = $messageId;
                this.$message = $message;
                this.$results = $results;
                this.this$0 = $receiver;
                this.first = true;
            }

            public void accept(Client client) {
                Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
                try {
                    Promise<T> result = client.send(this.$messageId, this.first ? this.$message : this.$message.retainedDuplicate());
                    this.first = false;
                    List<Promise<Pair<Client, T>>> list = this.$results;
                    if (list != null) {
                        Promise<T> promise = result;
                        Intrinsics.checkNotNull(promise);
                        list.add(promise);
                    }
                }
                catch (Throwable e) {
                    this.this$0.getExceptionHandler().exceptionCaught(e);
                }
            }
        });
        message.release();
    }

    public static /* synthetic */ void send$default(ClientManager clientManager, int n, ByteBuf byteBuf, List list, int n2, Object object) {
        if ((n2 & 4) != 0) {
            list = null;
        }
        clientManager.send(n, byteBuf, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean disconnectClient(@NotNull Channel channel, @NotNull Client client, boolean closeChannel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Set<Client> set = this.clients;
        synchronized (set) {
            block9: {
                boolean bl = false;
                if (this.clients.remove((Object)client)) break block9;
                boolean bl2 = false;
                return bl2;
            }
            Unit unit = Unit.INSTANCE;
        }
        try {
            channel.attr(ClientManagerKt.getCLIENT()).set(null);
            if (closeChannel) {
                channel.close();
            }
            client.rejectAsyncResults(this.exceptionHandler);
        }
        finally {
            ClientListener clientListener = this.listener;
            if (clientListener != null) {
                clientListener.disconnected(client);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forEachClient(Consumer<Client> procedure) {
        Set<Client> set = this.clients;
        synchronized (set) {
            boolean bl = false;
            for (Client client : this.clients) {
                procedure.accept(client);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Client findClient(@NotNull Predicate<? super Client> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Set<Client> set = this.clients;
        synchronized (set) {
            Object v0;
            block4: {
                boolean bl = false;
                Iterable $this$firstOrNull$iv = this.clients;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Client it = (Client)((Object)element$iv);
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)((Object)it));
                    if (!predicate.test(it)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            Client client = v0;
            return client;
        }
    }

    private static final void heartbeatTimer$lambda$0(ClientManager this$0) {
        this$0.forEachClient(ClientManager::heartbeatTimer$lambda$0$0);
    }

    private static final void heartbeatTimer$lambda$0$0(Client it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        if (it.channel.isActive()) {
            it.sendHeartbeat();
        }
    }
}

