/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebBrowserUrlProviderKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/builtInWebServer/BuiltInWebBrowserUrlProvider;", "Lcom/intellij/ide/browsers/WebBrowserUrlProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "canHandleElement", "", "request", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "isFileOfMyLanguage", "psiFile", "Lcom/intellij/psi/PsiFile;", "getUrl", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.builtInServer.impl"})
public class BuiltInWebBrowserUrlProvider
extends WebBrowserUrlProvider
implements DumbAware {
    public boolean canHandleElement(@NotNull OpenInBrowserRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.getVirtualFile() instanceof HttpVirtualFile) {
            return true;
        }
        return request.isPhysicalFile() && this.isFileOfMyLanguage(request.getFile());
    }

    protected boolean isFileOfMyLanguage(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return WebBrowserXmlService.Companion.getInstance().isHtmlOrXmlFile(psiFile);
    }

    @Nullable
    protected Url getUrl(@NotNull OpenInBrowserRequest request, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof HttpVirtualFile ? Urls.newFromVirtualFile((VirtualFile)file) : (Url)CollectionsKt.firstOrNull(BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls(file, request.getProject(), null, request.isAppendAccessToken(), request.getReloadMode()));
    }
}

