/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.util.Consumer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.CharsetUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.Decoder;
import org.jetbrains.io.fastCgi.FastCgiService;
import org.jetbrains.io.fastCgi.FastCgiServiceKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0014J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiDecoder;", "Lorg/jetbrains/io/Decoder;", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "responseHandler", "Lorg/jetbrains/io/fastCgi/FastCgiService;", "<init>", "(Lcom/intellij/util/Consumer;Lorg/jetbrains/io/fastCgi/FastCgiService;)V", "type", "", "id", "contentLength", "paddingLength", "dataBuffers", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lio/netty/buffer/ByteBuf;", "messageReceived", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "input", "channelInactive", "contentReceived", "buffer", "contentInBufferLength", "ProtocolStatus", "RecordType", "intellij.platform.builtInServer.impl"})
public final class FastCgiDecoder
extends Decoder {
    @NotNull
    private final Consumer<String> errorOutputConsumer;
    @NotNull
    private final FastCgiService responseHandler;
    private int type;
    private int id;
    private int contentLength;
    private int paddingLength;
    @NotNull
    private final Int2ObjectOpenHashMap<ByteBuf> dataBuffers;

    public FastCgiDecoder(@NotNull Consumer<String> errorOutputConsumer, @NotNull FastCgiService responseHandler) {
        Intrinsics.checkNotNullParameter(errorOutputConsumer, (String)"errorOutputConsumer");
        Intrinsics.checkNotNullParameter((Object)responseHandler, (String)"responseHandler");
        this.errorOutputConsumer = errorOutputConsumer;
        this.responseHandler = responseHandler;
        this.dataBuffers = new Int2ObjectOpenHashMap();
    }

    protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        while (input.readableBytes() > 0) {
            int toRead;
            if (this.contentLength > 0) {
                toRead = Math.min(this.contentLength, input.readableBytes());
                int readFromInput = this.contentReceived(input, toRead, context);
                input.skipBytes(toRead - readFromInput);
                this.contentLength -= toRead;
                continue;
            }
            if (this.paddingLength > 0) {
                toRead = Math.min(this.paddingLength, input.readableBytes());
                input.skipBytes(toRead);
                this.paddingLength -= toRead;
                continue;
            }
            input.skipBytes(1);
            this.type = input.readUnsignedByte();
            this.id = input.readUnsignedShort();
            this.contentLength = input.readUnsignedShort();
            this.paddingLength = input.readUnsignedByte();
            input.skipBytes(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(@NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            if (!this.dataBuffers.isEmpty()) {
                ObjectIterator objectIterator = ((ObjectCollection)this.dataBuffers.values()).iterator();
                Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
                ObjectIterator objectIterator2 = objectIterator;
                while (objectIterator2.hasNext()) {
                    ByteBuf buffer = (ByteBuf)objectIterator2.next();
                    try {
                        buffer.release();
                    }
                    catch (Throwable e) {
                        FastCgiServiceKt.getLOG().error(e);
                    }
                }
                this.dataBuffers.clear();
            }
        }
        finally {
            super.channelInactive(context);
        }
    }

    private final int contentReceived(ByteBuf buffer, int contentInBufferLength, ChannelHandlerContext context) {
        switch (this.type) {
            case 6: {
                ByteBuf data = (ByteBuf)this.dataBuffers.get(this.id);
                ByteBuf sliced = buffer.slice(buffer.readerIndex(), contentInBufferLength);
                ByteBuf byteBuf = data;
                if (byteBuf == null) {
                    v0 = (ByteBuf)this.dataBuffers.put(this.id, (Object)sliced);
                } else if (byteBuf instanceof CompositeByteBuf) {
                    ((CompositeByteBuf)data).addComponent(sliced);
                    v0 = (ByteBuf)((CompositeByteBuf)data).writerIndex(((CompositeByteBuf)data).writerIndex() + contentInBufferLength);
                } else {
                    CompositeByteBuf compositeByteBuf = context.alloc().compositeBuffer(1024);
                    compositeByteBuf.addComponent(data);
                    compositeByteBuf.addComponent(sliced);
                    compositeByteBuf.writerIndex(data.writerIndex() + contentInBufferLength);
                    v0 = (ByteBuf)this.dataBuffers.put(this.id, (Object)compositeByteBuf);
                }
                sliced.retain();
                return 0;
            }
            case 7: {
                try {
                    this.errorOutputConsumer.consume((Object)buffer.toString(buffer.readerIndex(), contentInBufferLength, CharsetUtil.UTF_8));
                }
                catch (Throwable e) {
                    FastCgiServiceKt.getLOG().error(e);
                }
                return 0;
            }
            case 3: {
                int appStatus = buffer.readInt();
                short protocolStatus = buffer.readUnsignedByte();
                if (appStatus != 0 || protocolStatus != 0) {
                    FastCgiServiceKt.getLOG().warn("Protocol status " + protocolStatus);
                    this.dataBuffers.remove(this.id);
                    this.responseHandler.responseReceived(this.id, null);
                } else {
                    boolean bl;
                    boolean bl2 = bl = protocolStatus == 0;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    this.responseHandler.responseReceived(this.id, (ByteBuf)this.dataBuffers.remove(this.id));
                }
                return 5;
            }
        }
        FastCgiServiceKt.getLOG().error("Unknown type " + this.type);
        return 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiDecoder$ProtocolStatus;", "", "<init>", "()V", "REQUEST_COMPLETE", "", "intellij.platform.builtInServer.impl"})
    private static final class ProtocolStatus {
        @NotNull
        public static final ProtocolStatus INSTANCE = new ProtocolStatus();
        public static final int REQUEST_COMPLETE = 0;

        private ProtocolStatus() {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiDecoder$RecordType;", "", "<init>", "()V", "END_REQUEST", "", "STDOUT", "STDERR", "intellij.platform.builtInServer.impl"})
    public static final class RecordType {
        @NotNull
        public static final RecordType INSTANCE = new RecordType();
        public static final int END_REQUEST = 3;
        public static final int STDOUT = 6;
        public static final int STDERR = 7;

        private RecordType() {
        }
    }
}

