/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FormattingDocumentModelImpl
implements FormattingDocumentModel {
    private final WhiteSpaceFormattingStrategy myWhiteSpaceStrategy;
    @NotNull
    private final Document myDocument;
    @NotNull
    private final PsiFile myPsiFile;
    private static final Logger LOG = Logger.getInstance(FormattingDocumentModelImpl.class);
    private final CodeStyleSettings mySettings;

    public FormattingDocumentModelImpl(@NotNull Document document, @NotNull PsiFile psiFile) {
        if (document == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(1);
        }
        this.myDocument = document;
        this.myPsiFile = psiFile;
        Language language = psiFile.getLanguage();
        this.myWhiteSpaceStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy(language);
        this.mySettings = CodeStyle.getSettings((PsiFile)psiFile);
    }

    public static FormattingDocumentModelImpl createOn(@NotNull PsiFile psiFile) {
        Document document;
        if (psiFile == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(2);
        }
        if ((document = FormattingDocumentModelImpl.getDocumentToBeUsedFor(psiFile)) != null) {
            FormattingDocumentModelImpl.checkDocument(psiFile, document);
            return new FormattingDocumentModelImpl(document, psiFile);
        }
        return new FormattingDocumentModelImpl((Document)new DocumentImpl(psiFile.getViewProvider().getContents(), true), psiFile);
    }

    private static void checkDocument(@NotNull PsiFile psiFile, @NotNull Document document) {
        if (psiFile == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(3);
        }
        if (document == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(4);
        }
        if (psiFile.getTextLength() != document.getTextLength()) {
            LOG.error(DebugUtil.diagnosePsiDocumentInconsistency((PsiElement)psiFile, (Document)document));
        }
    }

    @Nullable
    public static Document getDocumentToBeUsedFor(PsiFile psiFile) {
        Project project = psiFile.getProject();
        if (!psiFile.isPhysical()) {
            return FormattingDocumentModelImpl.getDocumentForNonPhysicalFile(psiFile);
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (document != null) {
            if (PsiDocumentManager.getInstance((Project)project).isUncommited(document)) {
                return null;
            }
            PsiToDocumentSynchronizer synchronizer = ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project)).getSynchronizer();
            if (synchronizer.isDocumentAffectedByTransactions(document)) {
                return null;
            }
        }
        return document;
    }

    @NotNull
    private static Document getDocumentForNonPhysicalFile(PsiFile psiFile) {
        Document document = psiFile.getViewProvider().getDocument();
        if (document != null && document.getTextLength() == psiFile.getTextLength()) {
            Document document2 = document;
            if (document2 == null) {
                FormattingDocumentModelImpl.$$$reportNull$$$0(5);
            }
            return document2;
        }
        return new DocumentImpl((CharSequence)psiFile.getText(), true);
    }

    public int getLineNumber(int offset) {
        if (offset > this.myDocument.getTextLength()) {
            LOG.error(String.format("Invalid offset detected (%d). Document length: %d. Target file: %s", offset, this.myDocument.getTextLength(), this.myPsiFile));
        }
        return this.myDocument.getLineNumber(offset);
    }

    public int getLineStartOffset(int line) {
        return this.myDocument.getLineStartOffset(line);
    }

    public CharSequence getText(TextRange textRange) {
        if (textRange.getStartOffset() < 0 || textRange.getEndOffset() > this.myDocument.getTextLength()) {
            LOG.error(String.format("Please submit a ticket to the tracker and attach current source file to it!%nInvalid processing detected: given text range (%s) targets non-existing regions (the boundaries are [0; %d)). File's language: %s", textRange, this.myDocument.getTextLength(), this.myPsiFile.getLanguage()));
        }
        return this.myDocument.getCharsSequence().subSequence(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public int getTextLength() {
        return this.myDocument.getTextLength();
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(6);
        }
        return document;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(7);
        }
        return psiFile;
    }

    public boolean containsWhiteSpaceSymbolsOnly(int startOffset, int endOffset) {
        Language injectedLanguage;
        Language startElementLanguage = this.getLanguageByOffset(startOffset);
        if (this.myWhiteSpaceStrategy.check(startElementLanguage, this.myDocument.getCharsSequence(), startOffset, endOffset) >= endOffset) {
            return true;
        }
        PsiElement injectedElement = InjectedLanguageUtilBase.findElementAtNoCommit((PsiFile)this.myPsiFile, (int)startOffset);
        if (injectedElement != null && !(injectedLanguage = injectedElement.getLanguage()).equals(this.myPsiFile.getLanguage())) {
            WhiteSpaceFormattingStrategy localStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy(injectedLanguage);
            String unescapedText = InjectedLanguageUtilBase.getUnescapedLeafText((PsiElement)injectedElement, (boolean)true);
            if (unescapedText != null) {
                return localStrategy.check(unescapedText, 0, unescapedText.length()) >= unescapedText.length();
            }
            return localStrategy.check(this.myDocument.getCharsSequence(), startOffset, endOffset) >= endOffset;
        }
        return false;
    }

    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, int startOffset, int endOffset, ASTNode nodeAfter, boolean changedViaPsi) {
        if (whiteSpaceText == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(8);
        }
        if (!changedViaPsi) {
            CharSequence charSequence = this.myWhiteSpaceStrategy.adjustWhiteSpaceIfNecessary(whiteSpaceText, this.myDocument.getCharsSequence(), startOffset, endOffset, this.mySettings, nodeAfter);
            if (charSequence == null) {
                FormattingDocumentModelImpl.$$$reportNull$$$0(9);
            }
            return charSequence;
        }
        PsiElement element = this.myPsiFile.findElementAt(startOffset);
        if (element == null) {
            CharSequence charSequence = whiteSpaceText;
            if (charSequence == null) {
                FormattingDocumentModelImpl.$$$reportNull$$$0(10);
            }
            return charSequence;
        }
        CharSequence charSequence = this.myWhiteSpaceStrategy.adjustWhiteSpaceIfNecessary(whiteSpaceText, element, startOffset, endOffset, this.mySettings);
        if (charSequence == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(11);
        }
        return charSequence;
    }

    public static boolean canUseDocumentModel(@NotNull Document document, @NotNull PsiFile psiFile) {
        PsiDocumentManager psiDocumentManager;
        if (document == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(12);
        }
        if (psiFile == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(13);
        }
        return !(psiDocumentManager = PsiDocumentManager.getInstance((Project)psiFile.getProject())).isUncommited(document) && !psiDocumentManager.isDocumentBlockedByPsi(document) && psiFile.getText().equals(document.getText());
    }

    private Language getLanguageByOffset(int offset) {
        PsiElement element;
        if (offset < this.myPsiFile.getTextLength() && (element = this.myPsiFile.findElementAt(offset)) != null) {
            return element.getLanguage();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/FormattingDocumentModelImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/FormattingDocumentModelImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentForNonPhysicalFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustWhiteSpaceIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createOn";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkDocument";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "adjustWhiteSpaceIfNecessary";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canUseDocumentModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

