/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.IndentRangesCalculator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/psi/formatter/common/NodeIndentRangesCalculator;", "", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "calculateExtraRanges", "", "Lcom/intellij/openapi/util/TextRange;", "retrieveDocument", "Lcom/intellij/openapi/editor/Document;", "intellij.platform.codeStyle.impl"})
public final class NodeIndentRangesCalculator {
    @NotNull
    private final ASTNode node;

    public NodeIndentRangesCalculator(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.node = node;
    }

    @NotNull
    public final List<TextRange> calculateExtraRanges() {
        Document document = this.retrieveDocument(this.node);
        if (document != null) {
            TextRange ranges = this.node.getTextRange();
            Intrinsics.checkNotNull((Object)ranges);
            return new IndentRangesCalculator(document, ranges).calcIndentRanges();
        }
        return CollectionsKt.listOf((Object)this.node.getTextRange());
    }

    private final Document retrieveDocument(ASTNode node) {
        PsiFile file = node.getPsi().getContainingFile();
        return PsiDocumentManager.getInstance((Project)node.getPsi().getProject()).getDocument(file);
    }
}

