/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CoreFormatterUtil {
    private static final Set<Character.UnicodeBlock> FULLWIDTH_BLOCKS = Set.of(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS, Character.UnicodeBlock.HIRAGANA, Character.UnicodeBlock.KATAKANA);

    private CoreFormatterUtil() {
    }

    @NotNull
    public static FormattingModel buildModel(@NotNull FormattingModelBuilder builder, @NotNull PsiElement element, @NotNull TextRange range, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (builder == null) {
            CoreFormatterUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            CoreFormatterUtil.$$$reportNull$$$0(1);
        }
        if (range == null) {
            CoreFormatterUtil.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            CoreFormatterUtil.$$$reportNull$$$0(3);
        }
        if (mode == null) {
            CoreFormatterUtil.$$$reportNull$$$0(4);
        }
        FormattingModel formattingModel = builder.createModel(FormattingContext.create((PsiElement)element, (TextRange)range, (CodeStyleSettings)settings, (FormattingMode)mode));
        if (formattingModel == null) {
            CoreFormatterUtil.$$$reportNull$$$0(5);
        }
        return formattingModel;
    }

    @NotNull
    public static FormattingModel buildModel(@NotNull FormattingModelBuilder builder, @NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (builder == null) {
            CoreFormatterUtil.$$$reportNull$$$0(6);
        }
        if (element == null) {
            CoreFormatterUtil.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            CoreFormatterUtil.$$$reportNull$$$0(8);
        }
        if (mode == null) {
            CoreFormatterUtil.$$$reportNull$$$0(9);
        }
        FormattingModel formattingModel = builder.createModel(FormattingContext.create((PsiElement)element, (CodeStyleSettings)settings, (FormattingMode)mode));
        if (formattingModel == null) {
            CoreFormatterUtil.$$$reportNull$$$0(10);
        }
        return formattingModel;
    }

    @Nullable
    public static AlignmentImpl getAlignment(@NotNull AbstractBlockWrapper block) {
        AlignmentImpl alignment;
        if (block == null) {
            CoreFormatterUtil.$$$reportNull$$$0(11);
        }
        AbstractBlockWrapper current = block;
        while ((alignment = current.getAlignment()) == null || alignment.getOffsetRespBlockBefore(block) == null) {
            if ((current = current.getParent()) != null && current.getStartOffset() == block.getStartOffset()) continue;
            return null;
        }
        return alignment;
    }

    public static int getStartColumn(@Nullable LeafBlockWrapper block) {
        if (block == null) {
            return -1;
        }
        int result = 0;
        do {
            WhiteSpace whiteSpace = block.getWhiteSpace();
            result += whiteSpace.getTotalSpaces();
            if (whiteSpace.containsLineFeeds()) {
                return result;
            }
            block = block.getPreviousBlock();
            if (result > 1000 || block == null) {
                return result;
            }
            result += block.getSymbolsAtTheLastLine();
        } while (!block.containsLineFeeds());
        return result;
    }

    @Nullable
    public static AbstractBlockWrapper getIndentedParentBlock(@NotNull AbstractBlockWrapper block) {
        if (block == null) {
            CoreFormatterUtil.$$$reportNull$$$0(12);
        }
        for (CompositeBlockWrapper current = block.getParent(); current != null; current = current.getParent()) {
            AbstractBlockWrapper prevIndented;
            if (current.getStartOffset() != block.getStartOffset() && current.getWhiteSpace().containsLineFeeds()) {
                return current;
            }
            if (current.getParent() == null || (prevIndented = current.getParent().getPrevIndentedSibling(current)) == null) continue;
            return prevIndented;
        }
        return null;
    }

    public static boolean allowBackwardAlignment(@NotNull LeafBlockWrapper first, @NotNull LeafBlockWrapper second, @NotNull Map<AbstractBlockWrapper, Set<AbstractBlockWrapper>> alignmentMappings) {
        if (first == null) {
            CoreFormatterUtil.$$$reportNull$$$0(13);
        }
        if (second == null) {
            CoreFormatterUtil.$$$reportNull$$$0(14);
        }
        if (alignmentMappings == null) {
            CoreFormatterUtil.$$$reportNull$$$0(15);
        }
        HashSet<AbstractBlockWrapper> blocksBeforeCurrent = new HashSet<AbstractBlockWrapper>();
        for (LeafBlockWrapper previousBlock = second.getPreviousBlock(); previousBlock != null; previousBlock = previousBlock.getPreviousBlock()) {
            Set<AbstractBlockWrapper> blocks = alignmentMappings.get(previousBlock);
            if (blocks != null) {
                blocksBeforeCurrent.addAll(blocks);
            }
            if (previousBlock.getWhiteSpace().containsLineFeeds()) break;
        }
        for (LeafBlockWrapper next = first.getNextBlock(); next != null && !next.getWhiteSpace().containsLineFeeds(); next = next.getNextBlock()) {
            if (!blocksBeforeCurrent.contains(next)) continue;
            return false;
        }
        return true;
    }

    public static IndentData getIndent(CommonCodeStyleSettings.IndentOptions options, AbstractBlockWrapper block, int tokenBlockStartOffset) {
        IndentImpl indent = block.getIndent();
        if (indent.getType() == Indent.Type.CONTINUATION) {
            return new IndentData(options.CONTINUATION_INDENT_SIZE);
        }
        if (indent.getType() == Indent.Type.CONTINUATION_WITHOUT_FIRST) {
            if (block.getStartOffset() != block.getParent().getStartOffset() && block.getStartOffset() == tokenBlockStartOffset) {
                return new IndentData(options.CONTINUATION_INDENT_SIZE);
            }
            return new IndentData(0);
        }
        if (indent.getType() == Indent.Type.LABEL) {
            return new IndentData(options.LABEL_INDENT_SIZE);
        }
        if (indent.getType() == Indent.Type.NONE) {
            return new IndentData(0);
        }
        if (indent.getType() == Indent.Type.SPACES) {
            return new IndentData(indent.getSpaces(), 0);
        }
        if (indent.getType() == Indent.Type.OUTDENT_NORMAL) {
            return new IndentData(-options.INDENT_SIZE, 0);
        }
        if (indent.getType() == Indent.Type.OUTDENT_SPACES) {
            return new IndentData(0, -indent.getSpaces());
        }
        return new IndentData(options.INDENT_SIZE);
    }

    @NotNull
    public static LeafBlockWrapper getFirstLeaf(@NotNull AbstractBlockWrapper block) {
        if (block == null) {
            CoreFormatterUtil.$$$reportNull$$$0(16);
        }
        if (block instanceof LeafBlockWrapper) {
            LeafBlockWrapper leafBlockWrapper = (LeafBlockWrapper)block;
            if (leafBlockWrapper == null) {
                CoreFormatterUtil.$$$reportNull$$$0(17);
            }
            return leafBlockWrapper;
        }
        return CoreFormatterUtil.getFirstLeaf(((CompositeBlockWrapper)block).getChildren().get(0));
    }

    public static boolean isFullwidthCharacter(int codePoint) {
        if (!Character.isValidCodePoint(codePoint)) {
            return false;
        }
        Character.UnicodeBlock block = Character.UnicodeBlock.of(codePoint);
        if (block == null) {
            return false;
        }
        return FULLWIDTH_BLOCKS.contains(block);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 5: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/CoreFormatterUtil";
                break;
            }
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignmentMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/CoreFormatterUtil";
                break;
            }
            case 5: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstLeaf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildModel";
                break;
            }
            case 5: 
            case 10: 
            case 17: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAlignment";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIndentedParentBlock";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "allowBackwardAlignment";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLeaf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 10, 17 -> new IllegalStateException(string);
        };
    }
}

