/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.RangesAssert;
import com.intellij.formatting.engine.State;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.ExtraRangesProvider;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;

final class AdjustFormatRangesState
extends State {
    private static final RangesAssert ASSERT = new RangesAssert();
    private final FormatTextRanges myFormatRanges;
    private final List<TextRange> myExtendedRanges;
    private final List<TextRange> totalNewRanges = new ArrayList<TextRange>();
    private final Stack<Block> state;
    private final FormattingDocumentModel myModel;

    AdjustFormatRangesState(Block currentRoot, FormatTextRanges formatRanges, FormattingDocumentModel model) {
        this.myModel = model;
        this.myFormatRanges = formatRanges;
        this.myExtendedRanges = formatRanges.getExtendedRanges();
        this.state = new Stack((Object[])new Block[]{currentRoot});
        this.setOnDone(() -> this.totalNewRanges.forEach(range -> this.myFormatRanges.add((TextRange)range, false)));
    }

    @Override
    public void doIteration() {
        Block currentBlock = (Block)this.state.pop();
        this.processBlock(currentBlock);
        this.setDone(this.state.isEmpty());
    }

    private void processBlock(Block currentBlock) {
        if (!this.isInsideExtendedFormattingRanges(currentBlock)) {
            return;
        }
        ((StreamEx)StreamEx.ofReversed((List)currentBlock.getSubBlocks()).filter(block -> ASSERT.checkChildRange(currentBlock.getTextRange(), block.getTextRange(), this.myModel))).forEach(block -> this.state.push(block));
        if (!this.myFormatRanges.isReadOnly(currentBlock.getTextRange())) {
            this.extractRanges(currentBlock);
        }
    }

    private boolean isInsideExtendedFormattingRanges(Block currentBlock) {
        TextRange blockRange = currentBlock.getTextRange();
        return this.myExtendedRanges.stream().anyMatch(range -> range.intersects(blockRange));
    }

    private void extractRanges(Block block) {
        List<TextRange> newRanges;
        if (block instanceof ExtraRangesProvider && (newRanges = ((ExtraRangesProvider)block).getExtraRangesToFormat(this.myFormatRanges)) != null) {
            this.totalNewRanges.addAll(newRanges);
        }
    }
}

