/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.impl.source.codeStyle.LineFormattingRangesExtender;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

final class ChangedRangesUtil {
    @Contract(pure=true)
    private ChangedRangesUtil() {
    }

    @NotNull
    static List<TextRange> processChangedRanges(@NotNull PsiFile file, @NotNull ChangedRangesInfo changedRangesInfo) {
        if (file == null) {
            ChangedRangesUtil.$$$reportNull$$$0(0);
        }
        if (changedRangesInfo == null) {
            ChangedRangesUtil.$$$reportNull$$$0(1);
        }
        Document document = file.getViewProvider().getDocument();
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        if (document != null) {
            LineFormattingRangesExtender extender = new LineFormattingRangesExtender(document);
            for (TextRange range : changedRangesInfo.allChangedRanges) {
                List<TextRange> extended = extender.getExtendedRanges(Collections.singletonList(range));
                result.addAll(extended);
            }
        } else {
            result.addAll(changedRangesInfo.allChangedRanges);
        }
        return ChangedRangesUtil.optimizedChangedRanges(result);
    }

    @NotNull
    private static List<TextRange> optimizedChangedRanges(@NotNull List<TextRange> allChangedRanges) {
        if (allChangedRanges == null) {
            ChangedRangesUtil.$$$reportNull$$$0(2);
        }
        if (allChangedRanges.isEmpty()) {
            List<TextRange> list = allChangedRanges;
            if (list == null) {
                ChangedRangesUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        List sorted = ContainerUtil.sorted(allChangedRanges, (Comparator)Segment.BY_START_OFFSET_THEN_END_OFFSET);
        SmartList result = new SmartList();
        TextRange prev = (TextRange)sorted.get(0);
        for (TextRange next : sorted) {
            if (next.getStartOffset() <= prev.getEndOffset()) {
                int newEndOffset = Math.max(prev.getEndOffset(), next.getEndOffset());
                prev = new TextRange(prev.getStartOffset(), newEndOffset);
                continue;
            }
            result.add(prev);
            prev = next;
        }
        result.add(prev);
        SmartList smartList = result;
        if (smartList == null) {
            ChangedRangesUtil.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedRangesInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allChangedRanges";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/ChangedRangesUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/ChangedRangesUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizedChangedRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processChangedRanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "optimizedChangedRanges";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

