/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.cache;

import com.intellij.application.options.codeStyle.cache.CodeStyleCachedValueProvider;
import com.intellij.application.options.codeStyle.cache.CodeStyleCachingService;
import com.intellij.application.options.codeStyle.cache.TooFrequentCodeStyleComputationWatcher;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import java.lang.ref.SoftReference;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CodeStyleCachingServiceImpl
implements CodeStyleCachingService,
Disposable {
    private static final Key<SoftReference<CodeStyleCachedValueProvider>> PROVIDER_KEY = Key.create((String)"code.style.cached.value.provider");
    private final Map<String, FileData> myFileDataCache = new HashMap<String, FileData>();
    private final Object CACHE_LOCK = new Object();
    private final int maxCacheSize;
    private final PriorityQueue<FileData> myRemoveQueue;
    private final Project myProject;
    private final TooFrequentCodeStyleComputationWatcher myFrequentCodeStyleComputationWatcher;

    public CodeStyleCachingServiceImpl(Project project) {
        this.myProject = project;
        this.maxCacheSize = Math.max(Registry.intValue((String)"code.style.cache.maximum.size", (int)100), 1);
        this.myRemoveQueue = new PriorityQueue<FileData>(this.maxCacheSize, Comparator.comparingLong(fileData -> fileData.lastRefTimeStamp));
        this.myFrequentCodeStyleComputationWatcher = TooFrequentCodeStyleComputationWatcher.getInstance(project);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                CodeStyleCachingServiceImpl.this.clearCache();
            }

            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                CodeStyleCachingServiceImpl.this.clearCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/application/options/codeStyle/cache/CodeStyleCachingServiceImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public CodeStyleSettings tryGetSettings(@NotNull VirtualFile file) {
        if (file == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(0);
        }
        return this.getOrCreateCachedValueProvider(file).tryGetSettings();
    }

    public void scheduleWhenSettingsComputed(@NotNull PsiFile file, @NotNull Runnable runnable) {
        VirtualFile virtualFile;
        if (file == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(1);
        }
        if (runnable == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(2);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            runnable.run();
        } else {
            this.getOrCreateCachedValueProvider(virtualFile).scheduleWhenComputed(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CodeStyleCachedValueProvider getOrCreateCachedValueProvider(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(3);
        }
        Object object = this.CACHE_LOCK;
        // MONITORENTER : object
        String key = CodeStyleCachingServiceImpl.getFileKey(virtualFile);
        FileData fileData = this.getFileData(key);
        CodeStyleCachedValueProvider provider = null;
        boolean needsFreshFileData = false;
        if (fileData == null) {
            needsFreshFileData = true;
        } else {
            SoftReference softReference = (SoftReference)fileData.getUserData(PROVIDER_KEY);
            CodeStyleCachedValueProvider codeStyleCachedValueProvider = provider = softReference != null ? (CodeStyleCachedValueProvider)softReference.get() : null;
            if (provider == null || provider.isExpired()) {
                needsFreshFileData = true;
            } else {
                Supplier<VirtualFile> supplier = provider.getFileSupplier();
                if (supplier instanceof VirtualFileGetter && !((VirtualFileGetter)supplier).virtualFile.equals(virtualFile)) {
                    needsFreshFileData = true;
                }
            }
        }
        if (needsFreshFileData) {
            void var7_10;
            fileData = this.createFileData(key, fileData);
            if (virtualFile instanceof LightVirtualFile) {
                LightVirtualFile copy = CodeStyleCachingServiceImpl.getCopy((LightVirtualFile)virtualFile);
                LightVirtualFileCopyGetter lightVirtualFileCopyGetter = new LightVirtualFileCopyGetter(copy);
            } else {
                VirtualFileGetter virtualFileGetter = new VirtualFileGetter(virtualFile);
            }
            provider = new CodeStyleCachedValueProvider((Supplier<VirtualFile>)var7_10, this.myProject, (UserDataHolder)fileData);
            fileData.putUserData(PROVIDER_KEY, new SoftReference<CodeStyleCachedValueProvider>(provider));
        }
        CodeStyleCachedValueProvider codeStyleCachedValueProvider = provider;
        // MONITOREXIT : object
        if (codeStyleCachedValueProvider != null) return codeStyleCachedValueProvider;
        CodeStyleCachingServiceImpl.$$$reportNull$$$0(4);
        return codeStyleCachedValueProvider;
    }

    @NotNull
    private static LightVirtualFile getCopy(@NotNull LightVirtualFile original) {
        if (original == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(5);
        }
        final VirtualFile parent = original.getParent();
        return new LightVirtualFile((VirtualFile)original, original.getContent(), original.getModificationStamp()){

            public VirtualFile getParent() {
                return parent;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            this.myFileDataCache.values().forEach(fileData -> {
                CodeStyleCachedValueProvider provider;
                SoftReference providerRef = (SoftReference)fileData.getUserData(PROVIDER_KEY);
                CodeStyleCachedValueProvider codeStyleCachedValueProvider = provider = providerRef != null ? (CodeStyleCachedValueProvider)providerRef.get() : null;
                if (provider != null) {
                    provider.cancelComputation();
                }
            });
            this.myFileDataCache.clear();
            this.myRemoveQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public UserDataHolder getDataHolder(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(6);
        }
        Object object = this.CACHE_LOCK;
        // MONITORENTER : object
        String key = CodeStyleCachingServiceImpl.getFileKey(virtualFile);
        FileData stored = this.getFileData(key);
        FileData fileData = stored != null ? stored : this.createFileData(key, stored);
        // MONITOREXIT : object
        if (fileData != null) return fileData;
        CodeStyleCachingServiceImpl.$$$reportNull$$$0(7);
        return fileData;
    }

    @Nullable
    private FileData getFileData(@NotNull String path) {
        FileData fileData;
        if (path == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(8);
        }
        if ((fileData = this.myFileDataCache.get(path)) != null) {
            this.myRemoveQueue.remove((Object)fileData);
            fileData.update();
            this.myRemoveQueue.add(fileData);
        }
        return fileData;
    }

    @NotNull
    private FileData createFileData(@NotNull String path, @Nullable FileData existingData) {
        FileData fileData;
        if (path == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(9);
        }
        this.myFrequentCodeStyleComputationWatcher.beforeCacheEntryInserted(this.myFileDataCache.size(), this.maxCacheSize);
        if (existingData != null) {
            this.myFileDataCache.remove(path);
            this.myRemoveQueue.remove((Object)existingData);
        }
        FileData newData = new FileData();
        if (existingData == null && this.myFileDataCache.size() >= this.maxCacheSize && (fileData = this.myRemoveQueue.poll()) != null) {
            this.myFileDataCache.values().remove((Object)fileData);
        }
        if (!this.myProject.isDefault()) {
            this.myFileDataCache.put(path, newData);
            this.myRemoveQueue.add(newData);
        }
        FileData fileData2 = newData;
        if (fileData2 == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(10);
        }
        return fileData2;
    }

    @NotNull
    private static String getFileKey(VirtualFile file) {
        String string = file.getUrl();
        if (string == null) {
            CodeStyleCachingServiceImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void dispose() {
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpState(StringBuilder sb) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            sb.append("Max cache size: ").append(this.maxCacheSize).append("\n");
            sb.append("Cache size: ").append(this.myFileDataCache.size()).append("\n");
            sb.append("Cached Entries: \n");
            this.myFileDataCache.forEach((key, value) -> {
                sb.append("URL: ").append((String)key).append("\nProvider: ");
                SoftReference providerRef = (SoftReference)value.getUserData(PROVIDER_KEY);
                if (providerRef != null) {
                    CodeStyleCachedValueProvider provider = (CodeStyleCachedValueProvider)providerRef.get();
                    if (provider != null) {
                        provider.dumpState(sb);
                    } else {
                        sb.append("null: garbage collected");
                    }
                } else {
                    sb.append("null: not initialized");
                }
                sb.append("\n");
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/cache/CodeStyleCachingServiceImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/cache/CodeStyleCachingServiceImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCachedValueProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataHolder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryGetSettings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scheduleWhenSettingsComputed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCachedValueProvider";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCopy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDataHolder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFileData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 10, 11 -> new IllegalStateException(string);
        };
    }

    public static final class FileData
    extends UserDataHolderBase {
        public long lastRefTimeStamp;

        private FileData() {
            this.update();
        }

        void update() {
            this.lastRefTimeStamp = System.currentTimeMillis();
        }
    }

    private record VirtualFileGetter(@NotNull VirtualFile virtualFile) implements Supplier<VirtualFile>
    {
        @NotNull
        private final VirtualFile virtualFile;

        private VirtualFileGetter(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                VirtualFileGetter.$$$reportNull$$$0(0);
            }
        }

        @Override
        @NotNull
        public VirtualFile get() {
            VirtualFile virtualFile = this.virtualFile;
            if (virtualFile == null) {
                VirtualFileGetter.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        @NotNull
        public VirtualFile virtualFile() {
            VirtualFile virtualFile = this.virtualFile;
            if (virtualFile == null) {
                VirtualFileGetter.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/codeStyle/cache/CodeStyleCachingServiceImpl$VirtualFileGetter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/codeStyle/cache/CodeStyleCachingServiceImpl$VirtualFileGetter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "virtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private record LightVirtualFileCopyGetter(@NotNull LightVirtualFile virtualFile) implements Supplier<VirtualFile>
    {
        @NotNull
        private final LightVirtualFile virtualFile;

        private LightVirtualFileCopyGetter(@NotNull LightVirtualFile virtualFile) {
            if (virtualFile == null) {
                LightVirtualFileCopyGetter.$$$reportNull$$$0(0);
            }
        }

        @Override
        @NotNull
        public VirtualFile get() {
            LightVirtualFile lightVirtualFile = CodeStyleCachingServiceImpl.getCopy(this.virtualFile);
            if (lightVirtualFile == null) {
                LightVirtualFileCopyGetter.$$$reportNull$$$0(1);
            }
            return lightVirtualFile;
        }

        @NotNull
        public LightVirtualFile virtualFile() {
            LightVirtualFile lightVirtualFile = this.virtualFile;
            if (lightVirtualFile == null) {
                LightVirtualFileCopyGetter.$$$reportNull$$$0(2);
            }
            return lightVirtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/codeStyle/cache/CodeStyleCachingServiceImpl$LightVirtualFileCopyGetter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/codeStyle/cache/CodeStyleCachingServiceImpl$LightVirtualFileCopyGetter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "virtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

