/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.AdjustFormatRangesState;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.InitialInfoBuilder;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.engine.AdjustWhiteSpacesState;
import com.intellij.formatting.engine.ApplyChangesState;
import com.intellij.formatting.engine.BlockIndentOptions;
import com.intellij.formatting.engine.BlockRangesMap;
import com.intellij.formatting.engine.ExpandChildrenIndentState;
import com.intellij.formatting.engine.IndentAdjuster;
import com.intellij.formatting.engine.StateProcessor;
import com.intellij.formatting.engine.WrapBlocksState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FormatProcessor {
    private static final Logger LOG = Logger.getInstance(FormatProcessor.class);
    private final WrapBlocksState myWrapState;
    private final boolean myReformatContext;
    private final Document myDocument;
    @NotNull
    private final FormattingProgressCallback myProgressCallback;
    @NotNull
    private final StateProcessor myStateProcessor;

    public FormatProcessor(FormattingDocumentModel docModel, Block rootBlock, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable FormatTextRanges affectedRanges, @NotNull FormattingProgressCallback progressCallback) {
        if (progressCallback == null) {
            FormatProcessor.$$$reportNull$$$0(0);
        }
        this(docModel, rootBlock, new FormatOptions(settings, indentOptions, affectedRanges), progressCallback);
    }

    public FormatProcessor(FormattingDocumentModel model, Block block, FormatOptions options, @NotNull FormattingProgressCallback callback) {
        if (callback == null) {
            FormatProcessor.$$$reportNull$$$0(1);
        }
        this.myProgressCallback = callback;
        CommonCodeStyleSettings.IndentOptions defaultIndentOption = options.myIndentOptions;
        CodeStyleSettings settings = options.mySettings;
        BlockIndentOptions blockIndentOptions = new BlockIndentOptions(settings, defaultIndentOption, block);
        this.myDocument = model.getDocument();
        this.myReformatContext = options.isReformatWithContext();
        InitialInfoBuilder builder = InitialInfoBuilder.prepareToBuildBlocksSequentially(block, model, options, defaultIndentOption, this.myProgressCallback);
        this.myWrapState = new WrapBlocksState(builder, blockIndentOptions);
        FormatTextRanges ranges = options.myAffectedRanges;
        if (ranges != null && this.myReformatContext) {
            AdjustFormatRangesState adjustRangesState = new AdjustFormatRangesState(block, ranges, model);
            this.myStateProcessor = new StateProcessor(adjustRangesState);
            this.myStateProcessor.setNextState(this.myWrapState);
        } else {
            this.myStateProcessor = new StateProcessor(this.myWrapState);
        }
    }

    public BlockRangesMap getBlockRangesMap() {
        return this.myWrapState.getBlockRangesMap();
    }

    public void format(FormattingModel model) {
        this.format(model, false);
    }

    public void format(FormattingModel model, boolean sequentially) {
        if (sequentially) {
            this.myStateProcessor.setNextState(new AdjustWhiteSpacesState(this.myWrapState, this.myProgressCallback, this.myReformatContext));
            this.myStateProcessor.setNextState(new ExpandChildrenIndentState(this.myDocument, this.myWrapState));
            this.myStateProcessor.setNextState(new ApplyChangesState(model, this.myWrapState, this.myProgressCallback));
        } else {
            this.formatWithoutRealModifications(false);
            this.performModifications(model, false);
        }
    }

    public boolean iteration() {
        if (this.myStateProcessor.isDone()) {
            return true;
        }
        this.myStateProcessor.iteration();
        return this.myStateProcessor.isDone();
    }

    public void stopSequentialProcessing() {
        this.myStateProcessor.stop();
    }

    public void formatWithoutRealModifications() {
        this.formatWithoutRealModifications(false);
    }

    public void formatWithoutRealModifications(boolean sequentially) {
        this.myStateProcessor.setNextState(new AdjustWhiteSpacesState(this.myWrapState, this.myProgressCallback, this.myReformatContext));
        this.myStateProcessor.setNextState(new ExpandChildrenIndentState(this.myDocument, this.myWrapState));
        if (sequentially) {
            return;
        }
        this.doIterationsSynchronously();
    }

    public void performModifications(FormattingModel model) {
        this.performModifications(model, false);
    }

    public void performModifications(FormattingModel model, boolean sequentially) {
        this.myStateProcessor.setNextState(new ApplyChangesState(model, this.myWrapState, this.myProgressCallback));
        if (sequentially) {
            return;
        }
        this.doIterationsSynchronously();
    }

    private void doIterationsSynchronously() {
        while (!this.myStateProcessor.isDone()) {
            this.myStateProcessor.iteration();
        }
    }

    public void setAllWhiteSpacesAreReadOnly() {
        for (LeafBlockWrapper current = this.myWrapState.getFirstBlock(); current != null; current = current.getNextBlock()) {
            current.getWhiteSpace().setReadOnly(true);
        }
    }

    public IndentInfo getIndentAt(int offset) {
        LeafBlockWrapper current = FormatProcessor.adjustAtLanguageBorder(this.processBlocksBefore(offset), offset);
        AbstractBlockWrapper parent = this.getParentFor(offset, current);
        if (parent == null) {
            LeafBlockWrapper previousBlock = current.getPreviousBlock();
            if (previousBlock != null) {
                parent = this.getParentFor(offset, previousBlock);
            }
            if (parent == null) {
                return new IndentInfo(0, 0, 0);
            }
        }
        int index = FormatProcessor.getNewChildPosition(parent, offset);
        Block block = this.myWrapState.getBlockToInfoMap().get(parent);
        if (block == null) {
            return new IndentInfo(0, 0, 0);
        }
        ChildAttributesInfo info = FormatProcessor.getChildAttributesInfo(block, index, parent);
        if (info == null) {
            return new IndentInfo(0, 0, 0);
        }
        IndentAdjuster adjuster = this.myWrapState.getIndentAdjuster();
        return adjuster.adjustLineIndent(info, current);
    }

    @NotNull
    private static LeafBlockWrapper adjustAtLanguageBorder(@NotNull LeafBlockWrapper current, int offset) {
        AbstractBlockWrapper prevParent;
        LeafBlockWrapper previousBlock;
        if (current == null) {
            FormatProcessor.$$$reportNull$$$0(2);
        }
        if (!(current.contains(offset) || (previousBlock = current.getPreviousBlock()) == null || previousBlock.contains(offset) || Objects.equals(previousBlock.getLanguage(), current.getLanguage()) || (prevParent = FormatProcessor.getParentFor(offset, previousBlock)) == null || prevParent.getEndOffset() > current.getStartOffset())) {
            LeafBlockWrapper leafBlockWrapper = previousBlock;
            if (leafBlockWrapper == null) {
                FormatProcessor.$$$reportNull$$$0(3);
            }
            return leafBlockWrapper;
        }
        LeafBlockWrapper leafBlockWrapper = current;
        if (leafBlockWrapper == null) {
            FormatProcessor.$$$reportNull$$$0(4);
        }
        return leafBlockWrapper;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static ChildAttributesInfo getChildAttributesInfo(@NotNull Block block, int index, @Nullable AbstractBlockWrapper parent) {
        void var4_7;
        if (block == null) {
            FormatProcessor.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            return null;
        }
        ChildAttributes childAttributes = block.getChildAttributes(index);
        if (childAttributes == ChildAttributes.DELEGATE_TO_PREV_CHILD) {
            void var5_10;
            Block block2 = (Block)block.getSubBlocks().get(index - 1);
            if (parent instanceof CompositeBlockWrapper) {
                AbstractBlockWrapper abstractBlockWrapper = ((CompositeBlockWrapper)parent).getChildren().get(index - 1);
                return FormatProcessor.getChildAttributesInfo(block2, block2.getSubBlocks().size(), (AbstractBlockWrapper)var5_10);
            } else {
                LeafBlockWrapper leafBlockWrapper = parent.getPreviousBlock();
            }
            return FormatProcessor.getChildAttributesInfo(block2, block2.getSubBlocks().size(), (AbstractBlockWrapper)var5_10);
        }
        if (childAttributes != ChildAttributes.DELEGATE_TO_NEXT_CHILD) return new ChildAttributesInfo(parent, childAttributes, index);
        if (parent instanceof CompositeBlockWrapper) {
            List<AbstractBlockWrapper> list = ((CompositeBlockWrapper)parent).getChildren();
            if (list == null || index >= list.size()) return null;
            AbstractBlockWrapper abstractBlockWrapper = list.get(index);
            return FormatProcessor.getChildAttributesInfo((Block)block.getSubBlocks().get(index), 0, (AbstractBlockWrapper)var4_7);
        } else {
            LeafBlockWrapper leafBlockWrapper = ((LeafBlockWrapper)parent).getNextBlock();
        }
        return FormatProcessor.getChildAttributesInfo((Block)block.getSubBlocks().get(index), 0, (AbstractBlockWrapper)var4_7);
    }

    private static int getNewChildPosition(AbstractBlockWrapper parent, int offset) {
        AbstractBlockWrapper parentBlockToUse = FormatProcessor.getLastNestedCompositeBlockForSameRange(parent);
        if (!(parentBlockToUse instanceof CompositeBlockWrapper)) {
            return 0;
        }
        List<AbstractBlockWrapper> subBlocks = ((CompositeBlockWrapper)parentBlockToUse).getChildren();
        if (subBlocks != null) {
            for (int i = 0; i < subBlocks.size(); ++i) {
                AbstractBlockWrapper block = subBlocks.get(i);
                if (block.getStartOffset() < offset) continue;
                return i;
            }
            return subBlocks.size();
        }
        return 0;
    }

    @Nullable
    private static AbstractBlockWrapper getParentFor(int offset, AbstractBlockWrapper block) {
        for (AbstractBlockWrapper current = block; current != null; current = current.getParent()) {
            if (current.getStartOffset() >= offset || current.getEndOffset() < offset) continue;
            return current;
        }
        return null;
    }

    @Nullable
    private AbstractBlockWrapper getParentFor(int offset, LeafBlockWrapper block) {
        AbstractBlockWrapper previous = this.getPreviousIncompleteBlock(block, offset);
        if (previous != null) {
            return FormatProcessor.getLastNestedCompositeBlockForSameRange(previous);
        }
        return FormatProcessor.getParentFor(offset, block);
    }

    @Nullable
    private AbstractBlockWrapper getPreviousIncompleteBlock(LeafBlockWrapper block, int offset) {
        if (block == null) {
            LeafBlockWrapper lastTokenBlock = this.myWrapState.getLastBlock();
            if (lastTokenBlock.isIncomplete()) {
                return lastTokenBlock;
            }
            return null;
        }
        AbstractBlockWrapper current = block;
        while (current.getParent() != null && current.getParent().getStartOffset() > offset) {
            current = current.getParent();
        }
        if (current.getParent() == null) {
            return null;
        }
        if (current.getEndOffset() <= offset) {
            while (!current.isIncomplete() && current.getParent() != null && current.getParent().getEndOffset() <= offset) {
                current = current.getParent();
            }
            if (current.isIncomplete()) {
                return current;
            }
        }
        if (current.getParent() == null) {
            return null;
        }
        List<AbstractBlockWrapper> subBlocks = current.getParent().getChildren();
        int index = subBlocks.indexOf(current);
        if (index < 0) {
            LOG.assertTrue(false);
        }
        if (index == 0) {
            return null;
        }
        AbstractBlockWrapper currentResult = subBlocks.get(index - 1);
        if (!currentResult.isIncomplete()) {
            return null;
        }
        AbstractBlockWrapper lastChild = FormatProcessor.getLastChildOf(currentResult);
        while (lastChild != null && lastChild.isIncomplete()) {
            currentResult = lastChild;
            lastChild = FormatProcessor.getLastChildOf(currentResult);
        }
        return currentResult;
    }

    @Nullable
    private static AbstractBlockWrapper getLastChildOf(AbstractBlockWrapper currentResult) {
        AbstractBlockWrapper parentBlockToUse = FormatProcessor.getLastNestedCompositeBlockForSameRange(currentResult);
        if (!(parentBlockToUse instanceof CompositeBlockWrapper)) {
            return null;
        }
        List<AbstractBlockWrapper> subBlocks = ((CompositeBlockWrapper)parentBlockToUse).getChildren();
        if (subBlocks.isEmpty()) {
            return null;
        }
        return subBlocks.get(subBlocks.size() - 1);
    }

    @NotNull
    private static AbstractBlockWrapper getLastNestedCompositeBlockForSameRange(@NotNull AbstractBlockWrapper block) {
        List<AbstractBlockWrapper> subBlocks;
        if (block == null) {
            FormatProcessor.$$$reportNull$$$0(6);
        }
        if (!(block instanceof CompositeBlockWrapper)) {
            AbstractBlockWrapper abstractBlockWrapper = block;
            if (abstractBlockWrapper == null) {
                FormatProcessor.$$$reportNull$$$0(7);
            }
            return abstractBlockWrapper;
        }
        AbstractBlockWrapper result = block;
        AbstractBlockWrapper candidate = block;
        while ((subBlocks = ((CompositeBlockWrapper)candidate).getChildren()) != null && subBlocks.size() == 1 && (candidate = subBlocks.get(0)).getStartOffset() == block.getStartOffset() && candidate.getEndOffset() == block.getEndOffset() && candidate instanceof CompositeBlockWrapper) {
            result = candidate;
        }
        AbstractBlockWrapper abstractBlockWrapper = result;
        if (abstractBlockWrapper == null) {
            FormatProcessor.$$$reportNull$$$0(8);
        }
        return abstractBlockWrapper;
    }

    private LeafBlockWrapper processBlocksBefore(int offset) {
        AdjustWhiteSpacesState state = new AdjustWhiteSpacesState(this.myWrapState, this.myProgressCallback, this.myReformatContext);
        state.prepare();
        LeafBlockWrapper last = null;
        while (!state.isDone() && state.getCurrentBlock().getStartOffset() < offset) {
            last = state.getCurrentBlock();
            state.doIteration();
        }
        return state.getCurrentBlock() != null ? state.getCurrentBlock() : last;
    }

    public LeafBlockWrapper getFirstTokenBlock() {
        return this.myWrapState.getFirstBlock();
    }

    public WhiteSpace getLastWhiteSpace() {
        return this.myWrapState.getLastWhiteSpace();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressCallback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/FormatProcessor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/FormatProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustAtLanguageBorder";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastNestedCompositeBlockForSameRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "adjustAtLanguageBorder";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChildAttributesInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLastNestedCompositeBlockForSameRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static final class FormatOptions {
        public CodeStyleSettings mySettings;
        public CommonCodeStyleSettings.IndentOptions myIndentOptions;
        public FormatTextRanges myAffectedRanges;
        public int myInterestingOffset;

        public FormatOptions(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options, FormatTextRanges ranges) {
            this(settings, options, ranges, -1);
        }

        public FormatOptions(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options, FormatTextRanges ranges, int interestingOffset) {
            this.mySettings = settings;
            this.myIndentOptions = options;
            this.myAffectedRanges = ranges;
            this.myInterestingOffset = interestingOffset;
        }

        public boolean isReformatWithContext() {
            return this.myAffectedRanges != null && this.myAffectedRanges.isExtendToContext();
        }
    }

    public record ChildAttributesInfo(AbstractBlockWrapper parent, ChildAttributes attributes, int index) {
    }
}

