/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.comments;

import com.intellij.formatting.comments.CommentLineData;
import com.intellij.formatting.comments.CommentLineDataBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class DocCommentLineDataBuilder
extends CommentLineDataBuilder {
    private final boolean myAlignDocComments;
    private final PsiElement myDocComment;
    private final CommonCodeStyleSettings.IndentOptions myIndentOptions;

    public DocCommentLineDataBuilder(@NotNull PsiElement docComment, boolean alignDocComments, @NotNull CommonCodeStyleSettings settings) {
        if (docComment == null) {
            DocCommentLineDataBuilder.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            DocCommentLineDataBuilder.$$$reportNull$$$0(1);
        }
        super(settings.getRootSettings());
        this.myDocComment = docComment;
        this.myAlignDocComments = alignDocComments;
        this.myIndentOptions = settings.getIndentOptions() != null ? settings.getIndentOptions() : new CommonCodeStyleSettings.IndentOptions();
    }

    @Override
    public List<CommentLineData> getLines() {
        CharSequence docChars = this.myDocComment.getNode().getChars();
        ArrayList<CommentLineData> lines = new ArrayList<CommentLineData>();
        int lineStart = 0;
        boolean isTagLine = false;
        block3: for (int i = 0; i < docChars.length(); ++i) {
            char c = docChars.charAt(i);
            switch (c) {
                case '\n': {
                    if (lineStart < i) {
                        CommentLineData lineData = this.createLineDataFromSequence(docChars, lineStart, i, isTagLine);
                        isTagLine = lineData.isTagLine();
                        lines.add(lineData);
                    }
                    lineStart = i + 1;
                    continue block3;
                }
            }
        }
        if (lineStart < docChars.length()) {
            lines.add(this.createLineDataFromSequence(docChars, lineStart, docChars.length(), isTagLine));
        }
        return lines;
    }

    private CommentLineData createLineDataFromSequence(CharSequence charSequence, int start2, int end, boolean isTagLine) {
        String line = new String(CharArrayUtil.fromSequence((CharSequence)charSequence, (int)start2, (int)end));
        CommentLineData lineData = this.parseLine(line);
        lineData.setTagLine(isTagLine);
        return lineData;
    }

    @Override
    @NotNull
    public CommentLineData parseLine(@NotNull String line) {
        if (line == null) {
            DocCommentLineDataBuilder.$$$reportNull$$$0(2);
        }
        DocCommentLineData lineData = new DocCommentLineData(line);
        lineData.commentOffset = DocCommentLineDataBuilder.nextNonWhitespace(line, 0);
        if (lineData.commentOffset >= 0) {
            int next;
            if (line.charAt(lineData.commentOffset) == '*') {
                ++lineData.commentOffset;
            }
            if ((next = DocCommentLineDataBuilder.nextNonWhitespace(line, lineData.commentOffset)) >= 0) {
                char firstChar = line.charAt(next);
                if (firstChar == '@') {
                    lineData.tagStartOffset = next;
                    int n = lineData.tagEndOffset = (next = DocCommentLineDataBuilder.nextWhitespace(line, next + 1)) >= 0 ? next : line.length();
                    if (lineData.tagEndOffset > lineData.tagStartOffset) {
                        lineData.tagName = line.substring(lineData.tagStartOffset, lineData.tagEndOffset);
                    }
                    if (next >= 0) {
                        if ("@param".equals(lineData.tagName)) {
                            if ((next = DocCommentLineDataBuilder.nextNonWhitespace(line, next + 1)) >= 0) {
                                boolean isAtParamName = line.charAt(next) == '$';
                                next = DocCommentLineDataBuilder.nextWhitespace(line, next);
                                if (!isAtParamName && next >= 0) {
                                    next = DocCommentLineDataBuilder.skipNextWord(line, next);
                                }
                            }
                        } else if ("@return".equals(lineData.tagName) || "@throws".equals(lineData.tagName)) {
                            next = DocCommentLineDataBuilder.skipNextWord(line, next);
                        }
                    }
                } else if (Character.isLetter(firstChar)) {
                    lineData.startsWithLetter = true;
                }
                if (next >= 0) {
                    lineData.textStartOffset = (next = DocCommentLineDataBuilder.nextNonWhitespace(line, next)) >= 0 ? next : -1;
                    DocCommentLineDataBuilder.collectInlineTagsRanges(lineData, line);
                }
            }
        }
        DocCommentLineData docCommentLineData = lineData;
        if (docCommentLineData == null) {
            DocCommentLineDataBuilder.$$$reportNull$$$0(3);
        }
        return docCommentLineData;
    }

    private static void collectInlineTagsRanges(@NotNull CommentLineData lineData, @NotNull String line) {
        if (lineData == null) {
            DocCommentLineDataBuilder.$$$reportNull$$$0(4);
        }
        if (line == null) {
            DocCommentLineDataBuilder.$$$reportNull$$$0(5);
        }
        if (lineData.textStartOffset < 0) {
            return;
        }
        int inlineTagStart = -1;
        block4: for (int i = lineData.textStartOffset; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (c) {
                case '{': {
                    int j = i + 1;
                    if (j >= line.length() || line.charAt(j) != '@') continue block4;
                    inlineTagStart = i;
                    continue block4;
                }
                case '}': {
                    if (inlineTagStart >= 0) {
                        TextRange tagRange = new TextRange(DocCommentLineDataBuilder.findLinkDescriptionStart(line, inlineTagStart, lineData.textStartOffset), i);
                        lineData.addUnbreakableRange(tagRange);
                    }
                    inlineTagStart = -1;
                }
            }
        }
    }

    private static int findLinkDescriptionStart(String line, int from, int textStartOffset) {
        if (from <= textStartOffset || line.charAt(from - 1) != ']') {
            return from;
        }
        for (int i = from; i >= textStartOffset; --i) {
            char c = line.charAt(i);
            if (c != '[') continue;
            return i;
        }
        return from;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/comments/DocCommentLineDataBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/comments/DocCommentLineDataBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInlineTagsRanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class DocCommentLineData
    extends CommentLineData {
        int tagStartOffset;
        int tagEndOffset;
        String tagName;
        private boolean isTagLine;

        DocCommentLineData(String line) {
            if (line == null) {
                DocCommentLineData.$$$reportNull$$$0(0);
            }
            super(line);
            this.tagStartOffset = -1;
            this.tagEndOffset = -1;
            this.tagName = "";
            this.isTagLine = false;
        }

        @Override
        public boolean isTagLine() {
            return this.tagStartOffset >= 0 || this.isTagLine;
        }

        @Override
        public void setTagLine(boolean tagLine) {
            this.isTagLine = tagLine;
        }

        @Override
        @NotNull
        public String getLinePrefix() {
            StringBuilder prefixBuilder = new StringBuilder();
            if (this.commentOffset >= 0) {
                prefixBuilder.append(this.line, 0, this.commentOffset);
                if (this.textStartOffset > this.commentOffset) {
                    if (DocCommentLineDataBuilder.this.myAlignDocComments) {
                        StringUtil.repeatSymbol((Appendable)prefixBuilder, (char)' ', (int)(this.textStartOffset - this.commentOffset - 1));
                    } else if (this.isTagLine()) {
                        StringUtil.repeatSymbol((Appendable)prefixBuilder, (char)' ', (int)DocCommentLineDataBuilder.this.myIndentOptions.CONTINUATION_INDENT_SIZE);
                    }
                }
            }
            String string = prefixBuilder.toString();
            if (string == null) {
                DocCommentLineData.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected int getTabSize() {
            return DocCommentLineDataBuilder.this.myIndentOptions.TAB_SIZE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/formatting/comments/DocCommentLineDataBuilder$DocCommentLineData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/formatting/comments/DocCommentLineDataBuilder$DocCommentLineData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLinePrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

