/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.BlockAlignmentProcessor;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractBlockAlignmentProcessor
implements BlockAlignmentProcessor {
    @Override
    public BlockAlignmentProcessor.Result applyAlignment(@NotNull BlockAlignmentProcessor.Context context) {
        IndentData indent;
        if (context == null) {
            AbstractBlockAlignmentProcessor.$$$reportNull$$$0(0);
        }
        if ((indent = this.calculateAlignmentAnchorIndent(context)) == null) {
            return BlockAlignmentProcessor.Result.TARGET_BLOCK_PROCESSED_NOT_ALIGNED;
        }
        WhiteSpace whiteSpace = context.targetBlock().getWhiteSpace();
        if (whiteSpace.containsLineFeeds() && this.applyIndentToTheFirstBlockOnLine(indent, context)) {
            return BlockAlignmentProcessor.Result.TARGET_BLOCK_ALIGNED;
        }
        int diff = this.getAlignmentIndentDiff(indent, context);
        if (diff == 0) {
            return BlockAlignmentProcessor.Result.TARGET_BLOCK_ALIGNED;
        }
        if (diff > 0) {
            int alignmentSpaces = whiteSpace.getSpaces() + diff;
            whiteSpace.setSpaces(alignmentSpaces, whiteSpace.getIndentSpaces());
            if (!whiteSpace.containsLineFeeds()) {
                whiteSpace.setForceSkipTabulationsUsage(true);
            }
            return BlockAlignmentProcessor.Result.TARGET_BLOCK_ALIGNED;
        }
        if (!context.alignment().isAllowBackwardShift()) {
            return BlockAlignmentProcessor.Result.TARGET_BLOCK_PROCESSED_NOT_ALIGNED;
        }
        LeafBlockWrapper offsetResponsibleBlock = context.alignment().getOffsetRespBlockBefore(context.targetBlock());
        if (offsetResponsibleBlock == null) {
            return BlockAlignmentProcessor.Result.TARGET_BLOCK_PROCESSED_NOT_ALIGNED;
        }
        if (offsetResponsibleBlock.getWhiteSpace().isIsReadOnly()) {
            return BlockAlignmentProcessor.Result.UNABLE_TO_ALIGN_BACKWARD_BLOCK;
        }
        if (!CoreFormatterUtil.allowBackwardAlignment(offsetResponsibleBlock, context.targetBlock(), context.alignmentMappings())) {
            return BlockAlignmentProcessor.Result.UNABLE_TO_ALIGN_BACKWARD_BLOCK;
        }
        Set<LeafBlockWrapper> blocksCausedRealignment = context.backwardShiftedAlignedBlocks().get(offsetResponsibleBlock);
        if (blocksCausedRealignment != null && blocksCausedRealignment.contains(context.targetBlock())) {
            return BlockAlignmentProcessor.Result.RECURSION_DETECTED;
        }
        WhiteSpace previousWhiteSpace = offsetResponsibleBlock.getWhiteSpace();
        previousWhiteSpace.setSpaces(previousWhiteSpace.getSpaces() - diff, previousWhiteSpace.getIndentOffset());
        if (!previousWhiteSpace.containsLineFeeds()) {
            previousWhiteSpace.setForceSkipTabulationsUsage(true);
        }
        return BlockAlignmentProcessor.Result.BACKWARD_BLOCK_ALIGNED;
    }

    @Nullable
    protected abstract IndentData calculateAlignmentAnchorIndent(@NotNull BlockAlignmentProcessor.Context var1);

    protected abstract boolean applyIndentToTheFirstBlockOnLine(@NotNull IndentData var1, @NotNull BlockAlignmentProcessor.Context var2);

    protected abstract int getAlignmentIndentDiff(@NotNull IndentData var1, @NotNull BlockAlignmentProcessor.Context var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/formatting/AbstractBlockAlignmentProcessor", "applyAlignment"));
    }
}

