/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.CodeStyleBundle;
import com.intellij.openapi.util.NlsContexts;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public enum FormattingStateId {
    WRAPPING_BLOCKS(2.0, "progress.reformat.stage.wrapping.blocks"),
    PROCESSING_BLOCKS(1.0, "progress.reformat.stage.processing.blocks"),
    EXPANDING_CHILDREN_INDENTS(5.0, "progress.reformat.stage.expanding.children.indents"),
    APPLYING_CHANGES(10.0, "progress.reformat.stage.applying.changes");

    private final Supplier<@NlsContexts.ProgressText String> myDescription;
    private final double myWeight;

    private FormattingStateId(double weight, String descriptionKey) {
        this.myWeight = weight;
        this.myDescription = CodeStyleBundle.messagePointer((String)descriptionKey, (Object[])new Object[0]);
    }

    @NlsContexts.ProgressText
    public String getDescription() {
        return this.myDescription.get();
    }

    public double getProgressWeight() {
        return this.myWeight;
    }

    @NotNull
    public Set<FormattingStateId> getPreviousStates() {
        EnumSet<FormattingStateId> result = EnumSet.noneOf(FormattingStateId.class);
        for (FormattingStateId state : FormattingStateId.values()) {
            if (state == this) break;
            result.add(state);
        }
        EnumSet<FormattingStateId> enumSet = result;
        if (enumSet == null) {
            FormattingStateId.$$$reportNull$$$0(0);
        }
        return enumSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormattingStateId", "getPreviousStates"));
    }
}

