/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IndentInside {
    public int whiteSpaces = 0;
    public int tabs = 0;

    public IndentInside() {
    }

    public IndentInside(int whiteSpaces, int tabs) {
        this.whiteSpaces = whiteSpaces;
        this.tabs = tabs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndentInside indent = (IndentInside)o;
        if (this.tabs != indent.tabs) {
            return false;
        }
        return this.whiteSpaces == indent.whiteSpaces;
    }

    public int hashCode() {
        int result = this.whiteSpaces;
        result = 29 * result + this.tabs;
        return result;
    }

    public int getTabsCount(CommonCodeStyleSettings.IndentOptions options) {
        int tabsFromSpaces = this.whiteSpaces / options.TAB_SIZE;
        return this.tabs + tabsFromSpaces;
    }

    public int getSpacesCount(CommonCodeStyleSettings.IndentOptions options) {
        return this.whiteSpaces + this.tabs * options.TAB_SIZE;
    }

    @NotNull
    static IndentInside getLastLineIndent(@NotNull CharSequence text) {
        if (text == null) {
            IndentInside.$$$reportNull$$$0(0);
        }
        CharSequence lastLine = IndentInside.getLastLine(text);
        return IndentInside.createIndentOn(lastLine);
    }

    @NotNull
    public static IndentInside createIndentOn(@Nullable CharSequence lastLine) {
        IndentInside result = new IndentInside();
        if (lastLine == null) {
            IndentInside indentInside = result;
            if (indentInside == null) {
                IndentInside.$$$reportNull$$$0(1);
            }
            return indentInside;
        }
        for (int i = 0; i < lastLine.length(); ++i) {
            if (lastLine.charAt(i) == ' ') {
                ++result.whiteSpaces;
            }
            if (lastLine.charAt(i) != '\t') continue;
            ++result.tabs;
        }
        IndentInside indentInside = result;
        if (indentInside == null) {
            IndentInside.$$$reportNull$$$0(2);
        }
        return indentInside;
    }

    @NotNull
    public static CharSequence getLastLine(@NotNull CharSequence text) {
        int i;
        if (text == null) {
            IndentInside.$$$reportNull$$$0(3);
        }
        if ((i = CharArrayUtil.shiftBackwardUntil((CharSequence)text, (int)(text.length() - 1), (String)"\n")) < 0) {
            CharSequence charSequence = text;
            if (charSequence == null) {
                IndentInside.$$$reportNull$$$0(4);
            }
            return charSequence;
        }
        if (i >= text.length() - 1) {
            return "";
        }
        CharSequence charSequence = text.subSequence(i + 1, text.length());
        if (charSequence == null) {
            IndentInside.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    public String toString() {
        return String.format("spaces: %d, tabs: %d", this.whiteSpaces, this.tabs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/IndentInside";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/IndentInside";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndentOn";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLastLineIndent";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLastLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

