/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockAlignmentProcessor;
import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.BlockAlignmentProcessor;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class LeftEdgeAlignmentProcessor
extends AbstractBlockAlignmentProcessor {
    @Override
    protected IndentData calculateAlignmentAnchorIndent(@NotNull BlockAlignmentProcessor.Context context) {
        LeafBlockWrapper offsetResponsibleBlock;
        if (context == null) {
            LeftEdgeAlignmentProcessor.$$$reportNull$$$0(0);
        }
        if ((offsetResponsibleBlock = context.alignment().getOffsetRespBlockBefore(context.targetBlock())) == null) {
            return null;
        }
        WhiteSpace whiteSpace = offsetResponsibleBlock.getWhiteSpace();
        if (whiteSpace.containsLineFeeds()) {
            return new IndentData(whiteSpace.getIndentSpaces(), whiteSpace.getSpaces());
        }
        int offsetBeforeBlock = CoreFormatterUtil.getStartColumn(offsetResponsibleBlock);
        AbstractBlockWrapper prevIndentedBlock = CoreFormatterUtil.getIndentedParentBlock(context.targetBlock());
        if (prevIndentedBlock == null) {
            return new IndentData(0, offsetBeforeBlock);
        }
        int parentIndent = prevIndentedBlock.getWhiteSpace().getIndentOffset();
        if (parentIndent > offsetBeforeBlock) {
            return new IndentData(0, offsetBeforeBlock);
        }
        return new IndentData(parentIndent, offsetBeforeBlock - parentIndent);
    }

    @Override
    protected boolean applyIndentToTheFirstBlockOnLine(@NotNull IndentData alignmentAnchorIndent, @NotNull BlockAlignmentProcessor.Context context) {
        if (alignmentAnchorIndent == null) {
            LeftEdgeAlignmentProcessor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            LeftEdgeAlignmentProcessor.$$$reportNull$$$0(2);
        }
        WhiteSpace whiteSpace = context.targetBlock().getWhiteSpace();
        whiteSpace.setSpaces(alignmentAnchorIndent.getSpaces(), alignmentAnchorIndent.getIndentSpaces());
        return true;
    }

    @Override
    protected int getAlignmentIndentDiff(@NotNull IndentData alignmentAnchorIndent, @NotNull BlockAlignmentProcessor.Context context) {
        if (alignmentAnchorIndent == null) {
            LeftEdgeAlignmentProcessor.$$$reportNull$$$0(3);
        }
        if (context == null) {
            LeftEdgeAlignmentProcessor.$$$reportNull$$$0(4);
        }
        IndentData indentBeforeBlock = context.targetBlock().getNumberOfSymbolsBeforeBlock();
        return alignmentAnchorIndent.getTotalSpaces() - indentBeforeBlock.getTotalSpaces();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignmentAnchorIndent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/LeftEdgeAlignmentProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateAlignmentAnchorIndent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyIndentToTheFirstBlockOnLine";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAlignmentIndentDiff";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

