/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.FormattingProgressCallbackFactory;
import com.intellij.formatting.InjectedFormattingOptionsProvider;
import com.intellij.formatting.VirtualFormattingImplKt;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.VirtualFormattingListener;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeFormattingData;
import com.intellij.psi.impl.source.codeStyle.ContextFormattingRangesExtender;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.TextRangeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodeFormatterFacade {
    private static final Logger LOG = Logger.getInstance(CodeFormatterFacade.class);
    private final CodeStyleSettings mySettings;
    private final FormatterTagHandler myTagHandler;
    private final boolean myCanChangeWhitespaceOnly;
    public static final ThreadLocal<Boolean> FORMATTING_CANCELLED_FLAG = ThreadLocal.withInitial(() -> false);

    public CodeFormatterFacade(CodeStyleSettings settings, @Nullable Language language) {
        this(settings, language, false);
    }

    public CodeFormatterFacade(CodeStyleSettings settings, @Nullable Language language, boolean canChangeWhitespaceOnly) {
        this.mySettings = settings;
        this.myTagHandler = new FormatterTagHandler(settings);
        this.myCanChangeWhitespaceOnly = canChangeWhitespaceOnly;
    }

    public ASTNode processElement(ASTNode element) {
        TextRange range = element.getTextRange();
        return this.processRange(element, range.getStartOffset(), range.getEndOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASTNode processRange(ASTNode element, int startOffset, int endOffset) {
        FormattingModelBuilder builder;
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)element);
        assert (psiElement != null);
        PsiFile file = psiElement.getContainingFile();
        Document document = file.getViewProvider().getDocument();
        boolean delegateToTopLevel = CodeFormatterFacade.shouldDelegateToTopLevel(document, file);
        PsiElement elementToFormat = delegateToTopLevel ? InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file) : psiElement;
        PsiFile fileToFormat = elementToFormat.getContainingFile();
        VirtualFormattingListener listener = VirtualFormattingImplKt.getVirtualFormattingListener((PsiElement)file);
        try {
            if (listener != null) {
                VirtualFormattingImplKt.setVirtualFormattingListener((PsiElement)fileToFormat, listener);
            }
            builder = LanguageFormatting.INSTANCE.forContext((PsiElement)fileToFormat);
        }
        finally {
            if (listener != null) {
                VirtualFormattingImplKt.setVirtualFormattingListener((PsiElement)fileToFormat, null);
            }
        }
        if (builder != null) {
            RangeMarker rangeMarker = null;
            CodeFormattingData codeFormattingData = CodeFormattingData.getOrCreate(fileToFormat);
            try {
                if (document != null && endOffset < document.getTextLength()) {
                    rangeMarker = document.createRangeMarker(startOffset, endOffset);
                }
                TextRange range = this.preprocess(codeFormattingData, element, TextRange.create((int)startOffset, (int)endOffset));
                if (delegateToTopLevel) {
                    range = ((DocumentWindow)document).injectedToHost(range);
                }
                FormattingModel model = CoreFormatterUtil.buildModel(builder, elementToFormat, range, this.mySettings, FormattingMode.REFORMAT);
                if (file.getTextLength() > 0) {
                    try {
                        FormatTextRanges ranges = new FormatTextRanges(range, true);
                        this.setDisabledRanges(fileToFormat, ranges);
                        FormatterEx.getInstanceEx().format(model, this.mySettings, CodeFormatterFacade.getIndentOptions(this.mySettings, file.getProject(), file, document, range), ranges);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                if (!psiElement.isValid()) {
                    if (rangeMarker != null) {
                        PsiElement at = file.findElementAt(rangeMarker.getStartOffset());
                        PsiElement result = PsiTreeUtil.getParentOfType((PsiElement)at, (Class)psiElement.getClass(), (boolean)false);
                        assert (result != null);
                        rangeMarker.dispose();
                        ASTNode aSTNode = result.getNode();
                        return aSTNode;
                    }
                    assert (false);
                }
            }
            finally {
                if (rangeMarker != null) {
                    rangeMarker.dispose();
                }
                codeFormattingData.dispose();
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processText(@NotNull PsiFile file, FormatTextRanges ranges, boolean doPostponedFormatting) {
        FormattingModelBuilder builder;
        if (file == null) {
            CodeFormatterFacade.$$$reportNull$$$0(0);
        }
        Project project = file.getProject();
        Document document = file.getViewProvider().getDocument();
        List<FormatTextRange> textRanges = ranges.getRanges();
        if (document instanceof DocumentWindow) {
            DocumentWindow documentWindow = (DocumentWindow)document;
            if (CodeFormatterFacade.shouldDelegateToTopLevel(file)) {
                file = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
                for (FormatTextRange range : textRanges) {
                    range.setTextRange(documentWindow.injectedToHost(range.getTextRange()));
                }
                document = documentWindow.getDelegate();
            }
        }
        if ((builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file)) != null && file.getTextLength() > 0) {
            LOG.assertTrue(document != null);
            if (ranges.isExtendToContext()) {
                ranges.setExtendedRanges(new ContextFormattingRangesExtender(document, file).getExtendedRanges(ranges.getTextRanges()));
            }
            CodeFormattingData formattingData = CodeFormattingData.getOrCreate(file);
            try {
                FormattingProgressCallback progressCallback;
                ASTNode containingNode = CodeFormatterFacade.findContainingNode(file, ranges.getBoundRange());
                if (containingNode != null) {
                    for (FormatTextRange range : ranges.getRanges()) {
                        TextRange rangeToUse = this.preprocess(formattingData, containingNode, range.getTextRange());
                        range.setTextRange(rangeToUse);
                    }
                }
                if (doPostponedFormatting) {
                    CodeFormatterFacade.invokePostponedFormatting(file, document, textRanges);
                }
                if (FORMATTING_CANCELLED_FLAG.get().booleanValue()) {
                    return;
                }
                TextRange formattingModelRange = (TextRange)ObjectUtils.notNull((Object)ranges.getBoundRange(), (Object)file.getTextRange());
                FormattingModel originalModel = CoreFormatterUtil.buildModel(builder, (PsiElement)file, formattingModelRange, this.mySettings, FormattingMode.REFORMAT);
                DocumentBasedFormattingModel model = new DocumentBasedFormattingModel(originalModel, document, project, this.mySettings, file.getFileType(), file);
                FormatterEx formatter = FormatterEx.getInstanceEx();
                if (CodeStyleManager.getInstance((Project)project).isSequentialProcessingAllowed() && (progressCallback = FormattingProgressCallbackFactory.getInstance().createProgressCallback(project, file, document)) != null) {
                    formatter.setProgressTask(progressCallback);
                }
                CommonCodeStyleSettings.IndentOptions indentOptions = CodeFormatterFacade.getIndentOptions(this.mySettings, project, file, document, textRanges.size() == 1 ? textRanges.get(0).getTextRange() : null);
                this.setDisabledRanges(file, ranges);
                formatter.format((FormattingModel)model, this.mySettings, indentOptions, ranges);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            finally {
                formattingData.dispose();
            }
        }
    }

    @NotNull
    static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull Project project, @NotNull PsiFile psiFile, @Nullable Document document, @Nullable TextRange textRange) {
        VirtualFile virtualFile;
        if (settings == null) {
            CodeFormatterFacade.$$$reportNull$$$0(1);
        }
        if (project == null) {
            CodeFormatterFacade.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            CodeFormatterFacade.$$$reportNull$$$0(3);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = (virtualFile = CodeFormatterFacade.getVirtualFile(psiFile, document)) != null ? settings.getIndentOptionsByFile(project, virtualFile, textRange) : settings.getIndentOptions(psiFile.getFileType());
        if (indentOptions == null) {
            CodeFormatterFacade.$$$reportNull$$$0(4);
        }
        return indentOptions;
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull PsiFile psiFile, @Nullable Document document) {
        VirtualFile file;
        if (psiFile == null) {
            CodeFormatterFacade.$$$reportNull$$$0(5);
        }
        if ((file = psiFile.getVirtualFile()) != null) {
            return file;
        }
        if (document != null) {
            return FileDocumentManager.getInstance().getFile(document);
        }
        return null;
    }

    private void setDisabledRanges(@NotNull PsiFile file, FormatTextRanges ranges) {
        if (file == null) {
            CodeFormatterFacade.$$$reportNull$$$0(6);
        }
        Iterable excludedRangesIterable = TextRangeUtil.excludeRanges((TextRange)file.getTextRange(), this.myTagHandler.getEnabledRanges((ASTNode)file.getNode(), file.getTextRange()));
        ranges.setDisabledRanges((Collection)excludedRangesIterable);
    }

    private static void invokePostponedFormatting(@NotNull PsiFile file, Document document, List<? extends FormatTextRange> textRanges) {
        if (file == null) {
            CodeFormatterFacade.$$$reportNull$$$0(7);
        }
        RangeMarker[] markers = new RangeMarker[textRanges.size()];
        int i = 0;
        for (FormatTextRange formatTextRange : textRanges) {
            TextRange textRange = formatTextRange.getTextRange();
            int start2 = textRange.getStartOffset();
            int end = textRange.getEndOffset();
            if (start2 < 0 || end <= start2 || end > document.getTextLength()) continue;
            markers[i] = document.createRangeMarker(textRange);
            markers[i].setGreedyToLeft(true);
            markers[i].setGreedyToRight(true);
            ++i;
        }
        PostprocessReformattingAspect component = PostprocessReformattingAspect.getInstance((Project)file.getProject());
        FORMATTING_CANCELLED_FLAG.set(false);
        component.doPostponedFormatting(file.getViewProvider());
        i = 0;
        for (FormatTextRange formatTextRange : textRanges) {
            RangeMarker marker = markers[i];
            if (marker != null) {
                formatTextRange.setTextRange(marker.getTextRange());
                marker.dispose();
            }
            ++i;
        }
    }

    @Nullable
    static ASTNode findContainingNode(@NotNull PsiFile file, @Nullable TextRange range) {
        if (file == null) {
            CodeFormatterFacade.$$$reportNull$$$0(8);
        }
        Language language = file.getLanguage();
        if (range == null) {
            return null;
        }
        FileViewProvider viewProvider = file.getViewProvider();
        PsiElement startElement = viewProvider.findElementAt(range.getStartOffset(), language);
        PsiElement endElement = viewProvider.findElementAt(range.getEndOffset() - 1, language);
        PsiElement commonParent = startElement != null && endElement != null ? PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement) : null;
        ASTNode node = null;
        if (commonParent != null) {
            node = commonParent.getNode();
            for (ASTNode parent = node.getTreeParent(); parent != null && parent.getTextRange().equals((Object)commonParent.getTextRange()); parent = parent.getTreeParent()) {
                node = parent;
            }
        }
        if (node == null) {
            node = file.getNode();
        }
        return node;
    }

    private TextRange preprocess(@NotNull CodeFormattingData formattingData, @NotNull ASTNode node, @NotNull TextRange range) {
        if (formattingData == null) {
            CodeFormatterFacade.$$$reportNull$$$0(9);
        }
        if (node == null) {
            CodeFormatterFacade.$$$reportNull$$$0(10);
        }
        if (range == null) {
            CodeFormatterFacade.$$$reportNull$$$0(11);
        }
        TextRange result = range;
        PsiElement psi = node.getPsi();
        if (!psi.isValid()) {
            return result;
        }
        PsiFile file = psi.getContainingFile();
        Set<TextRange> injectedFileRangesSet = formattingData.getInjectedRanges(range);
        if (!injectedFileRangesSet.isEmpty()) {
            ArrayList<TextRange> ranges = new ArrayList<TextRange>(injectedFileRangesSet);
            Collections.reverse(ranges);
            for (TextRange injectedFileRange : ranges) {
                TextRange initialInjectedRange;
                PsiFile injected;
                int startHostOffset = injectedFileRange.getStartOffset();
                int endHostOffset = injectedFileRange.getEndOffset();
                if (startHostOffset < range.getStartOffset() || endHostOffset > range.getEndOffset() || (injected = InjectedLanguageUtilBase.findInjectedPsiNoCommit((PsiFile)file, (int)startHostOffset)) == null) continue;
                TextRange injectedRange = initialInjectedRange = TextRange.create((int)0, (int)injected.getTextLength());
                for (PreFormatProcessor processor : PreFormatProcessor.EP_NAME.getExtensionList()) {
                    if (!processor.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                    injectedRange = processor.process((ASTNode)injected.getNode(), injectedRange);
                }
                if ((initialInjectedRange.getStartOffset() <= injectedRange.getStartOffset() || initialInjectedRange.getStartOffset() <= 0) && (initialInjectedRange.getEndOffset() >= injectedRange.getEndOffset() || initialInjectedRange.getEndOffset() >= injected.getTextLength())) continue;
                range = TextRange.create((int)(range.getStartOffset() + injectedRange.getStartOffset() - initialInjectedRange.getStartOffset()), (int)(range.getEndOffset() + initialInjectedRange.getEndOffset() - injectedRange.getEndOffset()));
            }
        }
        if (!this.mySettings.FORMATTER_TAGS_ENABLED) {
            for (PreFormatProcessor processor : PreFormatProcessor.EP_NAME.getExtensionList()) {
                if (!processor.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                result = processor.process(node, result);
            }
        } else {
            result = this.preprocessEnabledRanges(node, result);
        }
        return result;
    }

    private TextRange preprocessEnabledRanges(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            CodeFormatterFacade.$$$reportNull$$$0(12);
        }
        if (range == null) {
            CodeFormatterFacade.$$$reportNull$$$0(13);
        }
        TextRange result = TextRange.create((int)range.getStartOffset(), (int)range.getEndOffset());
        List<TextRange> enabledRanges = this.myTagHandler.getEnabledRanges(node, result);
        int delta = 0;
        for (TextRange enabledRange : enabledRanges) {
            enabledRange = enabledRange.shiftRight(delta);
            for (PreFormatProcessor processor : PreFormatProcessor.EP_NAME.getExtensionList()) {
                if (!processor.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                TextRange processedRange = processor.process(node, enabledRange);
                delta += processedRange.getLength() - enabledRange.getLength();
            }
        }
        result = result.grown(delta);
        return result;
    }

    public static boolean shouldDelegateToTopLevel(@NotNull PsiFile file) {
        if (file == null) {
            CodeFormatterFacade.$$$reportNull$$$0(14);
        }
        for (InjectedFormattingOptionsProvider provider : InjectedFormattingOptionsProvider.EP_NAME.getExtensionList()) {
            Boolean result = provider.shouldDelegateToTopLevel(file);
            if (result == null) continue;
            return result;
        }
        return true;
    }

    static boolean shouldDelegateToTopLevel(Document document, @NotNull PsiFile file) {
        if (file == null) {
            CodeFormatterFacade.$$$reportNull$$$0(15);
        }
        return document instanceof DocumentWindow && CodeFormatterFacade.shouldDelegateToTopLevel(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingData";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptions";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledRanges";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invokePostponedFormatting";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findContainingNode";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "preprocess";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnabledRanges";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldDelegateToTopLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

