/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.diagnostic.PluginException;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CompositeLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class CoreCodeStyleUtil {
    private static final Logger LOG = Logger.getInstance(CoreCodeStyleUtil.class);
    private static final ThreadLocal<ProcessingUnderProgressInfo> SEQUENTIAL_PROCESSING_ALLOWED = ThreadLocal.withInitial(() -> new ProcessingUnderProgressInfo());

    private CoreCodeStyleUtil() {
    }

    public static PsiElement postProcessElement(@NotNull PsiFile file, @NotNull PsiElement element, boolean isWhitespaceOnly) {
        List<TextRange> textRanges;
        if (file == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(1);
        }
        CodeStyleSettings settingsForFile = CodeStyle.getSettings((PsiFile)file);
        if (settingsForFile.FORMATTER_TAGS_ENABLED) {
            FormatterTagHandler tagHandler = new FormatterTagHandler(settingsForFile);
            textRanges = tagHandler.getEnabledRanges((ASTNode)file.getNode(), file.getTextRange());
        } else {
            textRanges = Collections.singletonList(element.getTextRange());
        }
        for (TextRange range : textRanges) {
            if (range.contains(element.getTextRange())) {
                PsiElement currElement = element;
                for (PostFormatProcessor postFormatProcessor : CoreCodeStyleUtil.getPostProcessors(isWhitespaceOnly)) {
                    if (currElement == null) break;
                    currElement = CoreCodeStyleUtil.processElementOrFail(postFormatProcessor, currElement, settingsForFile);
                }
                return currElement;
            }
            if (!range.intersects(element.getTextRange())) continue;
            CoreCodeStyleUtil.postProcessRange(file, element.getTextRange().intersection(range), settingsForFile, isWhitespaceOnly);
        }
        return element;
    }

    @Nullable
    private static PsiElement processElementOrFail(@NotNull PostFormatProcessor processor, @NotNull PsiElement element, @NotNull CodeStyleSettings settings) {
        if (processor == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(2);
        }
        if (element == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(4);
        }
        PsiElement result = element;
        try {
            result = processor.processElement(result, settings);
            if (!result.isValid()) {
                LOG.error((Throwable)new RuntimeExceptionWithAttachments(String.format("PSI crash detected: processor=%s, result=%s", processor, result), new Attachment[]{new Attachment("text", result.getText())}));
                return null;
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error((Throwable)PluginException.createByClass((Throwable)e, (Class)processor.getClass()));
        }
        return result;
    }

    private static @Unmodifiable Collection<PostFormatProcessor> getPostProcessors(boolean isWhitespaceOnly) {
        if (isWhitespaceOnly) {
            return ContainerUtil.filter((Collection)PostFormatProcessor.EP_NAME.getExtensionList(), processor -> processor.isWhitespaceOnly());
        }
        return PostFormatProcessor.EP_NAME.getExtensionList();
    }

    public static List<RangeFormatInfo> getRangeFormatInfoList(@NotNull PsiFile file, @NotNull FormattingRangesInfo ranges) {
        if (file == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(5);
        }
        if (ranges == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(6);
        }
        ArrayList<RangeFormatInfo> infos = new ArrayList<RangeFormatInfo>();
        for (TextRange range : ranges.getTextRanges()) {
            infos.add(new RangeFormatInfo(file, range));
        }
        return infos;
    }

    public static void postProcessRanges(@NotNull List<? extends RangeFormatInfo> rangeFormatInfoList, @NotNull Consumer<? super TextRange> postProcessFormatter) {
        if (rangeFormatInfoList == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(7);
        }
        if (postProcessFormatter == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(8);
        }
        for (RangeFormatInfo rangeFormatInfo : rangeFormatInfoList) {
            int startOffset = rangeFormatInfo.getStartOffset();
            int endOffset = rangeFormatInfo.getEndOffset();
            if (startOffset >= 0 && endOffset >= 0 && endOffset > startOffset) {
                postProcessFormatter.accept((TextRange)new TextRange(startOffset, endOffset));
            }
            rangeFormatInfo.disposePointers();
        }
    }

    public static void postProcessText(@NotNull PsiFile file, @NotNull TextRange textRange, boolean isWhitespaceOnly) {
        if (file == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(9);
        }
        if (textRange == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(10);
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)file);
        if (!CoreCodeStyleUtil.getSettings((PsiFile)file).FORMATTER_TAGS_ENABLED) {
            CoreCodeStyleUtil.postProcessRange(file, textRange, settings, isWhitespaceOnly);
        } else {
            CoreCodeStyleUtil.postProcessEnabledRanges(file, textRange, settings, isWhitespaceOnly);
        }
    }

    private static void postProcessEnabledRanges(@NotNull PsiFile file, @NotNull TextRange range, CodeStyleSettings settings, boolean isWhitespaceOnly) {
        if (file == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(11);
        }
        if (range == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(12);
        }
        List<TextRange> enabledRanges = new FormatterTagHandler(CoreCodeStyleUtil.getSettings(file)).getEnabledRanges((ASTNode)file.getNode(), range);
        int delta = 0;
        for (TextRange enabledRange : enabledRanges) {
            enabledRange = enabledRange.shiftRight(delta);
            TextRange processedRange = CoreCodeStyleUtil.postProcessRange(file, enabledRange, settings, isWhitespaceOnly);
            delta += processedRange.getLength() - enabledRange.getLength();
        }
    }

    private static TextRange postProcessRange(@NotNull PsiFile file, @NotNull TextRange textRange, @NotNull CodeStyleSettings settings, boolean isWhitespaceOnly) {
        if (file == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(13);
        }
        if (textRange == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(14);
        }
        if (settings == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(15);
        }
        TextRange currentRange = textRange;
        for (PostFormatProcessor myPostFormatProcessor : CoreCodeStyleUtil.getPostProcessors(isWhitespaceOnly)) {
            currentRange = myPostFormatProcessor.processText(file, currentRange, settings);
        }
        return currentRange;
    }

    @Nullable
    public static PsiElement findElementInTreeWithFormatterEnabled(PsiFile file, int offset) {
        PsiElement bottommost = file.findElementAt(offset);
        if (bottommost != null && LanguageFormatting.INSTANCE.forContext(bottommost) != null) {
            return bottommost;
        }
        Language fileLang = file.getLanguage();
        if (fileLang instanceof CompositeLanguage) {
            return file.getViewProvider().findElementAt(offset, fileLang);
        }
        return bottommost;
    }

    @ApiStatus.Internal
    public static void setSequentialProcessingAllowed(boolean allowed) {
        ProcessingUnderProgressInfo info = SEQUENTIAL_PROCESSING_ALLOWED.get();
        if (allowed) {
            info.decrement();
        } else {
            info.increment();
        }
    }

    static boolean isSequentialProcessingAllowed() {
        return SEQUENTIAL_PROCESSING_ALLOWED.get().isAllowed();
    }

    private static CodeStyleSettings getSettings(@NotNull PsiFile file) {
        if (file == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(16);
        }
        return CodeStyle.getSettings((PsiFile)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeFormatInfoList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postProcessFormatter";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CoreCodeStyleUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementOrFail";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getRangeFormatInfoList";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessRanges";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessEnabledRanges";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessRange";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class RangeFormatInfo {
        private final PsiFile myFile;
        private final SmartPsiElementPointer<?> startPointer;
        private final SmartPsiElementPointer<?> endPointer;
        private final boolean fromStart;
        private final boolean toEnd;

        RangeFormatInfo(@NotNull PsiFile file, @NotNull TextRange range) {
            if (file == null) {
                RangeFormatInfo.$$$reportNull$$$0(0);
            }
            if (range == null) {
                RangeFormatInfo.$$$reportNull$$$0(1);
            }
            this.myFile = file;
            this.fromStart = range.getStartOffset() == 0;
            this.toEnd = range.getEndOffset() == file.getTextLength();
            this.startPointer = this.fromStart ? null : this.createPsiPointer(range.getStartOffset());
            this.endPointer = this.toEnd ? null : this.createPsiPointer(range.getEndOffset());
        }

        @Nullable
        private SmartPsiElementPointer<?> createPsiPointer(int offset) {
            PsiElement element = CoreCodeStyleUtil.findElementInTreeWithFormatterEnabled(this.myFile, offset);
            if (element != null) {
                if (!element.isValid()) {
                    LOG.error("Invalid element " + String.valueOf(element) + "; file: " + this.myFile.getName());
                }
                return SmartPointerManager.getInstance((Project)this.myFile.getProject()).createSmartPsiElementPointer(element);
            }
            return null;
        }

        private int getStartOffset() {
            if (this.fromStart) {
                return 0;
            }
            TextRange range = RangeFormatInfo.getElementRange(this.startPointer);
            return range != null ? range.getStartOffset() : -1;
        }

        private int getEndOffset() {
            if (this.toEnd) {
                return this.myFile.getTextLength();
            }
            TextRange range = RangeFormatInfo.getElementRange(this.endPointer);
            return range != null ? range.getEndOffset() : -1;
        }

        @Nullable
        private static TextRange getElementRange(@Nullable SmartPsiElementPointer<?> pointer) {
            return pointer != null ? (TextRange)ObjectUtils.doIfNotNull((Object)pointer.getElement(), element -> element.getTextRange()) : null;
        }

        private void disposePointers() {
            SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.myFile.getProject());
            if (this.startPointer != null) {
                pointerManager.removePointer(this.startPointer);
            }
            if (this.endPointer != null) {
                pointerManager.removePointer(this.endPointer);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/source/codeStyle/CoreCodeStyleUtil$RangeFormatInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ProcessingUnderProgressInfo {
        private static final long DURATION_TIME = TimeUnit.SECONDS.toMillis(5L);
        private int myCount;
        private long myEndTime;

        private ProcessingUnderProgressInfo() {
        }

        public void increment() {
            if (this.myCount > 0 && System.currentTimeMillis() > this.myEndTime) {
                this.myCount = 0;
            }
            ++this.myCount;
            this.myEndTime = System.currentTimeMillis() + DURATION_TIME;
        }

        public void decrement() {
            if (this.myCount <= 0) {
                return;
            }
            --this.myCount;
        }

        public boolean isAllowed() {
            return this.myCount <= 0 || System.currentTimeMillis() >= this.myEndTime;
        }
    }
}

