/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpacingBuilder {
    private static final Logger LOG = Logger.getInstance(SpacingBuilder.class);
    private final CommonCodeStyleSettings myCodeStyleSettings;
    private final List<SpacingRule> myRules;

    public SpacingBuilder(@NotNull CodeStyleSettings codeStyleSettings, @NotNull Language language) {
        if (codeStyleSettings == null) {
            SpacingBuilder.$$$reportNull$$$0(0);
        }
        if (language == null) {
            SpacingBuilder.$$$reportNull$$$0(1);
        }
        this.myRules = new ArrayList<SpacingRule>();
        this.myCodeStyleSettings = codeStyleSettings.getCommonSettings(language);
    }

    public SpacingBuilder(@NotNull CommonCodeStyleSettings languageCodeStyleSettings) {
        if (languageCodeStyleSettings == null) {
            SpacingBuilder.$$$reportNull$$$0(2);
        }
        this.myRules = new ArrayList<SpacingRule>();
        assert (!Language.ANY.equals(languageCodeStyleSettings.getLanguage())) : "Only language code style settings are accepted (getLanguage() != null)";
        this.myCodeStyleSettings = languageCodeStyleSettings;
    }

    public RuleBuilder after(IElementType elementType) {
        return new RuleBuilder(new RuleCondition(null, TokenSet.create((IElementType[])new IElementType[]{elementType}), null));
    }

    public RuleBuilder after(TokenSet tokenSet) {
        return new RuleBuilder(new RuleCondition(null, tokenSet, null));
    }

    public RuleBuilder afterInside(IElementType elementType, IElementType parentType) {
        return new RuleBuilder(new RuleCondition(TokenSet.create((IElementType[])new IElementType[]{parentType}), TokenSet.create((IElementType[])new IElementType[]{elementType}), null));
    }

    public RuleBuilder afterInside(IElementType elementType, TokenSet parentType) {
        return new RuleBuilder(new RuleCondition(parentType, TokenSet.create((IElementType[])new IElementType[]{elementType}), null));
    }

    public RuleBuilder afterInside(TokenSet tokenSet, IElementType parentType) {
        return new RuleBuilder(new RuleCondition(TokenSet.create((IElementType[])new IElementType[]{parentType}), tokenSet, null));
    }

    public RuleBuilder afterInside(TokenSet tokenSet, TokenSet parentType) {
        return new RuleBuilder(new RuleCondition(parentType, tokenSet, null));
    }

    public RuleBuilder before(IElementType elementType) {
        return this.before(TokenSet.create((IElementType[])new IElementType[]{elementType}));
    }

    public RuleBuilder before(TokenSet tokenSet) {
        return new RuleBuilder(new RuleCondition(null, null, tokenSet));
    }

    public RuleBuilder beforeInside(TokenSet tokenSet, IElementType parentType) {
        return new RuleBuilder(new RuleCondition(TokenSet.create((IElementType[])new IElementType[]{parentType}), null, tokenSet));
    }

    public RuleBuilder beforeInside(IElementType elementType, IElementType parentType) {
        return new RuleBuilder(new RuleCondition(TokenSet.create((IElementType[])new IElementType[]{parentType}), null, TokenSet.create((IElementType[])new IElementType[]{elementType})));
    }

    public RuleBuilder beforeInside(IElementType elementType, TokenSet parentTypes) {
        return new RuleBuilder(new RuleCondition(parentTypes, null, TokenSet.create((IElementType[])new IElementType[]{elementType})));
    }

    public RuleBuilder between(IElementType left, IElementType right) {
        return new RuleBuilder(new RuleCondition(null, TokenSet.create((IElementType[])new IElementType[]{left}), TokenSet.create((IElementType[])new IElementType[]{right})));
    }

    public RuleBuilder between(IElementType left, TokenSet rightSet) {
        return new RuleBuilder(new RuleCondition(null, TokenSet.create((IElementType[])new IElementType[]{left}), rightSet));
    }

    public RuleBuilder between(TokenSet leftSet, IElementType right) {
        return new RuleBuilder(new RuleCondition(null, leftSet, TokenSet.create((IElementType[])new IElementType[]{right})));
    }

    public RuleBuilder between(TokenSet leftType, TokenSet rightType) {
        return new RuleBuilder(new RuleCondition(null, leftType, rightType));
    }

    public RuleBuilder betweenInside(IElementType leftType, IElementType rightType, IElementType parentType) {
        return new RuleBuilder(new RuleCondition(TokenSet.create((IElementType[])new IElementType[]{parentType}), TokenSet.create((IElementType[])new IElementType[]{leftType}), TokenSet.create((IElementType[])new IElementType[]{rightType})));
    }

    public RuleBuilder betweenInside(TokenSet leftSet, TokenSet rightSet, IElementType parentType) {
        return new RuleBuilder(new RuleCondition(TokenSet.create((IElementType[])new IElementType[]{parentType}), leftSet, rightSet));
    }

    public RuleBuilder withinPair(IElementType pairFirst, IElementType pairSecond) {
        RuleCondition before = new RuleCondition(null, TokenSet.create((IElementType[])new IElementType[]{pairFirst}), null);
        RuleCondition after = new RuleCondition(null, null, TokenSet.create((IElementType[])new IElementType[]{pairSecond}));
        return new RuleBuilder(before, after);
    }

    public RuleBuilder withinPairInside(IElementType pairFirst, IElementType pairSecond, IElementType parent) {
        TokenSet parentSet = TokenSet.create((IElementType[])new IElementType[]{parent});
        RuleCondition before = new RuleCondition(parentSet, TokenSet.create((IElementType[])new IElementType[]{pairFirst}), null);
        RuleCondition after = new RuleCondition(parentSet, null, TokenSet.create((IElementType[])new IElementType[]{pairSecond}));
        return new RuleBuilder(before, after);
    }

    public RuleBuilder around(IElementType elementType) {
        return this.around(TokenSet.create((IElementType[])new IElementType[]{elementType}));
    }

    public RuleBuilder around(TokenSet tokenSet) {
        RuleCondition before = new RuleCondition(null, null, tokenSet);
        RuleCondition after = new RuleCondition(null, tokenSet, null);
        return new RuleBuilder(before, after);
    }

    public RuleBuilder aroundInside(TokenSet tokenSet, TokenSet parent) {
        RuleCondition before = new RuleCondition(parent, null, tokenSet);
        RuleCondition after = new RuleCondition(parent, tokenSet, null);
        return new RuleBuilder(before, after);
    }

    public RuleBuilder aroundInside(TokenSet tokenSet, IElementType parent) {
        RuleCondition before = new RuleCondition(TokenSet.create((IElementType[])new IElementType[]{parent}), null, tokenSet);
        RuleCondition after = new RuleCondition(TokenSet.create((IElementType[])new IElementType[]{parent}), tokenSet, null);
        return new RuleBuilder(before, after);
    }

    public RuleBuilder aroundInside(IElementType token, IElementType parent) {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{token});
        RuleCondition before = new RuleCondition(TokenSet.create((IElementType[])new IElementType[]{parent}), null, tokenSet);
        RuleCondition after = new RuleCondition(TokenSet.create((IElementType[])new IElementType[]{parent}), tokenSet, null);
        return new RuleBuilder(before, after);
    }

    public RuleBuilder aroundInside(IElementType token, TokenSet parent) {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{token});
        RuleCondition before = new RuleCondition(parent, null, tokenSet);
        RuleCondition after = new RuleCondition(parent, tokenSet, null);
        return new RuleBuilder(before, after);
    }

    public SpacingBuilder append(SpacingBuilder builder) {
        this.myRules.addAll(builder.myRules);
        return this;
    }

    @Contract(value="_,null,_,_->null; _,_,null,_->null; _,_,_,null->null")
    @Nullable
    public Spacing getSpacing(@NotNull Block parentBlock, @Nullable IElementType parentType, @Nullable IElementType child1Type, @Nullable IElementType child2Type) {
        if (parentBlock == null) {
            SpacingBuilder.$$$reportNull$$$0(3);
        }
        for (SpacingRule rule : this.myRules) {
            if (!rule.matches(parentType, child1Type, child2Type)) continue;
            return rule.createSpacing(parentBlock.getTextRange());
        }
        return null;
    }

    @Contract(value="null,_,_->null; _,null,_->null; _,_,null->null")
    @Nullable
    public Spacing getSpacing(@Nullable Block parent, @Nullable Block child1, @Nullable Block child2) {
        if (!(parent instanceof ASTBlock && child1 instanceof ASTBlock && child2 instanceof ASTBlock)) {
            return null;
        }
        for (SpacingRule rule : this.myRules) {
            if (!rule.matches((ASTBlock)parent, (ASTBlock)child1, (ASTBlock)child2)) continue;
            return rule.createSpacing(parent.getTextRange());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageCodeStyleSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/SpacingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public final class RuleBuilder {
        RuleCondition[] myConditions;

        private RuleBuilder(RuleCondition ... conditions) {
            this.myConditions = conditions;
        }

        public SpacingBuilder none() {
            return this.spaces(0);
        }

        public SpacingBuilder spaceIf(boolean option) {
            return this.spaceIf(option, false);
        }

        public SpacingBuilder spaceIf(boolean option, boolean useParentDependentLFSpacing) {
            return this.spaces(option ? 1 : 0, useParentDependentLFSpacing);
        }

        public SpacingBuilder spaces(int count) {
            return this.spaces(count, false);
        }

        public SpacingBuilder spaces(int count, boolean useParentDependentLFSpacing) {
            if (useParentDependentLFSpacing) {
                return this.parentDependentLFSpacing(count, count, SpacingBuilder.this.myCodeStyleSettings.KEEP_LINE_BREAKS, SpacingBuilder.this.myCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE);
            }
            return this.spacing(count, count, 0, SpacingBuilder.this.myCodeStyleSettings.KEEP_LINE_BREAKS, SpacingBuilder.this.myCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE);
        }

        public SpacingBuilder blankLines(int count) {
            int blankLines = count + 1;
            for (RuleCondition condition : this.myConditions) {
                SpacingBuilder.this.myRules.add(new SpacingRule(condition, 0, 0, blankLines, SpacingBuilder.this.myCodeStyleSettings.KEEP_LINE_BREAKS, SpacingBuilder.this.myCodeStyleSettings.KEEP_BLANK_LINES_IN_DECLARATIONS));
            }
            return SpacingBuilder.this;
        }

        public SpacingBuilder lineBreakInCodeIf(boolean option) {
            return option ? this.lineBreakInCode() : SpacingBuilder.this;
        }

        public SpacingBuilder lineBreakInCode() {
            for (RuleCondition condition : this.myConditions) {
                SpacingBuilder.this.myRules.add(new SpacingRule(condition, 1, 0, 1, SpacingBuilder.this.myCodeStyleSettings.KEEP_LINE_BREAKS, SpacingBuilder.this.myCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE));
            }
            return SpacingBuilder.this;
        }

        public SpacingBuilder lineBreakOrForceSpace(boolean lbOption, boolean spaceOption) {
            if (lbOption) {
                return this.lineBreakInCode();
            }
            int count = spaceOption ? 1 : 0;
            return this.spacing(count, count, 0, false, 0);
        }

        public SpacingBuilder spacing(int minSpaces, int maxSpaces, int minLF, boolean keepLineBreaks, int keepBlankLines) {
            for (RuleCondition condition : this.myConditions) {
                SpacingBuilder.this.myRules.add(new SpacingRule(condition, minSpaces, maxSpaces, minLF, keepLineBreaks, keepBlankLines));
            }
            return SpacingBuilder.this;
        }

        public SpacingBuilder parentDependentLFSpacing(int minSpaces, int maxSpaces, boolean keepLineBreaks, int keepBlankLines) {
            for (RuleCondition condition : this.myConditions) {
                SpacingBuilder.this.myRules.add(new DependentLFSpacingRule(condition, minSpaces, maxSpaces, keepLineBreaks, keepBlankLines));
            }
            return SpacingBuilder.this;
        }
    }

    private static final class RuleCondition {
        private final TokenSet myParentType;
        private final TokenSet myChild1Type;
        private final TokenSet myChild2Type;

        private RuleCondition(TokenSet parentType, TokenSet child1Type, TokenSet child2Type) {
            this.myParentType = parentType;
            this.myChild1Type = child1Type;
            this.myChild2Type = child2Type;
        }

        private boolean matches(@NotNull IElementType parentType, @NotNull IElementType firstChildType, @NotNull IElementType secondChildType) {
            if (parentType == null) {
                RuleCondition.$$$reportNull$$$0(0);
            }
            if (firstChildType == null) {
                RuleCondition.$$$reportNull$$$0(1);
            }
            if (secondChildType == null) {
                RuleCondition.$$$reportNull$$$0(2);
            }
            return !(this.myParentType != null && !this.myParentType.contains(parentType) || this.myChild1Type != null && !this.myChild1Type.contains(firstChildType) || this.myChild2Type != null && !this.myChild2Type.contains(secondChildType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstChildType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "secondChildType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/formatting/SpacingBuilder$RuleCondition";
            objectArray[2] = "matches";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SpacingRule {
        protected final RuleCondition myRuleCondition;
        protected final int myMinSpaces;
        protected final int myMaxSpaces;
        protected final int myMinLF;
        protected final boolean myKeepLineBreaks;
        protected final int myKeepBlankLines;

        private SpacingRule(@NotNull RuleCondition condition, int minSpaces, int maxSpaces, int minLF, boolean keepLineBreaks, int keepBlankLines) {
            if (condition == null) {
                SpacingRule.$$$reportNull$$$0(0);
            }
            this.myRuleCondition = condition;
            this.myMinSpaces = minSpaces;
            this.myMaxSpaces = maxSpaces;
            this.myMinLF = minLF;
            this.myKeepLineBreaks = keepLineBreaks;
            this.myKeepBlankLines = keepBlankLines;
        }

        @Contract(value="null,_,_->false; _,null,_->false; _,_,null->false")
        public boolean matches(@Nullable IElementType parentType, @Nullable IElementType childType1, @Nullable IElementType childType2) {
            return parentType != null && childType1 != null && childType2 != null && this.myRuleCondition.matches(parentType, childType1, childType2);
        }

        @Contract(value="null,_,_->false; _,null,_->false; _,_,null->false")
        public boolean matches(@Nullable ASTBlock parentBlock, @Nullable ASTBlock childBlock1, @Nullable ASTBlock childBlock2) {
            return this.matches(ASTBlock.getElementType(parentBlock), ASTBlock.getElementType(childBlock1), ASTBlock.getElementType(childBlock2));
        }

        @NotNull
        Spacing createSpacing(@NotNull TextRange parentRange) {
            if (parentRange == null) {
                SpacingRule.$$$reportNull$$$0(1);
            }
            Spacing spacing = Spacing.createSpacing(this.myMinSpaces, this.myMaxSpaces, this.myMinLF, this.myKeepLineBreaks, this.myKeepBlankLines);
            if (spacing == null) {
                SpacingRule.$$$reportNull$$$0(2);
            }
            return spacing;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/formatting/SpacingBuilder$SpacingRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/formatting/SpacingBuilder$SpacingRule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSpacing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createSpacing";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class DependentLFSpacingRule
    extends SpacingRule {
        DependentLFSpacingRule(@NotNull RuleCondition condition, int minSpaces, int maxSpaces, boolean keepLineBreaks, int keepBlankLines) {
            if (condition == null) {
                DependentLFSpacingRule.$$$reportNull$$$0(0);
            }
            super(condition, minSpaces, maxSpaces, 1, keepLineBreaks, keepBlankLines);
        }

        @Override
        @NotNull
        Spacing createSpacing(@NotNull TextRange parentRange) {
            if (parentRange == null) {
                DependentLFSpacingRule.$$$reportNull$$$0(1);
            }
            Spacing spacing = Spacing.createDependentLFSpacing(this.myMinSpaces, this.myMaxSpaces, parentRange, this.myKeepLineBreaks, this.myKeepBlankLines);
            if (spacing == null) {
                DependentLFSpacingRule.$$$reportNull$$$0(2);
            }
            return spacing;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/formatting/SpacingBuilder$DependentLFSpacingRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/formatting/SpacingBuilder$DependentLFSpacingRule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSpacing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createSpacing";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

