/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRegexpArrangementMatcher
implements ArrangementEntryMatcher {
    @NotNull
    private final String myPattern;
    @Nullable
    private final Pattern myCompiledPattern;

    public AbstractRegexpArrangementMatcher(@NotNull String pattern) {
        if (pattern == null) {
            AbstractRegexpArrangementMatcher.$$$reportNull$$$0(0);
        }
        this.myPattern = pattern;
        Pattern p = null;
        try {
            p = Pattern.compile(pattern);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myCompiledPattern = p;
    }

    @Override
    public boolean isMatched(@NotNull ArrangementEntry entry) {
        if (entry == null) {
            AbstractRegexpArrangementMatcher.$$$reportNull$$$0(1);
        }
        if (this.myCompiledPattern == null) {
            return false;
        }
        String text = this.getTextToMatch(entry);
        return text != null && this.myCompiledPattern.matcher(text).matches();
    }

    @Nullable
    protected abstract String getTextToMatch(@NotNull ArrangementEntry var1);

    @NotNull
    public String getPattern() {
        String string = this.myPattern;
        if (string == null) {
            AbstractRegexpArrangementMatcher.$$$reportNull$$$0(2);
        }
        return string;
    }

    public int hashCode() {
        return this.myPattern.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRegexpArrangementMatcher that = (AbstractRegexpArrangementMatcher)o;
        return this.myPattern.equals(that.myPattern);
    }

    public String toString() {
        return String.format("regexp '%s'", this.myPattern);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/match/AbstractRegexpArrangementMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/match/AbstractRegexpArrangementMatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMatched";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

