/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.DefaultCodeStyleSettingsFacade;
import com.intellij.application.options.codeStyle.cache.CodeStyleCachingService;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.AppCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsFacade;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.ProjectCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.joinLines.JoinedLinesSpacingCalculator;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProviderEP;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class CodeStyle {
    public static final Logger LOG = Logger.getInstance(CodeStyle.class);

    private CodeStyle() {
    }

    @NotNull
    public static CodeStyleSettings getDefaultSettings() {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance().getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(0);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull Project project) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(1);
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance(project).getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(2);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettings getProjectOrDefaultSettings(@Nullable Project project) {
        return project != null ? CodeStyle.getSettings(project) : CodeStyle.getDefaultSettings();
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull Project project, @NotNull VirtualFile file) {
        CodeStyleSettings localOrTempSettings;
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(3);
        }
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(4);
        }
        if ((localOrTempSettings = CodeStyle.getLocalOrTemporarySettings(project)) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("localOrTemp settings for " + file.getName());
            }
            CodeStyleSettings codeStyleSettings = localOrTempSettings;
            if (codeStyleSettings == null) {
                CodeStyle.$$$reportNull$$$0(5);
            }
            return codeStyleSettings;
        }
        return CodeStyle.getCachedOrProjectSettings(project, file);
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull PsiFile file) {
        Project project;
        CodeStyleSettings localOrTempSettings;
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(6);
        }
        if ((localOrTempSettings = CodeStyle.getLocalOrTemporarySettings(project = file.getProject())) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("localOrTemp settings for " + file.getName());
            }
            CodeStyleSettings codeStyleSettings = localOrTempSettings;
            if (codeStyleSettings == null) {
                CodeStyle.$$$reportNull$$$0(7);
            }
            return codeStyleSettings;
        }
        PsiFile topLevel = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file);
        PsiFile settingsFile = CodeStyle.getSettingsPsi(topLevel != null ? topLevel : file);
        if (settingsFile == null) {
            return CodeStyle.getSettings(project);
        }
        VirtualFile virtualFile = settingsFile.getVirtualFile();
        if (virtualFile == null) {
            return CodeStyle.getSettings(project);
        }
        return CodeStyle.getCachedOrProjectSettings(project, virtualFile);
    }

    @NotNull
    private static CodeStyleSettings getCachedOrProjectSettings(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(8);
        }
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(9);
        }
        CodeStyleSettings cachedSettings = CodeStyleCachingService.getInstance(project).tryGetSettings(file);
        if (LOG.isDebugEnabled()) {
            LOG.debug((cachedSettings != null ? "cached" : "project") + " settings for " + file.getName());
        }
        return cachedSettings != null ? cachedSettings : CodeStyle.getSettings(project);
    }

    @Nullable
    private static CodeStyleSettings getLocalOrTemporarySettings(@NotNull Project project) {
        CodeStyleSettingsManager settingsManager;
        CodeStyleSettings localSettings;
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(10);
        }
        if ((localSettings = (settingsManager = CodeStyleSettingsManager.getInstance(project)).getLocalSettings()) != null) {
            return localSettings;
        }
        CodeStyleSettings tempSettings = settingsManager.getTemporarySettings();
        if (tempSettings != null) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.warn("Temporary settings used in production. Please use CodeStyle#runWithLocalSettings instead.");
            }
            return tempSettings;
        }
        return null;
    }

    @Nullable
    public static PsiFile getSettingsPsi(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(11);
        }
        if (CodeStyle.hasLocalVirtualFile(file)) {
            return file;
        }
        PsiFile originalFile = (PsiFile)file.getUserData(PsiFileFactory.ORIGINAL_FILE);
        if (originalFile != null) {
            return CodeStyle.getSettingsPsi(originalFile);
        }
        return null;
    }

    private static boolean hasLocalVirtualFile(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(12);
        }
        return (virtualFile = file.getVirtualFile()) != null && virtualFile.isInLocalFileSystem();
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull Project project, @NotNull Document document) {
        PsiFile file;
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(13);
        }
        if (document == null) {
            CodeStyle.$$$reportNull$$$0(14);
        }
        return (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) != null ? CodeStyle.getSettings(file) : CodeStyle.getSettings(project);
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull Editor editor) {
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(15);
        }
        Project project = editor.getProject();
        VirtualFile file = editor.getVirtualFile();
        if (file != null && project != null) {
            return CodeStyle.getSettings(project, file);
        }
        return CodeStyle.getDefaultSettings();
    }

    @Nullable
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull Editor editor) {
        PsiFile file;
        Project project;
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(16);
        }
        if ((project = editor.getProject()) != null && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
            return CodeStyle.getLanguageSettings(file);
        }
        return null;
    }

    @NotNull
    public static <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull PsiFile file, @NotNull Class<T> customSettingsClass) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(17);
        }
        if (customSettingsClass == null) {
            CodeStyle.$$$reportNull$$$0(18);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        T t = rootSettings.getCustomSettings(customSettingsClass);
        if (t == null) {
            CodeStyle.$$$reportNull$$$0(19);
        }
        return t;
    }

    @NotNull
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(20);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        CommonCodeStyleSettings commonCodeStyleSettings = rootSettings.getCommonSettings(file.getLanguage());
        if (commonCodeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(21);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull PsiFile file, @NotNull Language language) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(22);
        }
        if (language == null) {
            CodeStyle.$$$reportNull$$$0(23);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        CommonCodeStyleSettings commonCodeStyleSettings = rootSettings.getCommonSettings(language);
        if (commonCodeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(24);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(25);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        CommonCodeStyleSettings.IndentOptions indentOptions = rootSettings.getIndentOptionsByFile(file);
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(26);
        }
        return indentOptions;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(27);
        }
        if (virtualFile == null) {
            CodeStyle.$$$reportNull$$$0(28);
        }
        CodeStyleSettings rootSetting = CodeStyle.getSettings(project, virtualFile);
        CommonCodeStyleSettings.IndentOptions indentOptions = rootSetting.getIndentOptionsByFile(project, virtualFile, null);
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(29);
        }
        return indentOptions;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull Project project, @NotNull Document document) {
        PsiFile file;
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(30);
        }
        if (document == null) {
            CodeStyle.$$$reportNull$$$0(31);
        }
        if ((file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) != null) {
            return CodeStyle.getIndentOptions(file);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings(project).getIndentOptions((FileType)null);
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(32);
        }
        return indentOptions;
    }

    public static int getIndentSize(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(33);
        }
        return CodeStyle.getIndentOptions((PsiFile)file).INDENT_SIZE;
    }

    @TestOnly
    public static void setTemporarySettings(@Nullable Project project, @NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyle.$$$reportNull$$$0(34);
        }
        CodeStyleSettingsManager.getInstance(project).setTemporarySettings(settings);
    }

    @TestOnly
    public static void dropTemporarySettings(@Nullable Project project) {
        CodeStyleSettingsManager codeStyleSettingsManager = project == null || project.isDefault() ? (CodeStyleSettingsManager)ApplicationManager.getApplication().getServiceIfCreated(AppCodeStyleSettingsManager.class) : (CodeStyleSettingsManager)project.getServiceIfCreated(ProjectCodeStyleSettingsManager.class);
        if (codeStyleSettingsManager != null) {
            codeStyleSettingsManager.dropTemporarySettings();
        }
    }

    public static void runWithLocalSettings(@NotNull Project project, @NotNull CodeStyleSettings localSettings, @NotNull Runnable runnable) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(35);
        }
        if (localSettings == null) {
            CodeStyle.$$$reportNull$$$0(36);
        }
        if (runnable == null) {
            CodeStyle.$$$reportNull$$$0(37);
        }
        CodeStyleSettingsManager.getInstance(project).runWithLocalSettings(localSettings, runnable);
    }

    public static void runWithLocalSettings(@NotNull Project project, @NotNull CodeStyleSettings baseSettings, @NotNull @NotNull Consumer<? super @NotNull CodeStyleSettings> localSettingsConsumer) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(38);
        }
        if (baseSettings == null) {
            CodeStyle.$$$reportNull$$$0(39);
        }
        if (localSettingsConsumer == null) {
            CodeStyle.$$$reportNull$$$0(40);
        }
        CodeStyleSettingsManager.getInstance(project).runWithLocalSettings(baseSettings, localSettingsConsumer);
    }

    public static <T> T computeWithLocalSettings(@NotNull Project project, @NotNull CodeStyleSettings baseSettings, @NotNull @NotNull Function<? super @NotNull CodeStyleSettings, T> localSettingsFunction) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(41);
        }
        if (baseSettings == null) {
            CodeStyle.$$$reportNull$$$0(42);
        }
        if (localSettingsFunction == null) {
            CodeStyle.$$$reportNull$$$0(43);
        }
        return CodeStyleSettingsManager.getInstance(project).computeWithLocalSettings(baseSettings, localSettingsFunction);
    }

    @TestOnly
    public static void doWithTemporarySettings(@NotNull Project project, @NotNull CodeStyleSettings tempSettings, @NotNull Runnable runnable) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(44);
        }
        if (tempSettings == null) {
            CodeStyle.$$$reportNull$$$0(45);
        }
        if (runnable == null) {
            CodeStyle.$$$reportNull$$$0(46);
        }
        CodeStyleSettingsManager.getInstance(project).doWithTemporarySettings(tempSettings, runnable);
    }

    @TestOnly
    public static void doWithTemporarySettings(@NotNull Project project, @NotNull CodeStyleSettings baseSettings, @NotNull Consumer<? super CodeStyleSettings> tempSettingsConsumer) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(47);
        }
        if (baseSettings == null) {
            CodeStyle.$$$reportNull$$$0(48);
        }
        if (tempSettingsConsumer == null) {
            CodeStyle.$$$reportNull$$$0(49);
        }
        CodeStyleSettingsManager.getInstance(project).doWithTemporarySettings(baseSettings, tempSettingsConsumer);
    }

    public static boolean usesOwnSettings(@NotNull Project project) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(50);
        }
        return CodeStyleSettingsManager.getInstance((Project)project).USE_PER_PROJECT_SETTINGS;
    }

    public static void setMainProjectSettings(@NotNull Project project, @NotNull CodeStyleSettings settings) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(51);
        }
        if (settings == null) {
            CodeStyle.$$$reportNull$$$0(52);
        }
        CodeStyleSettingsManager codeStyleSettingsManager = CodeStyleSettingsManager.getInstance(project);
        codeStyleSettingsManager.setMainProjectCodeStyle(settings);
        codeStyleSettingsManager.USE_PER_PROJECT_SETTINGS = true;
    }

    public static boolean isFormattingEnabled(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(53);
        }
        return !CodeStyle.getSettings(file).getExcludedFiles().contains(file);
    }

    public static void reformatWithFileContext(@NotNull PsiFile fileToReformat, @NotNull PsiFile contextFile) {
        if (fileToReformat == null) {
            CodeStyle.$$$reportNull$$$0(54);
        }
        if (contextFile == null) {
            CodeStyle.$$$reportNull$$$0(55);
        }
        Project project = contextFile.getProject();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        CodeStyleSettings realFileSettings = CodeStyle.getSettings(contextFile);
        CodeStyle.runWithLocalSettings(project, realFileSettings, () -> codeStyleManager.reformat((PsiElement)fileToReformat));
    }

    @TestOnly
    @NotNull
    public static CodeStyleSettings createTestSettings(@Nullable CodeStyleSettings baseSettings) {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.createTestSettings(baseSettings);
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(56);
        }
        return codeStyleSettings;
    }

    public static String getLineIndent(@NotNull Editor editor, @Nullable Language language, int offset, boolean allowDocCommit) {
        String indent;
        Project project;
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(57);
        }
        if ((project = editor.getProject()) == null) {
            return null;
        }
        LineIndentProvider lineIndentProvider = LineIndentProviderEP.findLineIndentProvider(language);
        String string = indent = lineIndentProvider != null ? lineIndentProvider.getLineIndent(project, editor, language, offset) : null;
        if (Strings.areSameInstance(indent, (String)LineIndentProvider.DO_NOT_ADJUST)) {
            return allowDocCommit ? null : indent;
        }
        return indent != null ? indent : (allowDocCommit ? CodeStyle.getLineIndent(project, editor.getDocument(), offset) : null);
    }

    @Nullable
    private static String getLineIndent(@Nullable Project project, @NotNull Document document, int offset) {
        if (document == null) {
            CodeStyle.$$$reportNull$$$0(58);
        }
        if (project == null) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        return CodeStyleManager.getInstance((Project)project).getLineIndent(document, offset);
    }

    public static int getJoinedLinesSpacing(@NotNull Editor editor, @Nullable Language language, int offset, boolean allowDocCommit) {
        int space;
        Project project;
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(59);
        }
        if ((project = editor.getProject()) == null) {
            return 0;
        }
        LineIndentProvider lineIndentProvider = LineIndentProviderEP.findLineIndentProvider(language);
        int n = space = lineIndentProvider instanceof JoinedLinesSpacingCalculator ? ((JoinedLinesSpacingCalculator)((Object)lineIndentProvider)).getJoinedLinesSpacing(project, editor, language, offset) : -1;
        if (space < 0 && allowDocCommit) {
            Document document = editor.getDocument();
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (file == null) {
                return 0;
            }
            return Math.max(0, CodeStyleManager.getInstance((Project)project).getSpacing(file, offset));
        }
        return Math.max(0, space);
    }

    @TestOnly
    @NotNull
    public static CodeStyleSettings createTestSettings() {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.createTestSettings(null);
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(60);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettingsFacade getFacade(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(61);
        }
        return new DefaultCodeStyleSettingsFacade(CodeStyle.getSettings(file), file.getFileType());
    }

    @NotNull
    public static CodeStyleSettingsFacade getFacade(@NotNull Project project, @NotNull Document document, @NotNull FileType fileType) {
        PsiFile psiFile;
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(62);
        }
        if (document == null) {
            CodeStyle.$$$reportNull$$$0(63);
        }
        if (fileType == null) {
            CodeStyle.$$$reportNull$$$0(64);
        }
        return new DefaultCodeStyleSettingsFacade((psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) == null ? CodeStyle.getSettings(project) : CodeStyle.getSettings(psiFile), fileType);
    }

    @NotNull
    public static CommonCodeStyleSettings getLocalLanguageSettings(@NotNull Editor editor, int offset) {
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(65);
        }
        PsiFile psiFile = PsiEditorUtil.getPsiFile((Editor)editor);
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)psiFile, (int)offset);
        return CodeStyle.getLanguageSettings(psiFile, language);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 22, 23, 25, 27, 28, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 57, 58, 59, 61, 62, 63, 64, 65 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyle";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 13: 
            case 27: 
            case 30: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 47: 
            case 50: 
            case 51: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 33: 
            case 53: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 31: 
            case 58: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 15: 
            case 16: 
            case 57: 
            case 59: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customSettingsClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 34: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSettings";
                break;
            }
            case 37: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 39: 
            case 42: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSettingsConsumer";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSettingsFunction";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempSettings";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempSettingsConsumer";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToReformat";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSettings";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyle";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
            case 21: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageSettings";
                break;
            }
            case 26: 
            case 29: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptions";
                break;
            }
            case 56: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCachedOrProjectSettings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocalOrTemporarySettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsPsi";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasLocalVirtualFile";
                break;
            }
            case 16: 
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageSettings";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptions";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getIndentSize";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setTemporarySettings";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "runWithLocalSettings";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "computeWithLocalSettings";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "doWithTemporarySettings";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "usesOwnSettings";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setMainProjectSettings";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isFormattingEnabled";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "reformatWithFileContext";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getJoinedLinesSpacing";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getFacade";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getLocalLanguageSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 22, 23, 25, 27, 28, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 57, 58, 59, 61, 62, 63, 64, 65 -> new IllegalArgumentException(string);
        };
    }
}

