/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.AppCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsService;
import com.intellij.psi.codeStyle.CodeStyleSettingsServiceListener;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsFactory;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsFactory;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import com.intellij.psi.codeStyle.ProjectCodeStyleSettingsManager;
import com.intellij.util.containers.WeakList;
import com.intellij.util.messages.MessageBus;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public class CodeStyleSettingsManager
implements PersistentStateComponentWithModificationTracker<Element> {
    private static final Logger LOG = Logger.getInstance(CodeStyleSettingsManager.class);
    @Deprecated(forRemoval=true)
    @Nullable
    public volatile CodeStyleSettings PER_PROJECT_SETTINGS;
    public volatile boolean USE_PER_PROJECT_SETTINGS;
    public volatile String PREFERRED_PROJECT_CODE_STYLE;
    private volatile CodeStyleSettings myTemporarySettings;
    private final ThreadLocal<CodeStyleSettings> myLocalSettings = new ThreadLocal();
    private static final WeakList<CodeStyleSettings> ourReferencedSettings = new WeakList();

    @NotNull
    public CodeStyleSettings createSettings() {
        CodeStyleSettings codeStyleSettings = this.createSettings(true);
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(0);
        }
        return codeStyleSettings;
    }

    @ApiStatus.Internal
    @NotNull
    public CodeStyleSettings createSettings(boolean loadExtensions) {
        CodeStyleSettings newSettings = new CodeStyleSettings(loadExtensions, false);
        CodeStyleSettingsManager.registerSettings(newSettings);
        CodeStyleSettings codeStyleSettings = newSettings;
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(1);
        }
        return codeStyleSettings;
    }

    static void registerSettings(@NotNull CodeStyleSettings newSettings) {
        if (newSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(2);
        }
        ourReferencedSettings.add((Object)newSettings);
    }

    @TestOnly
    @NotNull
    public final CodeStyleSettings createTemporarySettings() {
        CodeStyleSettings temporarySettings;
        this.myTemporarySettings = temporarySettings = new CodeStyleSettings(true, false);
        CodeStyleSettings codeStyleSettings = temporarySettings;
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(3);
        }
        return codeStyleSettings;
    }

    @NotNull
    public final CodeStyleSettings cloneSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(4);
        }
        CodeStyleSettings clonedSettings = new CodeStyleSettings(true, false);
        clonedSettings.copyFrom(settings);
        CodeStyleSettingsManager.registerSettings(clonedSettings);
        CodeStyleSettings codeStyleSettings = clonedSettings;
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(5);
        }
        return codeStyleSettings;
    }

    @TestOnly
    @NotNull
    public static CodeStyleSettings createTestSettings(@Nullable CodeStyleSettings baseSettings) {
        CodeStyleSettings testSettings = new CodeStyleSettings(true, false);
        if (baseSettings != null) {
            testSettings.copyFrom(baseSettings);
        }
        CodeStyleSettings codeStyleSettings = testSettings;
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(6);
        }
        return codeStyleSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithLocalSettings(@NotNull CodeStyleSettings localSettings, @NotNull Runnable runnable) {
        if (localSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(7);
        }
        if (runnable == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(8);
        }
        CodeStyleSettings tempSettingsBefore = this.myLocalSettings.get();
        try {
            this.myLocalSettings.set(localSettings);
            runnable.run();
        }
        finally {
            this.myLocalSettings.set(tempSettingsBefore);
        }
    }

    public void runWithLocalSettings(@NotNull CodeStyleSettings baseSettings, @NotNull @NotNull Consumer<? super @NotNull CodeStyleSettings> localSettingsConsumer) {
        if (baseSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(9);
        }
        if (localSettingsConsumer == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(10);
        }
        this.computeWithLocalSettings(baseSettings, localSettings -> {
            localSettingsConsumer.accept((CodeStyleSettings)localSettings);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T computeWithLocalSettings(@NotNull CodeStyleSettings baseSettings, @NotNull @NotNull Function<? super @NotNull CodeStyleSettings, T> localSettingsFunction) {
        if (baseSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(11);
        }
        if (localSettingsFunction == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(12);
        }
        CodeStyleSettings localSettingsBefore = this.myLocalSettings.get();
        try {
            CodeStyleSettings localSettings = new CodeStyleSettings(true, false);
            localSettings.copyFrom(baseSettings);
            this.myLocalSettings.set(localSettings);
            T t = localSettingsFunction.apply(localSettings);
            return t;
        }
        finally {
            this.myLocalSettings.set(localSettingsBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void doWithTemporarySettings(@NotNull CodeStyleSettings tempSettings, @NotNull Runnable runnable) {
        if (tempSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(13);
        }
        if (runnable == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(14);
        }
        CodeStyleSettings tempSettingsBefore = this.getTemporarySettings();
        try {
            this.setTemporarySettings(tempSettings);
            runnable.run();
        }
        finally {
            if (tempSettingsBefore != null) {
                this.setTemporarySettings(tempSettingsBefore);
            } else {
                this.dropTemporarySettings();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void doWithTemporarySettings(@NotNull CodeStyleSettings baseSettings, @NotNull Consumer<? super CodeStyleSettings> tempSettingsConsumer) {
        if (baseSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(15);
        }
        if (tempSettingsConsumer == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(16);
        }
        CodeStyleSettings tempSettingsBefore = this.getTemporarySettings();
        try {
            CodeStyleSettings tempSettings = this.createTemporarySettings();
            tempSettings.copyFrom(baseSettings);
            tempSettingsConsumer.accept(tempSettings);
        }
        finally {
            if (tempSettingsBefore != null) {
                this.setTemporarySettings(tempSettingsBefore);
            } else {
                this.dropTemporarySettings();
            }
        }
    }

    @NotNull
    private @Unmodifiable Collection<CodeStyleSettings> getAllSettings() {
        List list = ourReferencedSettings.toStrongList();
        if (list == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(17);
        }
        return list;
    }

    public long getStateModificationCount() {
        return this.enumSettings().stream().mapToLong(settings -> settings.getModificationTracker().getModificationCount()).sum();
    }

    public static CodeStyleSettingsManager getInstance(@Nullable Project project) {
        if (project == null || project.isDefault()) {
            return CodeStyleSettingsManager.getInstance();
        }
        return (CodeStyleSettingsManager)project.getService(ProjectCodeStyleSettingsManager.class);
    }

    public static CodeStyleSettingsManager getInstance() {
        return (CodeStyleSettingsManager)ApplicationManager.getApplication().getService(AppCodeStyleSettingsManager.class);
    }

    protected void registerExtensionPointListeners(@Nullable Disposable disposable) {
        FileIndentOptionsProvider.EP_NAME.addChangeListener(this::notifyCodeStyleSettingsChanged, disposable);
        CodeStyleSettingsService.getInstance().addListener(new CodeStyleSettingsServiceListener(){

            @Override
            public void fileTypeIndentOptionsFactoryAdded(@NotNull FileTypeIndentOptionsFactory factory) {
                if (factory == null) {
                    1.$$$reportNull$$$0(0);
                }
                CodeStyleSettingsManager.this.registerFileTypeIndentOptions(CodeStyleSettingsManager.this.getAllSettings(), factory.getFileType(), factory.createIndentOptions());
            }

            @Override
            public void fileTypeIndentOptionsFactoryRemoved(@NotNull FileTypeIndentOptionsFactory factory) {
                if (factory == null) {
                    1.$$$reportNull$$$0(1);
                }
                CodeStyleSettingsManager.this.unregisterFileTypeIndentOptions(CodeStyleSettingsManager.this.getAllSettings(), factory.getFileType());
            }

            @Override
            public void languageCodeStyleProviderAdded(@NotNull LanguageCodeStyleProvider provider) {
                if (provider == null) {
                    1.$$$reportNull$$$0(2);
                }
                CodeStyleSettingsManager.this.registerLanguageSettings(CodeStyleSettingsManager.this.getAllSettings(), provider);
                CodeStyleSettingsManager.this.registerCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), provider);
            }

            @Override
            public void languageCodeStyleProviderRemoved(@NotNull LanguageCodeStyleProvider provider) {
                if (provider == null) {
                    1.$$$reportNull$$$0(3);
                }
                CodeStyleSettingsManager.this.unregisterLanguageSettings(CodeStyleSettingsManager.this.getAllSettings(), provider);
                CodeStyleSettingsManager.this.unregisterCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), provider);
            }

            @Override
            public void customCodeStyleSettingsFactoryAdded(@NotNull CustomCodeStyleSettingsFactory factory) {
                if (factory == null) {
                    1.$$$reportNull$$$0(4);
                }
                CodeStyleSettingsManager.this.registerCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), factory);
            }

            @Override
            public void customCodeStyleSettingsFactoryRemoved(@NotNull CustomCodeStyleSettingsFactory factory) {
                if (factory == null) {
                    1.$$$reportNull$$$0(5);
                }
                CodeStyleSettingsManager.this.unregisterCustomSettings(CodeStyleSettingsManager.this.getAllSettings(), factory);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileTypeIndentOptionsFactoryAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileTypeIndentOptionsFactoryRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "languageCodeStyleProviderAdded";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "languageCodeStyleProviderRemoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "customCodeStyleSettingsFactoryAdded";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "customCodeStyleSettingsFactoryRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
    }

    @NotNull
    protected @Unmodifiable Collection<CodeStyleSettings> enumSettings() {
        List<CodeStyleSettings> list = Collections.emptyList();
        if (list == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(18);
        }
        return list;
    }

    @ApiStatus.Internal
    public final void registerFileTypeIndentOptions(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull FileType fileType, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(19);
        }
        if (fileType == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(20);
        }
        if (indentOptions == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(21);
        }
        allSettings.forEach(settings -> settings.registerAdditionalIndentOptions(fileType, indentOptions));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterFileTypeIndentOptions(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull FileType fileType) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(22);
        }
        if (fileType == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(23);
        }
        allSettings.forEach(settings -> settings.unregisterAdditionalIndentOptions(fileType));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void registerLanguageSettings(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull LanguageCodeStyleProvider provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(24);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(25);
        }
        allSettings.forEach(settings -> settings.registerCommonSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterLanguageSettings(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull LanguageCodeStyleProvider provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(26);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(27);
        }
        allSettings.forEach(settings -> settings.removeCommonSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void registerCustomSettings(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull CustomCodeStyleSettingsFactory provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(28);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(29);
        }
        allSettings.forEach(settings -> settings.registerCustomSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterCustomSettings(@NotNull Collection<? extends CodeStyleSettings> allSettings, @NotNull CustomCodeStyleSettingsFactory provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(30);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(31);
        }
        allSettings.forEach(settings -> settings.removeCustomSettings(provider));
        CodeStyleSettings.getDefaults().removeCustomSettings(provider);
        this.notifyCodeStyleSettingsChanged();
    }

    @Deprecated
    @NotNull
    public static CodeStyleSettings getSettings(@Nullable Project project) {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance(project).getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(32);
        }
        return codeStyleSettings;
    }

    @Deprecated
    @NotNull
    public CodeStyleSettings getCurrentSettings() {
        CodeStyleSettings localSettings = this.getLocalSettings();
        if (localSettings != null) {
            CodeStyleSettings codeStyleSettings = localSettings;
            if (codeStyleSettings == null) {
                CodeStyleSettingsManager.$$$reportNull$$$0(33);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings temporarySettings = this.myTemporarySettings;
        if (temporarySettings != null) {
            CodeStyleSettings codeStyleSettings = temporarySettings;
            if (codeStyleSettings == null) {
                CodeStyleSettingsManager.$$$reportNull$$$0(34);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings projectSettings = this.getMainProjectCodeStyle();
        if (this.USE_PER_PROJECT_SETTINGS && projectSettings != null) {
            CodeStyleSettings codeStyleSettings = projectSettings;
            if (codeStyleSettings == null) {
                CodeStyleSettingsManager.$$$reportNull$$$0(35);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSchemes.getInstance().findPreferredScheme(this.PREFERRED_PROJECT_CODE_STYLE).getCodeStyleSettings();
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(36);
        }
        return codeStyleSettings;
    }

    public Element getState() {
        Element result = new Element("state");
        try {
            DefaultJDOMExternalizer.write((Object)this, (Element)result, (Predicate)new DifferenceFilter<CodeStyleSettingsManager>(this, new CodeStyleSettingsManager()){

                public boolean test(@NotNull Field field) {
                    if (field == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return !CodeStyleSettingsManager.this.isIgnoredOnSave(field.getName()) && super.test(field);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/psi/codeStyle/CodeStyleSettingsManager$2", "test"));
                }
            });
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    protected boolean isIgnoredOnSave(@NotNull String fieldName) {
        if (fieldName == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(37);
        }
        return false;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(38);
        }
        try {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void setMainProjectCodeStyle(@Nullable CodeStyleSettings settings) {
        this.PER_PROJECT_SETTINGS = settings;
    }

    @Nullable
    public CodeStyleSettings getMainProjectCodeStyle() {
        return this.PER_PROJECT_SETTINGS;
    }

    @TestOnly
    public void setTemporarySettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(39);
        }
        this.myTemporarySettings = settings;
    }

    @TestOnly
    public void dropTemporarySettings() {
        this.myTemporarySettings = null;
    }

    @TestOnly
    @Nullable
    public CodeStyleSettings getTemporarySettings() {
        return this.myTemporarySettings;
    }

    @ApiStatus.Internal
    @Nullable
    public CodeStyleSettings getLocalSettings() {
        return this.myLocalSettings.get();
    }

    @NotNull
    protected MessageBus getMessageBus() {
        throw new UnsupportedOperationException("The method is not implemented");
    }

    public void subscribe(@NotNull CodeStyleSettingsListener listener, @NotNull Disposable disposable) {
        if (listener == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(40);
        }
        if (disposable == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(41);
        }
        this.getMessageBus().connect(disposable).subscribe(CodeStyleSettingsListener.TOPIC, (Object)listener);
    }

    public void subscribe(@NotNull CodeStyleSettingsListener listener) {
        if (listener == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(42);
        }
        this.getMessageBus().connect().subscribe(CodeStyleSettingsListener.TOPIC, (Object)listener);
    }

    @ApiStatus.Internal
    public void fireCodeStyleSettingsChanged(@NotNull VirtualFile file, @Nullable CodeStyleSettings settings) {
        if (file == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(43);
        }
        if (this.getProject() != null) {
            this.fireCodeStyleSettingsChanged(new CodeStyleSettingsChangeEvent(this.getProject(), file, settings));
        }
    }

    public void fireCodeStyleSettingsChanged(@NotNull VirtualFile file) {
        if (file == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(44);
        }
        this.fireCodeStyleSettingsChanged(file, null);
    }

    public void fireCodeStyleSettingsChanged() {
        if (this.getProject() != null) {
            this.fireCodeStyleSettingsChanged(new CodeStyleSettingsChangeEvent(this.getProject(), null));
        }
    }

    private void fireCodeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        MessageBus bus;
        if (event == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(45);
        }
        if (!(bus = this.getMessageBus()).isDisposed()) {
            ((CodeStyleSettingsListener)bus.syncPublisher(CodeStyleSettingsListener.TOPIC)).codeStyleSettingsChanged(event);
        }
    }

    @Nullable
    protected Project getProject() {
        ProjectManager projectManager = ProjectManager.getInstance();
        return projectManager != null ? projectManager.getDefaultProject() : null;
    }

    public final void notifyCodeStyleSettingsChanged() {
        this.updateSettingsTracker();
        this.fireCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public void updateSettingsTracker() {
        CodeStyleSettings settings = this.getCurrentSettings();
        settings.getModificationTracker().incModificationCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated code style settings modification tracker to " + settings.getModificationTracker().getModificationCount());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 37, 38, 39, 40, 41, 42, 43, 44, 45 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettingsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSettings";
                break;
            }
            case 4: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSettings";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSettingsConsumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSettingsFunction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempSettings";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempSettingsConsumer";
                break;
            }
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSettings";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporarySettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestSettings";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSettings";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "enumSettings";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cloneSettings";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runWithLocalSettings";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeWithLocalSettings";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doWithTemporarySettings";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypeIndentOptions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileTypeIndentOptions";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "registerLanguageSettings";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "unregisterLanguageSettings";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomSettings";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "unregisterCustomSettings";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredOnSave";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setTemporarySettings";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "fireCodeStyleSettingsChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 37, 38, 39, 40, 41, 42, 43, 44, 45 -> new IllegalArgumentException(string);
        };
    }
}

