/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface ExternalFormatProcessor {
    public static final ExtensionPointName<ExternalFormatProcessor> EP_NAME = ExtensionPointName.create((String)"com.intellij.externalFormatProcessor");

    public boolean activeForFile(@NotNull PsiFile var1);

    @Nullable
    public TextRange format(@NotNull PsiFile var1, @NotNull TextRange var2, boolean var3, boolean var4, boolean var5, int var6);

    @Nullable
    public String indent(@NotNull PsiFile var1, int var2);

    default public void createConfiguration(@NotNull Project project) {
        if (project == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(0);
        }
    }

    @NonNls
    @NotNull
    public String getId();

    public static boolean useExternalFormatter(@NotNull PsiFile source) {
        if (source == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(1);
        }
        return ContainerUtil.exists((Iterable)EP_NAME.getExtensionList(), efp -> efp.activeForFile(source));
    }

    @NotNull
    public static Optional<ExternalFormatProcessor> findExternalFormatter(@NonNls @NotNull String externalFormatterId) {
        if (externalFormatterId == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(2);
        }
        Optional<ExternalFormatProcessor> optional = EP_NAME.getExtensionList().stream().filter(efp -> externalFormatterId.equals(efp.getId())).findFirst();
        if (optional == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(3);
        }
        return optional;
    }

    @Nullable
    public static ExternalFormatProcessor activeExternalFormatProcessor(@NotNull PsiFile source) {
        List activeExternalFormatProcessors;
        if (source == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(4);
        }
        if ((activeExternalFormatProcessors = ContainerUtil.filter((Collection)EP_NAME.getExtensionList(), efp -> efp.activeForFile(source))).size() > 1) {
            Logger log = Logger.getInstance(ExternalFormatProcessor.class);
            log.warn("More than one active external format processor found for " + source.getName());
        }
        return (ExternalFormatProcessor)ContainerUtil.getFirstItem((List)activeExternalFormatProcessors);
    }

    @Nullable
    public static String indentLine(@NotNull PsiFile source, int lineStartOffset) {
        ExternalFormatProcessor efp;
        if (source == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(5);
        }
        return (efp = ExternalFormatProcessor.activeExternalFormatProcessor(source)) != null ? efp.indent(source, lineStartOffset) : null;
    }

    @Nullable
    public static TextRange formatRangeInFile(@NotNull PsiFile source, @NotNull TextRange range, boolean canChangeWhiteSpacesOnly, boolean keepLineBreaks, boolean enableBulkUpdate, int cursorOffset) {
        ExternalFormatProcessor efp;
        if (source == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(6);
        }
        if (range == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(7);
        }
        return (efp = ExternalFormatProcessor.activeExternalFormatProcessor(source)) != null ? efp.format(source, range, canChangeWhiteSpacesOnly, keepLineBreaks, enableBulkUpdate, cursorOffset) : null;
    }

    @Nullable
    public static TextRange formatRangeInFile(@NotNull PsiFile source, @NotNull TextRange range, boolean canChangeWhiteSpacesOnly, boolean keepLineBreaks) {
        if (source == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(8);
        }
        if (range == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(9);
        }
        return ExternalFormatProcessor.formatRangeInFile(source, range, canChangeWhiteSpacesOnly, keepLineBreaks, true, -1);
    }

    @NotNull
    public static PsiElement formatElement(@NotNull PsiElement elementToFormat, @NotNull TextRange range, boolean canChangeWhiteSpacesOnly) {
        TextRange rangeAfterFormat;
        PsiFile file;
        Document document;
        if (elementToFormat == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(10);
        }
        if (range == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(11);
        }
        if ((document = (file = elementToFormat.getContainingFile()).getViewProvider().getDocument()) != null && (rangeAfterFormat = ExternalFormatProcessor.formatRangeInFile(file, range, canChangeWhiteSpacesOnly, false)) != null) {
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            if (!elementToFormat.isValid()) {
                PsiElement elementAtStart = file.findElementAt(rangeAfterFormat.getStartOffset());
                if (elementAtStart instanceof PsiWhiteSpace) {
                    elementAtStart = PsiTreeUtil.nextLeaf((PsiElement)elementAtStart);
                }
                if (elementAtStart != null) {
                    PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)elementAtStart, (Class)elementToFormat.getClass());
                    if (parent != null) {
                        PsiElement psiElement = parent;
                        if (psiElement == null) {
                            ExternalFormatProcessor.$$$reportNull$$$0(12);
                        }
                        return psiElement;
                    }
                    PsiElement psiElement = elementAtStart;
                    if (psiElement == null) {
                        ExternalFormatProcessor.$$$reportNull$$$0(13);
                    }
                    return psiElement;
                }
            }
        }
        PsiElement psiElement = elementToFormat;
        if (psiElement == null) {
            ExternalFormatProcessor.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalFormatterId";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/ExternalFormatProcessor";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/ExternalFormatProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalFormatter";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "formatElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "useExternalFormatter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findExternalFormatter";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "activeExternalFormatProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "indentLine";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatRangeInFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formatElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

