/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.service;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.FormattingService;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDocumentFormattingService
implements FormattingService {
    private static final Key<Document> DOCUMENT_KEY = Key.create((String)"formatting.service.document");

    @Override
    @NotNull
    public final PsiElement formatElement(@NotNull PsiElement element, boolean canChangeWhiteSpaceOnly) {
        if (element == null) {
            AbstractDocumentFormattingService.$$$reportNull$$$0(0);
        }
        return this.formatElement(element, element.getTextRange(), canChangeWhiteSpaceOnly);
    }

    @Override
    @NotNull
    public final PsiElement formatElement(@NotNull PsiElement element, @NotNull TextRange range, boolean canChangeWhiteSpaceOnly) {
        if (element == null) {
            AbstractDocumentFormattingService.$$$reportNull$$$0(1);
        }
        if (range == null) {
            AbstractDocumentFormattingService.$$$reportNull$$$0(2);
        }
        PsiFile file = element.getContainingFile();
        FormattingContext formattingContext = FormattingContext.create((PsiElement)file, range, CodeStyle.getSettings(file), FormattingMode.REFORMAT);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        Document document = documentManager.getDocument(file);
        if (document == null) {
            document = (Document)file.getUserData(DOCUMENT_KEY);
        }
        if (document != null) {
            int offset = element.getTextOffset();
            this.formatDocument(document, Collections.singletonList(range), formattingContext, canChangeWhiteSpaceOnly, false);
            documentManager.commitDocument(document);
            PsiElement resultingElement = file.findElementAt(offset);
            if (resultingElement != null) {
                PsiElement psiElement = resultingElement;
                if (psiElement == null) {
                    AbstractDocumentFormattingService.$$$reportNull$$$0(3);
                }
                return psiElement;
            }
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            AbstractDocumentFormattingService.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @Override
    public final void formatRanges(@NotNull PsiFile file, FormattingRangesInfo rangesInfo, boolean canChangeWhiteSpaceOnly, boolean quickFormat) {
        if (file == null) {
            AbstractDocumentFormattingService.$$$reportNull$$$0(5);
        }
        TextRange boundRange = (TextRange)ObjectUtils.notNull((Object)rangesInfo.getBoundRange(), (Object)file.getTextRange());
        FormattingContext formattingContext = FormattingContext.create((PsiElement)file, boundRange, CodeStyle.getSettings(file), FormattingMode.REFORMAT);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        Document document = documentManager.getDocument(file);
        if (document != null) {
            this.formatDocument(document, rangesInfo.getTextRanges(), formattingContext, canChangeWhiteSpaceOnly, quickFormat);
            documentManager.commitDocument(document);
        }
    }

    public abstract void formatDocument(@NotNull Document var1, @NotNull List<TextRange> var2, @NotNull FormattingContext var3, boolean var4, boolean var5);

    @ApiStatus.Internal
    public static void setDocument(@NotNull PsiFile file, @NotNull Document document) {
        if (file == null) {
            AbstractDocumentFormattingService.$$$reportNull$$$0(6);
        }
        if (document == null) {
            AbstractDocumentFormattingService.$$$reportNull$$$0(7);
        }
        file.putUserData(DOCUMENT_KEY, (Object)document);
    }

    @Override
    @NotNull
    public Set<ImportOptimizer> getImportOptimizers(@NotNull PsiFile file) {
        if (file == null) {
            AbstractDocumentFormattingService.$$$reportNull$$$0(8);
        }
        Set<ImportOptimizer> set = Collections.emptySet();
        if (set == null) {
            AbstractDocumentFormattingService.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/service/AbstractDocumentFormattingService";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/service/AbstractDocumentFormattingService";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "formatElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportOptimizers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatElement";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatRanges";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setDocument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getImportOptimizers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 9 -> new IllegalStateException(string);
        };
    }
}

